/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.beans;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.bndly.code.common.CodeGenerationContext;
import org.bndly.code.model.CodeBlock;
import org.bndly.code.model.CodeBracket;
import org.bndly.code.model.CodeImport;
import org.bndly.code.model.CodeLine;
import org.bndly.code.renderer.ImportResolver;
import org.bndly.schema.beans.AbstractSchemaBasedBeanGeneratorMojo;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.BinaryAttribute;
import org.bndly.schema.model.BooleanAttribute;
import org.bndly.schema.model.CryptoAttribute;
import org.bndly.schema.model.DateAttribute;
import org.bndly.schema.model.DecimalAttribute;
import org.bndly.schema.model.InverseAttribute;
import org.bndly.schema.model.JSONAttribute;
import org.bndly.schema.model.Mixin;
import org.bndly.schema.model.MixinAttribute;
import org.bndly.schema.model.NamedAttributeHolder;
import org.bndly.schema.model.NamedAttributeHolderAttribute;
import org.bndly.schema.model.Schema;
import org.bndly.schema.model.SchemaUtil;
import org.bndly.schema.model.StringAttribute;
import org.bndly.schema.model.Type;

@Mojo(name="generateXmlBeans")
public class XmlSchemaBeanGeneratorMojo
extends AbstractSchemaBasedBeanGeneratorMojo {
    @Parameter(defaultValue="false")
    protected boolean prefixingEnabled;

    @Override
    protected void doCodeGenerationWithSchema(Schema schema, CodeGenerationContext ctx, File targetPath) throws IOException, MojoExecutionException, MojoFailureException {
        ctx.setImportResolver(new ImportResolver(){

            public String resolveImport(String simpleName) {
                if (simpleName == null) {
                    throw new IllegalArgumentException("can not resolve import when simpleName is null.");
                }
                return simpleName;
            }
        });
        List types = schema.getTypes();
        if (types != null) {
            CodeBlock provider = (CodeBlock)ctx.create(CodeBlock.class);
            provider.line("package ").append(ctx.getBasePackage()).append(";");
            CodeBlock importBlock = (CodeBlock)provider.createContained(CodeBlock.class);
            importBlock.line("import " + Collection.class.getName() + ";");
            importBlock.line("import " + HashSet.class.getName() + ";");
            importBlock.line("import org.bndly.rest.atomlink.api.JAXBMessageClassProvider;");
            importBlock.line("import org.osgi.service.component.annotations.Component;");
            provider.line("@Component(service = JAXBMessageClassProvider.class, immediate = true, property = {\"schema=" + schema.getName() + "\",\"schemaRestBeanPackage=" + ctx.getBasePackage() + "\",\"schemaRestBeanProvider:Boolean=true\"})");
            provider.line("public class JAXBMessageClassProviderImpl implements JAXBMessageClassProvider");
            CodeBracket classContent = (CodeBracket)provider.createContained(CodeBracket.class);
            classContent.line("private final static Collection<Class<?>> classes;");
            classContent.line("static");
            CodeBracket initBlock = (CodeBracket)classContent.createContained(CodeBracket.class);
            initBlock.line("classes = new HashSet<>();");
            classContent.line("@Override");
            classContent.line("public Collection<Class<?>> getJAXBMessageClasses()");
            ((CodeBracket)classContent.createContained(CodeBracket.class)).line("return classes;");
            for (Type type : types) {
                CodeBlock code;
                if (!type.isAbstract()) {
                    initBlock.line("classes.add(" + type.getName() + "RestBean.class);");
                    this.importStateHolder.reset();
                    code = this.generateRestBeanCodeForType(type, ctx);
                    this.writeCodeToFile(code, targetPath, (NamedAttributeHolder)type, "RestBean");
                }
                this.importStateHolder.reset();
                code = this.generateReferenceRestBeanCodeForType(type, ctx);
                initBlock.line("classes.add(" + type.getName() + "ReferenceRestBean.class);");
                this.writeCodeToFile(code, targetPath, (NamedAttributeHolder)type, "ReferenceRestBean");
                this.importStateHolder.reset();
                code = this.generateListRestBeanCodeForType(type, ctx);
                initBlock.line("classes.add(" + type.getName() + "ListRestBean.class);");
                this.writeCodeToFile(code, targetPath, (NamedAttributeHolder)type, "ListRestBean");
            }
            this.writeCodeToFile(provider, targetPath, "JAXBMessageClassProviderImpl.java");
        }
    }

    private CodeBlock generateListRestBeanCodeForType(Type type, CodeGenerationContext ctx) {
        this.getLog().info((CharSequence)("generating reference java class for type " + type.getName()));
        CodeBlock block = (CodeBlock)ctx.create(CodeBlock.class);
        CodeBlock importBlock = this.createClassBaseBlock(block, ctx.getBasePackage(), this.getTypeXmlElementName(type, PrefixingMode.DEFAULT) + "List", this.getTypeXmlElementName(type, PrefixingMode.ENFORCE) + "List");
        CodeLine l = block.line("public class ").append(type.getName()).append("ListRestBean");
        this.assertIsImported(importBlock, "org.bndly.rest.common.beans.ListRestBean");
        l.append(" extends ").append("ListRestBean<").append(type.getName()).append("ReferenceRestBean>");
        CodeBracket bracket = (CodeBracket)block.createContained(CodeBracket.class);
        CodeBlock fieldBlock = (CodeBlock)bracket.createContained(CodeBlock.class);
        this.appendXmlElementsForEachType(fieldBlock, null, importBlock, (NamedAttributeHolder)type);
        this.assertIsImported(importBlock, List.class);
        fieldBlock.line("private List<").append(type.getName()).append("ReferenceRestBean> items;");
        CodeBlock methodBlock = (CodeBlock)bracket.createContained(CodeBlock.class);
        methodBlock.line("@Override");
        methodBlock.line("public void setItems(List<").append(type.getName()).append("ReferenceRestBean> items) ");
        ((CodeBracket)methodBlock.createContained(CodeBracket.class)).line("this.items = items;");
        methodBlock.line("@Override");
        methodBlock.line("public List<").append(type.getName()).append("ReferenceRestBean> getItems() ");
        ((CodeBracket)methodBlock.createContained(CodeBracket.class)).line("return items;");
        return block;
    }

    private CodeBlock generateReferenceRestBeanCodeForType(Type type, CodeGenerationContext ctx) {
        String extendedTypeName;
        this.getLog().info((CharSequence)("generating reference java class for type " + type.getName()));
        CodeBlock block = (CodeBlock)ctx.create(CodeBlock.class);
        CodeBlock importBlock = this.createClassBaseBlock(block, ctx.getBasePackage(), this.getTypeXmlElementName(type, PrefixingMode.DEFAULT) + "Ref", this.getTypeXmlElementName(type, PrefixingMode.ENFORCE) + "Ref");
        if (!type.isAbstract()) {
            this.assertIsImported(importBlock, "org.bndly.rest.atomlink.api.annotation.Reference");
            block.line("@Reference");
        }
        CodeLine l = block.line("public");
        if (type.isAbstract()) {
            l.append(" abstract");
        }
        l.append(" class ").append(type.getName()).append("ReferenceRestBean");
        if (type.getSuperType() != null) {
            extendedTypeName = type.getSuperType().getName() + "ReferenceRestBean";
        } else {
            this.assertIsImported(importBlock, "org.bndly.rest.common.beans.RestBean");
            extendedTypeName = "RestBean";
        }
        l.append(" extends ").append(extendedTypeName);
        CodeBracket bracket = (CodeBracket)block.createContained(CodeBracket.class);
        if (!type.isAbstract() && !type.isVirtual()) {
            CodeBlock fieldBlock = (CodeBlock)bracket.createContained(CodeBlock.class);
            this.assertIsImported(importBlock, XmlElement.class);
            this.assertIsImported(importBlock, "org.bndly.rest.atomlink.api.annotation.BeanID");
            fieldBlock.line("@XmlElement");
            fieldBlock.line("@BeanID");
            fieldBlock.line("private Long id;");
            CodeBlock methodBlock = (CodeBlock)bracket.createContained(CodeBlock.class);
            methodBlock.line("public void setId(Long id) ");
            ((CodeBracket)methodBlock.createContained(CodeBracket.class)).line("this.id = id;");
            methodBlock.line("public Long getId() ");
            ((CodeBracket)methodBlock.createContained(CodeBracket.class)).line("return id;");
        }
        return block;
    }

    private CodeBlock generateRestBeanCodeForType(Type type, CodeGenerationContext ctx) {
        this.getLog().info((CharSequence)("generating java class for type " + type.getName()));
        CodeBlock block = (CodeBlock)ctx.create(CodeBlock.class);
        CodeBlock importBlock = this.createClassBaseBlock(block, ctx.getBasePackage(), this.getTypeXmlElementName(type, PrefixingMode.DEFAULT), this.getTypeXmlElementName(type, PrefixingMode.ENFORCE));
        CodeLine l = block.line("public");
        if (type.isAbstract()) {
            l.append(" abstract");
        }
        this.assertIsImported(importBlock, "org.bndly.rest.common.beans.SmartReferable");
        l.append(" class ").append(type.getName()).append("RestBean").append(" extends ").append(type.getName()).append("ReferenceRestBean").append(" implements ").append("SmartReferable");
        CodeBracket bracket = (CodeBracket)block.createContained(CodeBracket.class);
        CodeBlock fieldBlock = (CodeBlock)bracket.createContained(CodeBlock.class);
        CodeBlock methodBlock = (CodeBlock)bracket.createContained(CodeBlock.class);
        this.generateSmartReferenceImplementation(fieldBlock, methodBlock, importBlock);
        this.generateFieldAndGetterAndSetter((NamedAttributeHolder)type, fieldBlock, methodBlock, importBlock);
        return block;
    }

    private CodeBlock createClassBaseBlock(CodeBlock block, String packageName, String typeElementName, String xmlTypeName) {
        block.line("package ").append(packageName).append(";");
        CodeBlock importBlock = (CodeBlock)block.createContained(CodeBlock.class);
        this.assertIsImported(importBlock, XmlType.class);
        this.assertIsImported(importBlock, XmlRootElement.class);
        this.assertIsImported(importBlock, XmlAccessorType.class);
        this.assertIsImported(importBlock, XmlAccessType.class);
        block.line("@XmlType(name=\"").append(xmlTypeName).append("\")");
        block.line("@XmlRootElement(name=\"").append(typeElementName).append("\")");
        block.line("@XmlAccessorType(XmlAccessType.NONE)");
        return importBlock;
    }

    private String getJavaTypeNameForAttribute(Attribute attribute, CodeBlock importBlock) {
        if (StringAttribute.class.isInstance(attribute)) {
            return "String";
        }
        if (CryptoAttribute.class.isInstance(attribute)) {
            return "String";
        }
        if (DecimalAttribute.class.isInstance(attribute)) {
            Integer length;
            DecimalAttribute att = (DecimalAttribute)DecimalAttribute.class.cast(attribute);
            Integer dp = att.getDecimalPlaces();
            if (dp == null) {
                dp = 0;
            }
            if ((length = att.getLength()) == null) {
                if (dp == 0) {
                    return "Long";
                }
                return "Double";
            }
            this.assertIsImported(importBlock, BigDecimal.class);
            return "BigDecimal";
        }
        if (BooleanAttribute.class.isInstance(attribute)) {
            return "Boolean";
        }
        if (DateAttribute.class.isInstance(attribute)) {
            this.assertIsImported(importBlock, Date.class);
            return "Date";
        }
        if (NamedAttributeHolderAttribute.class.isInstance(attribute)) {
            NamedAttributeHolderAttribute att = (NamedAttributeHolderAttribute)NamedAttributeHolderAttribute.class.cast(attribute);
            return att.getNamedAttributeHolder().getName() + "ReferenceRestBean";
        }
        if (InverseAttribute.class.isInstance(attribute)) {
            InverseAttribute att = (InverseAttribute)InverseAttribute.class.cast(attribute);
            return att.getReferencedAttributeHolder().getName() + "ListRestBean";
        }
        if (JSONAttribute.class.isInstance(attribute)) {
            JSONAttribute att = (JSONAttribute)JSONAttribute.class.cast(attribute);
            return att.getNamedAttributeHolder().getName() + "RestBean";
        }
        throw new IllegalArgumentException("unsupported attribute type");
    }

    private void generateFieldAndGetterAndSetter(NamedAttributeHolder nah, CodeBlock fieldBlock, CodeBlock methodBlock, CodeBlock importBlock) {
        List atts = SchemaUtil.collectAttributes((NamedAttributeHolder)nah);
        if (atts != null) {
            for (Attribute attribute : atts) {
                InverseAttribute ia;
                NamedAttributeHolder rah;
                if (BinaryAttribute.class.isInstance(attribute) && !JSONAttribute.class.isInstance(attribute) || attribute.isVirtual() && (MixinAttribute.class.isInstance(attribute) || InverseAttribute.class.isInstance(attribute) && (rah = (ia = (InverseAttribute)attribute).getReferencedAttributeHolder()).isVirtual() && Mixin.class.isInstance(rah))) continue;
                String javaTypeName = this.getJavaTypeNameForAttribute(attribute, importBlock);
                String ucAttributeName = attribute.getName();
                ucAttributeName = ucAttributeName.length() > 1 ? ucAttributeName.substring(0, 1).toUpperCase() + ucAttributeName.substring(1) : ucAttributeName.toUpperCase();
                if (NamedAttributeHolderAttribute.class.isInstance(attribute)) {
                    this.assertIsImported(importBlock, XmlElements.class);
                    NamedAttributeHolder holder = ((NamedAttributeHolderAttribute)NamedAttributeHolderAttribute.class.cast(attribute)).getNamedAttributeHolder();
                    if (Mixin.class.isInstance(holder)) {
                        javaTypeName = Object.class.getSimpleName();
                    }
                    this.appendXmlElementsForEachType(fieldBlock, (NamedAttributeHolderAttribute)attribute, importBlock, holder);
                } else {
                    this.assertIsImported(importBlock, XmlElement.class);
                    fieldBlock.line("@XmlElement");
                }
                fieldBlock.line("private ").append(javaTypeName).append(" ").append(attribute.getName()).append(";");
                methodBlock.line("public ").append(javaTypeName).append(" get").append(ucAttributeName).append("()");
                ((CodeBracket)methodBlock.createContained(CodeBracket.class)).line("return ").append(attribute.getName()).append(";");
                methodBlock.line("public void set").append(ucAttributeName).append("(").append(javaTypeName).append(" ").append(attribute.getName()).append(")");
                ((CodeBracket)methodBlock.createContained(CodeBracket.class)).line("this.").append(attribute.getName()).append("=").append(attribute.getName()).append(";");
            }
        }
    }

    private boolean appendExtendedAttributeHolder(boolean first, CodeLine l, NamedAttributeHolder nah) {
        if (first) {
            first = false;
            l.append(" extends ");
        } else {
            l.append(", ");
        }
        l.append(nah.getName());
        l.append("RestBean");
        return first;
    }

    private void assertIsImported(CodeBlock importBlock, Class<?> typeToImport) {
        this.assertIsImported(importBlock, typeToImport.getName());
    }

    private void assertIsImported(CodeBlock importBlock, String fullName) {
        if (!this.importStateHolder.hasBeenImported(fullName)) {
            importBlock.createContained(CodeImport.class, new Object[]{fullName});
        }
    }

    private CodeLine appendXmlElementForType(NamedAttributeHolderAttribute attribute, Type type, CodeBlock fieldBlock, CodeLine prevLine, CodeBlock importBlock) {
        CodeLine l = prevLine;
        if (!type.isAbstract()) {
            if (prevLine != null) {
                prevLine.append(",");
            }
            this.assertIsImported(importBlock, XmlElement.class);
            String typeElementName = this.getTypeXmlElementName(type, PrefixingMode.SKIP);
            if (attribute != null) {
                typeElementName = attribute.getName() + typeElementName.substring(0, 1).toUpperCase() + typeElementName.substring(1);
            }
            fieldBlock.line("@XmlElement(name=\"").append(typeElementName).append("Ref\", type=").append(type.getName()).append("ReferenceRestBean.class),");
            l = fieldBlock.line("@XmlElement(name=\"").append(typeElementName).append("\", type=").append(type.getName()).append("RestBean.class)");
        }
        if (type.getSubTypes() != null) {
            for (Type type1 : type.getSubTypes()) {
                l = this.appendXmlElementForType(attribute, type1, fieldBlock, l, importBlock);
            }
        }
        return l;
    }

    private String getTypeXmlElementName(Type type, PrefixingMode prefixingMode) {
        String typeElementName = type.getName();
        typeElementName = typeElementName.length() > 1 ? typeElementName.substring(0, 1).toLowerCase() + typeElementName.substring(1) : typeElementName.toLowerCase();
        if (prefixingMode == PrefixingMode.SKIP || prefixingMode == PrefixingMode.DEFAULT && !this.prefixingEnabled) {
            return typeElementName;
        }
        return type.getSchema().getName() + "_" + typeElementName;
    }

    private void appendXmlElementsForEachType(CodeBlock fieldBlock, NamedAttributeHolderAttribute attribute, CodeBlock importBlock, NamedAttributeHolder holder) {
        Mixin m;
        List l;
        this.assertIsImported(importBlock, XmlElements.class);
        fieldBlock.line("@XmlElements({");
        ArrayList<Type> possibleTypes = new ArrayList<Type>();
        if (Type.class.isInstance(holder)) {
            Type t = (Type)Type.class.cast(holder);
            possibleTypes.add(t);
        } else if (Mixin.class.isInstance(holder) && (l = (m = (Mixin)Mixin.class.cast(holder)).getMixedInto()) != null) {
            possibleTypes.addAll(l);
        }
        CodeLine l2 = null;
        for (Type type : possibleTypes) {
            l2 = this.appendXmlElementForType(attribute, type, fieldBlock, l2, importBlock);
        }
        fieldBlock.line("})");
    }

    private void generateSmartReferenceImplementation(CodeBlock fieldBlock, CodeBlock methodBlock, CodeBlock importBlock) {
        this.assertIsImported(importBlock, XmlAttribute.class);
        fieldBlock.line("@XmlAttribute");
        fieldBlock.line("private Boolean smartRef;");
        methodBlock.line("@Override");
        methodBlock.line("public Boolean getSmartRef()");
        ((CodeBracket)methodBlock.createContained(CodeBracket.class)).line("return smartRef;");
        methodBlock.line("@Override");
        methodBlock.line("public void setSmartRef(Boolean smartRef)");
        ((CodeBracket)methodBlock.createContained(CodeBracket.class)).line("this.smartRef = smartRef;");
    }

    private static enum PrefixingMode {
        DEFAULT,
        SKIP,
        ENFORCE;

    }
}

