/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.Mixin;
import org.bndly.schema.model.NamedAttributeHolder;
import org.bndly.schema.model.Type;

public final class SchemaUtil {
    private SchemaUtil() {
    }

    public static Map<String, Attribute> collectAttributesAsMap(NamedAttributeHolder namedAttributeHolder) {
        return SchemaUtil.collectAttributesAsMap(namedAttributeHolder, new HashMap<String, Attribute>());
    }

    private static Map<String, Attribute> collectAttributesAsMap(NamedAttributeHolder namedAttributeHolder, Map<String, Attribute> map) {
        if (namedAttributeHolder != null) {
            List<Attribute> atts = namedAttributeHolder.getAttributes();
            if (atts != null) {
                for (Attribute attribute : atts) {
                    map.put(attribute.getName(), attribute);
                }
            }
            if (Type.class.isInstance(namedAttributeHolder)) {
                Type type = (Type)namedAttributeHolder;
                List<Mixin> mixins = type.getMixins();
                if (mixins != null) {
                    for (Mixin mixin : mixins) {
                        List<Attribute> mixinAtts = mixin.getAttributes();
                        if (mixinAtts == null) continue;
                        for (Attribute attribute : mixinAtts) {
                            map.put(attribute.getName(), attribute);
                        }
                    }
                }
                SchemaUtil.collectAttributesAsMap(type.getSuperType(), map);
            }
        }
        return map;
    }

    public static List<Attribute> collectAttributes(NamedAttributeHolder namedAttributeHolder) {
        return SchemaUtil.collectAttributes(namedAttributeHolder, new ArrayList<Attribute>());
    }

    private static List<Attribute> collectAttributes(NamedAttributeHolder namedAttributeHolder, List<Attribute> attributes) {
        if (namedAttributeHolder != null) {
            List<Attribute> atts = namedAttributeHolder.getAttributes();
            if (atts != null) {
                attributes.addAll(atts);
            }
            if (Type.class.isInstance(namedAttributeHolder)) {
                Type type = (Type)namedAttributeHolder;
                List<Mixin> mixins = type.getMixins();
                if (mixins != null) {
                    for (Mixin mixin : mixins) {
                        List<Attribute> mixinAtts = mixin.getAttributes();
                        if (mixinAtts == null) continue;
                        attributes.addAll(mixinAtts);
                    }
                }
                SchemaUtil.collectAttributes(type.getSuperType(), attributes);
            }
        }
        return attributes;
    }
}

