/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.BinaryAttribute;
import org.bndly.schema.model.InverseAttribute;
import org.bndly.schema.model.JSONAttribute;
import org.bndly.schema.model.Mixin;
import org.bndly.schema.model.MixinAttribute;
import org.bndly.schema.model.NamedAttributeHolder;
import org.bndly.schema.model.NamedAttributeHolderAttribute;
import org.bndly.schema.model.Schema;
import org.bndly.schema.model.SchemaProvider;
import org.bndly.schema.model.SchemaUtil;
import org.bndly.schema.model.Type;
import org.bndly.schema.model.TypeAttribute;
import org.bndly.schema.model.UniqueConstraint;

public class SchemaBuilder
implements SchemaProvider {
    private final Schema schema;
    private final Map<String, NamedAttributeHolder> namedAttributeHoldersByName;
    private final Map<String, Type> typesByName;
    private final Map<String, Mixin> mixinsByName;
    private final List<InverseAttribute> inverseAttributes;
    private NamedAttributeHolder currentAttributeHolder;
    private Type currentType;
    private Mixin currentMixin;
    private Attribute currentAttribute;

    public SchemaBuilder(String name, String namespace) {
        this.schema = new Schema(name, namespace);
        this.typesByName = new HashMap<String, Type>();
        this.mixinsByName = new HashMap<String, Mixin>();
        this.namedAttributeHoldersByName = new HashMap<String, NamedAttributeHolder>();
        this.inverseAttributes = new ArrayList<InverseAttribute>();
    }

    @Override
    public String getSchemaName() {
        return this.schema.getName();
    }

    @Override
    public Schema getSchema() {
        for (InverseAttribute inverseAttribute : this.inverseAttributes) {
            Map<String, Attribute> atts = SchemaUtil.collectAttributesAsMap(inverseAttribute.getReferencedAttributeHolder());
            NamedAttributeHolderAttribute namedAttributeHolderAttribute = null;
            Attribute att = atts.get(inverseAttribute.getReferencedAttributeName());
            if (NamedAttributeHolderAttribute.class.isInstance(att)) {
                namedAttributeHolderAttribute = (NamedAttributeHolderAttribute)att;
            }
            if (namedAttributeHolderAttribute == null && !inverseAttribute.isVirtual()) {
                throw new IllegalStateException("could not find referenced attribute for inverse attribute");
            }
            inverseAttribute.setReferencedAttribute(namedAttributeHolderAttribute);
        }
        return this.schema;
    }

    public SchemaBuilder abstractType() {
        this.currentType.setAbstract(true);
        return this;
    }

    public SchemaBuilder abstractType(String name) {
        this.type(name);
        return this.abstractType();
    }

    public SchemaBuilder virtualType(String name) {
        Type type = this.assertTypeExists(name);
        type.setVirtual(true);
        this.currentType = type;
        this.currentAttributeHolder = type;
        return this;
    }

    public SchemaBuilder type(String name) {
        Type type;
        this.currentType = type = this.assertTypeExists(name);
        this.currentAttributeHolder = type;
        return this;
    }

    public SchemaBuilder parentType(String parentTypeName) {
        if (this.currentType != null) {
            Type superType = this.assertTypeExists(parentTypeName);
            this.currentType.setSuperType(superType);
            List<Type> subs = superType.getSubTypes();
            if (subs == null) {
                subs = new ArrayList<Type>();
                superType.setSubTypes(subs);
            }
            subs.add(this.currentType);
        }
        return this;
    }

    public SchemaBuilder annotateTypeOrMixin(String key, String value) {
        if (this.currentAttributeHolder != null) {
            this.currentAttributeHolder.annotate(key, value);
        }
        return this;
    }

    public SchemaBuilder annotateAttribute(String key, String value) {
        if (this.currentAttribute != null) {
            this.currentAttribute.annotate(key, value);
        }
        return this;
    }

    public SchemaBuilder annotateSchema(String key, String value) {
        this.schema.annotate(key, value);
        return this;
    }

    public SchemaBuilder inverseTypeAttribute(String attributeName, String referencedAttributeHolderName, String referencedAttributeName) {
        this.attribute(attributeName, InverseAttribute.class);
        Type type = this.assertTypeExists(referencedAttributeHolderName);
        this.attributeValue("referencedAttributeHolder", type);
        this.attributeValue("referencedAttributeName", referencedAttributeName);
        this.inverseAttributes.add((InverseAttribute)this.currentAttribute);
        return this;
    }

    public SchemaBuilder inverseMixinAttribute(String attributeName, String referencedAttributeHolderName, String referencedAttributeName) {
        this.attribute(attributeName, InverseAttribute.class);
        Mixin mixin = this.assertMixinExists(referencedAttributeHolderName);
        this.attributeValue("referencedAttributeHolder", mixin);
        this.attributeValue("referencedAttributeName", referencedAttributeName);
        this.inverseAttributes.add((InverseAttribute)this.currentAttribute);
        return this;
    }

    public SchemaBuilder binaryAttribute(String attributeName) {
        this.attribute(attributeName, BinaryAttribute.class);
        return this;
    }

    public SchemaBuilder jsonTypeAttribute(String attributeName, String typeName) {
        this.attribute(attributeName, JSONAttribute.class);
        Type type = this.assertTypeExists(typeName);
        this.attributeValue("namedAttributeHolder", type);
        return this;
    }

    public SchemaBuilder typeAttribute(String attributeName, String typeName) {
        this.attribute(attributeName, TypeAttribute.class);
        Type type = this.assertTypeExists(typeName);
        this.attributeValue("type", type);
        if (type.isVirtual()) {
            this.virtual();
        }
        return this;
    }

    public SchemaBuilder jsonMixinAttribute(String attributeName, String mixinName) {
        this.attribute(attributeName, JSONAttribute.class);
        Mixin mixin = this.assertMixinExists(mixinName);
        this.attributeValue("namedAttributeHolder", mixin);
        return this;
    }

    public SchemaBuilder mixinAttribute(String attributeName, String mixinName) {
        this.attribute(attributeName, MixinAttribute.class);
        Mixin mixin = this.assertMixinExists(mixinName);
        this.attributeValue("mixin", mixin);
        if (mixin.isVirtual()) {
            this.virtual();
        }
        return this;
    }

    public SchemaBuilder attribute(String name, Class<? extends Attribute> attributeType) {
        if (this.currentAttributeHolder != null) {
            try {
                List<Attribute> attributes = this.currentAttributeHolder.getAttributes();
                Attribute attribute = null;
                if (attributes != null) {
                    for (Attribute a : attributes) {
                        if (!name.equals(a.getName())) continue;
                        attributeType.cast(a);
                        attribute = a;
                    }
                }
                if (attribute == null) {
                    attribute = attributeType.newInstance();
                    attribute.setName(name);
                    if (attributes == null) {
                        attributes = new ArrayList<Attribute>();
                        this.currentAttributeHolder.setAttributes(attributes);
                    }
                    attributes.add(attribute);
                }
                if (this.currentAttributeHolder.isVirtual()) {
                    attribute.setVirtual(true);
                }
                this.currentAttribute = attribute;
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return this;
    }

    public SchemaBuilder attributeValue(String propertyName, Object value) {
        if (this.currentAttribute != null) {
            Method[] methods = this.currentAttribute.getClass().getMethods();
            String setterName = "set" + propertyName.substring(0, 1).toUpperCase();
            if (propertyName.length() > 1) {
                setterName = setterName + propertyName.substring(1);
            }
            for (Method method : methods) {
                if (!setterName.equals(method.getName())) continue;
                try {
                    method.invoke((Object)this.currentAttribute, value);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }
        return this;
    }

    public SchemaBuilder indexAttribute() {
        if (this.currentAttribute != null) {
            this.currentAttribute.setIndexed(true);
        }
        return this;
    }

    public SchemaBuilder preventIndexAttribute() {
        if (this.currentAttribute != null) {
            this.currentAttribute.setIndexed(false);
        }
        return this;
    }

    public SchemaBuilder nullOnDelete() {
        return this.attributeValue("nullOnDelete", true);
    }

    public SchemaBuilder cascadeDelete() {
        return this.attributeValue("cascadeDelete", true);
    }

    public SchemaBuilder deleteOrphans() {
        return this.attributeValue("deleteOrphans", true);
    }

    public SchemaBuilder toOneAttribute(String attributeName) {
        return this.attributeValue("toOneAttribute", attributeName);
    }

    public SchemaBuilder virtual() {
        if (this.currentAttribute != null) {
            this.currentAttribute.setVirtual(true);
        }
        return this;
    }

    public SchemaBuilder nonVirtual() {
        if (this.currentAttribute != null) {
            this.currentAttribute.setVirtual(false);
        }
        return this;
    }

    public SchemaBuilder mandatory() {
        if (this.currentAttribute != null) {
            this.currentAttribute.setMandatory(true);
        }
        return this;
    }

    public SchemaBuilder unique(String ... attributeNames) {
        if (this.currentAttributeHolder != null) {
            UniqueConstraint c = new UniqueConstraint();
            c.setHolder(this.currentAttributeHolder);
            ArrayList<Attribute> participatingAttributes = new ArrayList<Attribute>();
            c.setAttributes(participatingAttributes);
            if (attributeNames == null || attributeNames.length == 0) {
                if (this.currentAttribute != null) {
                    participatingAttributes.add(this.currentAttribute);
                }
            } else {
                Map<String, Attribute> atts = SchemaUtil.collectAttributesAsMap(this.currentAttributeHolder);
                for (String attributeName : attributeNames) {
                    Attribute att = atts.get(attributeName);
                    if (att == null) {
                        throw new IllegalArgumentException("could not find attribute " + attributeName + " for attribute holder " + this.currentAttributeHolder.getName());
                    }
                    participatingAttributes.add(att);
                }
            }
            if (!participatingAttributes.isEmpty()) {
                List<UniqueConstraint> uq = this.schema.getUniqueConstraints();
                if (uq == null) {
                    uq = new ArrayList<UniqueConstraint>();
                    this.schema.setUniqueConstraints(uq);
                }
                uq.add(c);
            }
        }
        return this;
    }

    public SchemaBuilder mixWith(String name) {
        if (this.currentType != null) {
            List<Mixin> mixins = this.currentType.getMixins();
            if (mixins != null) {
                for (Mixin mixin : mixins) {
                    if (!name.equals(mixin.getName())) continue;
                    return this;
                }
            } else {
                mixins = new ArrayList<Mixin>();
                this.currentType.setMixins(mixins);
            }
            Mixin mixin = this.assertMixinExists(name);
            mixins.add(mixin);
            List<Type> mixedInto = mixin.getMixedInto();
            if (mixedInto == null) {
                mixedInto = new ArrayList<Type>();
                mixin.setMixedInto(mixedInto);
            } else {
                for (Type type : mixedInto) {
                    if (type != this.currentType) continue;
                    return this;
                }
            }
            mixedInto.add(this.currentType);
        }
        return this;
    }

    public SchemaBuilder virtualMixin(String name) {
        Mixin mixin = this.assertMixinExists(name);
        mixin.setVirtual(true);
        this.currentMixin = mixin;
        this.currentAttributeHolder = mixin;
        return this;
    }

    public SchemaBuilder mixin(String name) {
        Mixin mixin;
        this.currentMixin = mixin = this.assertMixinExists(name);
        this.currentAttributeHolder = mixin;
        return this;
    }

    private Type assertTypeExists(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name of type is not allowed to be null");
        }
        Type type = this.typesByName.get(name);
        if (type == null) {
            type = new Type(this.schema);
            type.setName(name);
            this.typesByName.put(name, type);
            this.namedAttributeHoldersByName.put(name, type);
            List<Type> types = this.schema.getTypes();
            if (types == null) {
                types = new ArrayList<Type>();
                this.schema.setTypes(types);
            }
            types.add(type);
        }
        return type;
    }

    private Mixin assertMixinExists(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name of mixin is not allowed to be null");
        }
        Mixin mixin = this.mixinsByName.get(name);
        if (mixin == null) {
            mixin = new Mixin(this.schema);
            mixin.setName(name);
            this.mixinsByName.put(name, mixin);
            this.namedAttributeHoldersByName.put(name, mixin);
            List<Mixin> mixins = this.schema.getMixins();
            if (mixins == null) {
                mixins = new ArrayList<Mixin>();
                this.schema.setMixins(mixins);
            }
            mixins.add(mixin);
        }
        return mixin;
    }
}

