/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.bndly.schema.api.AliasBinding;
import org.bndly.schema.api.AttributeMediator;
import org.bndly.schema.api.LoadedAttributes;
import org.bndly.schema.api.MappingBinding;
import org.bndly.schema.api.MappingBindingsProvider;
import org.bndly.schema.api.ObjectReference;
import org.bndly.schema.api.Pagination;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.Transaction;
import org.bndly.schema.api.db.AttributeColumn;
import org.bndly.schema.api.db.JoinTable;
import org.bndly.schema.api.db.Table;
import org.bndly.schema.api.db.TypeTable;
import org.bndly.schema.api.exception.SchemaException;
import org.bndly.schema.api.listener.PreDeleteListener;
import org.bndly.schema.api.listener.PreMergeListener;
import org.bndly.schema.api.listener.PrePersistListener;
import org.bndly.schema.api.listener.QueryByExampleIteratorListener;
import org.bndly.schema.api.nquery.BooleanOperator;
import org.bndly.schema.api.nquery.BooleanStatement;
import org.bndly.schema.api.nquery.Count;
import org.bndly.schema.api.nquery.ExpressionStatementHandler;
import org.bndly.schema.api.nquery.IfClause;
import org.bndly.schema.api.nquery.Ordering;
import org.bndly.schema.api.nquery.Pick;
import org.bndly.schema.api.nquery.QueryParsingException;
import org.bndly.schema.api.nquery.WrapperBooleanStatement;
import org.bndly.schema.api.query.Expression;
import org.bndly.schema.api.query.Insert;
import org.bndly.schema.api.query.Join;
import org.bndly.schema.api.query.OrderBy;
import org.bndly.schema.api.query.PreparedStatementValueProvider;
import org.bndly.schema.api.query.Query;
import org.bndly.schema.api.query.QueryContext;
import org.bndly.schema.api.query.Select;
import org.bndly.schema.api.query.TableExpression;
import org.bndly.schema.api.query.ValueProvider;
import org.bndly.schema.api.query.Where;
import org.bndly.schema.api.query.WrapperExpression;
import org.bndly.schema.api.services.Accessor;
import org.bndly.schema.api.services.QueryByExample;
import org.bndly.schema.api.services.QueryContextFactory;
import org.bndly.schema.api.services.TableRegistry;
import org.bndly.schema.impl.EngineImpl;
import org.bndly.schema.impl.LazyLoadedAttributes;
import org.bndly.schema.impl.LoadingIterator;
import org.bndly.schema.impl.MediatorRegistryImpl;
import org.bndly.schema.impl.QueryByExampleImpl;
import org.bndly.schema.impl.RecordContextImpl;
import org.bndly.schema.impl.Resetable;
import org.bndly.schema.impl.TableContextProvider;
import org.bndly.schema.impl.UnknownNamedAttributeHolderException;
import org.bndly.schema.impl.events.PersistenceEventTransaction;
import org.bndly.schema.impl.nquery.BooleanStatementIterator;
import org.bndly.schema.impl.nquery.ParserImpl;
import org.bndly.schema.impl.nquery.sqlmapper.BooleanStatementSQLMapper;
import org.bndly.schema.impl.nquery.sqlmapper.ComparisonExpressionMapper;
import org.bndly.schema.impl.nquery.sqlmapper.InRangeExpressionMapper;
import org.bndly.schema.impl.nquery.sqlmapper.MediatorProvider;
import org.bndly.schema.impl.nquery.sqlmapper.RequiredAttribtuesInspector;
import org.bndly.schema.impl.nquery.sqlmapper.TypedExpressionMapper;
import org.bndly.schema.impl.nquery.sqlmapper.Util;
import org.bndly.schema.impl.nquery.sqlmapper.WrapperInspector;
import org.bndly.schema.impl.persistence.MarkAsNotDirty;
import org.bndly.schema.impl.persistence.PersistedEventForRecordContext;
import org.bndly.schema.impl.persistence.PersistenceManager;
import org.bndly.schema.impl.persistence.TypeJoinInsert;
import org.bndly.schema.impl.persistence.TypeTableDelete;
import org.bndly.schema.impl.persistence.TypeTableInsert;
import org.bndly.schema.impl.persistence.TypeTableUpdate;
import org.bndly.schema.impl.persistence.UniqueConstraintTableInsert;
import org.bndly.schema.impl.persistence.UniqueConstraintTableUpdate;
import org.bndly.schema.impl.persistence.UploadBlobs;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.Mixin;
import org.bndly.schema.model.NamedAttributeHolder;
import org.bndly.schema.model.NamedAttributeHolderAttribute;
import org.bndly.schema.model.Type;

public class AccessorImpl
implements Accessor,
Resetable {
    private MediatorRegistryImpl mediatorRegistry;
    private EngineImpl engine;
    private ExpressionStatementHandler expressionStatementHandler;
    private final Map<Class<? extends BooleanStatement>, BooleanStatementSQLMapper> sqlMappersByStatementType = new HashMap<Class<? extends BooleanStatement>, BooleanStatementSQLMapper>();
    private final Map<Class<? extends BooleanStatement>, RequiredAttribtuesInspector> requiredAttributesInspectorsByStatementType = new HashMap<Class<? extends BooleanStatement>, RequiredAttribtuesInspector>();
    private final List<BooleanStatementSQLMapper> booleanStatementSQLMappers = new ArrayList<BooleanStatementSQLMapper>();
    private final List<RequiredAttribtuesInspector> requiredAttributesInspectors = new ArrayList<RequiredAttribtuesInspector>();

    public AccessorImpl() {
        MediatorProvider mediatorProvider = new MediatorProvider(){

            @Override
            public AttributeMediator getMediatorForAttribute(Attribute attribute) {
                return AccessorImpl.this.mediatorRegistry.getMediatorForAttribute(attribute);
            }
        };
        ComparisonExpressionMapper eem = new ComparisonExpressionMapper(mediatorProvider);
        this.booleanStatementSQLMappers.add(eem);
        this.requiredAttributesInspectors.add(eem);
        InRangeExpressionMapper irm = new InRangeExpressionMapper(mediatorProvider);
        this.booleanStatementSQLMappers.add(irm);
        this.requiredAttributesInspectors.add(irm);
        TypedExpressionMapper tm = new TypedExpressionMapper();
        this.booleanStatementSQLMappers.add(tm);
        this.requiredAttributesInspectors.add(tm);
        this.requiredAttributesInspectors.add(new WrapperInspector());
    }

    public static void appendAttributesToSelectInTypeJoin(TableContextProvider tcp, Select select) {
        select.expression().table(tcp.getAlias()).field(tcp.getTable().getPrimaryKeyColumn().getColumnName()).as(tcp.getAlias() + "_id");
        List cols = tcp.getTable().getColumns();
        for (AttributeColumn attributeColumn : cols) {
            String fieldName = attributeColumn.getColumnName();
            String alias = tcp.getAlias() + "_" + fieldName;
            select.expression().table(tcp.getAlias()).field(fieldName).as(alias);
        }
    }

    @Override
    public void reset() {
    }

    public RecordContext buildRecordContext() {
        return new RecordContextImpl(this.engine);
    }

    public Object createIdAsNamedAttributeHolderQuery(NamedAttributeHolder namedAttributeHolder, Type sourceType, long id, RecordContext context) {
        Record r = context.get(sourceType, id);
        if (r == null) {
            r = this.buildRecordContext().create(sourceType, id);
        }
        return this.createIdAsNamedAttributeHolderQuery(namedAttributeHolder, r);
    }

    public Object createIdAsNamedAttributeHolderQuery(NamedAttributeHolder namedAttributeHolder, final Record record) {
        TableExpression table;
        if (record.getType() == namedAttributeHolder && (record.getType().getSubTypes() == null || record.getType().getSubTypes().isEmpty())) {
            return record.getId();
        }
        JoinTable targetTable = this.engine.getTableRegistry().getJoinTableByNamedAttributeHolder(namedAttributeHolder);
        String targetTableName = targetTable.getTableName();
        QueryContext qc = this.engine.getQueryContextFactory().buildQueryContext();
        Select select = qc.select();
        select.expression().table(targetTableName).field(targetTable.getPrimaryKeyColumn().getColumnName());
        TableExpression tableRoot = table = select.from().table(targetTableName);
        ArrayList<Table> joinChain = new ArrayList<Table>();
        this.buildRightJoinToNamedAttributeHolder(record.getType(), namedAttributeHolder, joinChain);
        Table leftTable = null;
        for (int i = joinChain.size() - 1; i >= 0; --i) {
            Table rightTable = (Table)joinChain.get(i);
            if (leftTable != null) {
                Join join = tableRoot.join(rightTable.getTableName()).inner();
                table = join;
                Expression onExp = null;
                List cols = leftTable.getColumns();
                AttributeColumn joinColumn = null;
                for (AttributeColumn attributeColumn : cols) {
                    TypeTable ttB;
                    Attribute att = attributeColumn.getAttribute();
                    if (!NamedAttributeHolderAttribute.class.isInstance(att)) continue;
                    NamedAttributeHolderAttribute naha = (NamedAttributeHolderAttribute)att;
                    NamedAttributeHolder holder = naha.getNamedAttributeHolder();
                    if (JoinTable.class.isInstance(rightTable)) {
                        JoinTable jtB = (JoinTable)rightTable;
                        if (jtB.getNamedAttributeHolder() != holder) continue;
                        joinColumn = attributeColumn;
                        break;
                    }
                    if (!TypeTable.class.isInstance(rightTable) || (ttB = (TypeTable)rightTable).getType() != holder) continue;
                    joinColumn = attributeColumn;
                    break;
                }
                if (joinColumn == null) {
                    throw new IllegalStateException("could not find join column");
                }
                String left = leftTable.getTableName() + "." + joinColumn.getColumnName();
                String right = rightTable.getTableName() + "." + rightTable.getPrimaryKeyColumn().getColumnName();
                onExp = onExp == null ? join.on() : onExp.and();
                onExp.criteria().field(left).equal().field(right);
                if (i == 0) {
                    onExp.and().criteria().field(rightTable.getTableName() + "." + rightTable.getPrimaryKeyColumn().getColumnName()).equal().value((ValueProvider)new ObjectReference<Long>(){

                        public Long get() {
                            return record.getId();
                        }
                    });
                }
                leftTable = rightTable;
                continue;
            }
            leftTable = rightTable;
        }
        Query q = qc.build(record.getContext());
        return q;
    }

    public long readIdAsNamedAttributeHolder(NamedAttributeHolder namedAttributeHolder, Type sourceType, long id, RecordContext context) {
        return this.readIdAsNamedAttributeHolder(namedAttributeHolder, sourceType, id, context, null);
    }

    private long readIdAsNamedAttributeHolder(NamedAttributeHolder namedAttributeHolder, Type sourceType, long id, RecordContext context, Transaction tx) {
        Object q = this.createIdAsNamedAttributeHolderQuery(namedAttributeHolder, sourceType, id, context);
        if (Query.class.isInstance(q)) {
            if (tx == null) {
                tx = this.engine.getQueryRunner().createTransaction();
            }
            ObjectReference ref = tx.getQueryRunner().number((Query)q);
            tx.commit();
            return (Long)ref.get();
        }
        return (Long)q;
    }

    private boolean buildRightJoinToNamedAttributeHolder(Type currentType, NamedAttributeHolder target, List<Table> tableJoinOrder) {
        if (Type.class.isInstance(target)) {
            Type targetType = (Type)target;
            if (targetType == currentType) {
                TypeTable tt = this.engine.getTableRegistry().getTypeTableByType(currentType);
                tableJoinOrder.add((Table)tt);
                JoinTable jt = this.engine.getTableRegistry().getJoinTableByNamedAttributeHolder((NamedAttributeHolder)currentType);
                if (jt != null) {
                    tableJoinOrder.add((Table)jt);
                }
                return true;
            }
            List tmp = targetType.getSubTypes();
            if (tmp == null || tmp.isEmpty()) {
                return false;
            }
            for (Type subType : tmp) {
                if (!this.buildRightJoinToNamedAttributeHolder(currentType, (NamedAttributeHolder)subType, tableJoinOrder)) continue;
                tableJoinOrder.add((Table)this.engine.getTableRegistry().getJoinTableByNamedAttributeHolder((NamedAttributeHolder)targetType));
                return true;
            }
            return false;
        }
        if (Mixin.class.isInstance(target)) {
            Mixin mixin = (Mixin)target;
            List tmp = mixin.getMixedInto();
            if (tmp == null || tmp.isEmpty()) {
                return false;
            }
            for (Type type : tmp) {
                if (!this.buildRightJoinToNamedAttributeHolder(currentType, (NamedAttributeHolder)type, tableJoinOrder)) continue;
                tableJoinOrder.add((Table)this.engine.getTableRegistry().getJoinTableByNamedAttributeHolder((NamedAttributeHolder)mixin));
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("unsupported named attribute holder");
    }

    public Record readById(String namedAttributeHolderName, long id, RecordContext recordContext) {
        try {
            return this.queryByExample(namedAttributeHolderName, recordContext).attribute("id", (Object)id).single();
        }
        catch (UnknownNamedAttributeHolderException e) {
            return null;
        }
    }

    public void buildInsertQuery(Record record, Transaction transaction) {
        if (record.getId() != null) {
            throw new SchemaException("creating an insert query for a record that has already an id assigned. use an update query instead!");
        }
        for (PrePersistListener persistListener : this.engine.getListeners(PrePersistListener.class, record.getType().getName())) {
            persistListener.onBeforePersist(record, transaction);
        }
        TypeTableInsert.INSTANCE.append(transaction, record, this.engine);
        UploadBlobs.INSTANCE.append(transaction, record, this.engine);
        UniqueConstraintTableInsert.INSTANCE.append(transaction, record, this.engine);
        TypeJoinInsert.INSTANCE.append(transaction, record, this.engine);
        if (this.isPersistenceTransaction(transaction)) {
            ((PersistenceEventTransaction)transaction).getPersistenceEventBuilder().schedulePersistEvent(record);
        }
        PersistedEventForRecordContext.INSTANCE.append(transaction, record, this.engine);
        MarkAsNotDirty.INSTANCE.append(transaction, record, this.engine);
    }

    public static void appendValueToInsert(Insert insert, AttributeColumn attributeColumn, Record record, MediatorRegistryImpl mediatorRegistry) {
        Attribute attribute = attributeColumn.getAttribute();
        AttributeMediator<Attribute> mediator = mediatorRegistry.getMediatorForAttribute(attribute);
        insert.value(attributeColumn.getColumnName(), mediator.createValueProviderFor(record, attribute), mediator.columnSqlType(attribute));
    }

    public long insert(Record record) {
        Transaction tx = this.engine.getQueryRunner().createTransaction();
        this.buildInsertQuery(record, tx);
        tx.commit();
        return record.getId();
    }

    public void buildInsertCascadedQuery(Record record, Transaction transaction) {
        if (record.getId() != null) {
            throw new SchemaException("creating an insert query for a record that has already an id assigned. use an update query instead!");
        }
        new PersistenceManager(this.engine, transaction).append(record).finalizeTransaction();
    }

    public long insertCascaded(Record record) {
        Transaction tx = this.engine.getQueryRunner().createTransaction();
        this.buildInsertCascadedQuery(record, tx);
        tx.commit();
        return record.getId();
    }

    public void buildUpdateQuery(Record record, Transaction transaction) {
        this.buildUpdateQuery(record, transaction, true);
    }

    public void buildUpdateQueryPostPersist(Record record, Transaction transaction) {
        this.buildUpdateQuery(record, transaction, false);
    }

    private void buildUpdateQuery(Record record, Transaction transaction, boolean nullCheckId) {
        Long id = record.getId();
        if (nullCheckId && id == null) {
            throw new SchemaException("can not update a record without id");
        }
        for (PreMergeListener mergeListener : this.engine.getListeners(PreMergeListener.class, record.getType().getName())) {
            mergeListener.onBeforeMerge(record, transaction);
        }
        TypeTableUpdate.INSTANCE.append(transaction, record, this.engine);
        UniqueConstraintTableUpdate.INSTANCE.append(transaction, record, this.engine);
        UploadBlobs.INSTANCE.append(transaction, record, this.engine);
        if (this.isPersistenceTransaction(transaction)) {
            ((PersistenceEventTransaction)transaction).getPersistenceEventBuilder().scheduleMergeEvent(record);
        }
        MarkAsNotDirty.INSTANCE.append(transaction, record, this.engine);
    }

    public static PreparedStatementValueProvider createRecordIdPreparedStatementValueProvider(AttributeColumn attributeColumn, final Record record, MediatorRegistryImpl mediatorRegistry) {
        final Attribute att = attributeColumn.getAttribute();
        final AttributeMediator<Attribute> mediator = mediatorRegistry.getMediatorForAttribute(att);
        return new PreparedStatementValueProvider(){

            public Long get() {
                return record.getId();
            }

            public void set(int index, PreparedStatement ps) throws SQLException {
                mediator.setRawParameterInPreparedStatement(index, ps, att, (Object)this.get());
            }
        };
    }

    private boolean isPersistenceTransaction(Transaction transaction) {
        return PersistenceEventTransaction.class.isInstance(transaction);
    }

    public void update(Record record) {
        Transaction tx = this.engine.getQueryRunner().createTransaction();
        this.buildUpdateQuery(record, tx);
        tx.commit();
    }

    public void buildUpdateCascadedQuery(Record record, Transaction transaction) {
        Long id = record.getId();
        if (id == null) {
            throw new SchemaException("can not update a record without id");
        }
        new PersistenceManager(this.engine, transaction).append(record).finalizeTransaction();
    }

    public void updateCascaded(Record record) {
        Transaction tx = this.engine.getQueryRunner().createTransaction();
        this.buildUpdateCascadedQuery(record, tx);
        tx.commit();
    }

    public void delete(Record record, Transaction transaction) {
        this.buildDeleteQuery(record, transaction);
    }

    public void buildDeleteQuery(Record record, Transaction transaction) {
        for (PreDeleteListener deleteListener : this.engine.getListeners(PreDeleteListener.class, record.getType().getName())) {
            deleteListener.onBeforeDelete(record, transaction);
        }
        TypeTableDelete.INSTANCE.append(transaction, record, this.engine);
        if (this.isPersistenceTransaction(transaction)) {
            ((PersistenceEventTransaction)transaction).getPersistenceEventBuilder().scheduleDeleteEvent(record);
        }
        MarkAsNotDirty.INSTANCE.append(transaction, record, this.engine);
    }

    public void _delete(Record record) {
        Transaction tx = this.engine.getQueryRunner().createTransaction();
        this.delete(record, tx);
        tx.commit();
    }

    private void appendTableAsLeftJoinForSelect(JoinTable jt, TableExpression tableExpression, Select select) {
        List cols = jt.getColumns();
        for (AttributeColumn attributeColumn : cols) {
            Attribute att = attributeColumn.getAttribute();
            if (!NamedAttributeHolderAttribute.class.isInstance(att)) continue;
            NamedAttributeHolderAttribute naha = (NamedAttributeHolderAttribute)att;
            NamedAttributeHolder holder = naha.getNamedAttributeHolder();
            JoinTable t = this.engine.getTableRegistry().getJoinTableByNamedAttributeHolder(holder);
            if (t == null) {
                t = this.engine.getTableRegistry().getTypeTableByType(holder.getName());
            }
            if (t == null) continue;
            this.appendTableAsLeftJoinForSelect(tableExpression, (Table)t, (Table)jt, attributeColumn, select);
        }
    }

    private void appendTableAsLeftJoinForSelect(TableExpression tableExpression, Table rightTable, Table leftTable, AttributeColumn leftTableJoinColumn, Select select) {
        Join join = tableExpression.join(rightTable.getTableName()).left();
        Expression onExp = join.on();
        onExp.criteria().field(leftTable.getTableName() + "." + leftTableJoinColumn.getColumnName()).equal().field(rightTable.getTableName() + "." + rightTable.getPrimaryKeyColumn().getColumnName());
        if (TypeTable.class.isInstance(rightTable)) {
            TypeTable tt = (TypeTable)TypeTable.class.cast(rightTable);
            List columns = tt.getColumns();
            select.expression().table(rightTable.getTableName()).field(rightTable.getPrimaryKeyColumn().getColumnName()).as(rightTable.getTableName() + "_id");
            for (AttributeColumn attributeColumn : columns) {
                String alias = rightTable.getTableName() + "_" + attributeColumn.getColumnName();
                select.expression().table(rightTable.getTableName()).field(attributeColumn.getColumnName()).as(alias);
            }
        } else if (JoinTable.class.isInstance(rightTable)) {
            JoinTable jt = (JoinTable)JoinTable.class.cast(rightTable);
            this.appendTableAsLeftJoinForSelect(jt, (TableExpression)join, select);
        } else {
            throw new IllegalStateException("unsupported joined table.");
        }
    }

    public QueryByExample queryByExample(String namedAttributeHolderName, RecordContext context) {
        NamedAttributeHolder nah;
        JoinTable joinTable = this.engine.getTableRegistry().getJoinTableByNamedAttributeHolder(namedAttributeHolderName);
        if (joinTable != null) {
            nah = joinTable.getNamedAttributeHolder();
        } else {
            TypeTable typeTable = this.engine.getTableRegistry().getTypeTableByType(namedAttributeHolderName);
            if (typeTable != null) {
                nah = typeTable.getType();
            } else {
                throw new UnknownNamedAttributeHolderException(namedAttributeHolderName);
            }
        }
        return new QueryByExampleImpl(nah, this.engine, context);
    }

    public void iterate(String typeName, QueryByExampleIteratorListener listener, final int batchSize, boolean eager, RecordContext recordContext) {
        QueryByExample qbe = this.engine.getAccessor().queryByExample(typeName, recordContext);
        long total = qbe.count();
        int start = 0;
        while ((long)start < total) {
            final int s = start;
            QueryByExample q = this.engine.getAccessor().queryByExample(typeName, recordContext).pagination(new Pagination(){

                public Long getOffset() {
                    return new Long(s);
                }

                public Long getSize() {
                    return new Long(batchSize);
                }
            });
            if (eager) {
                q.eager();
            }
            List records = q.all();
            for (Record record : records) {
                listener.handleRecord(record);
            }
            start += batchSize;
            total = qbe.count();
        }
    }

    public void setMediatorRegistry(MediatorRegistryImpl mediatorRegistry) {
        this.mediatorRegistry = mediatorRegistry;
    }

    public void setEngine(EngineImpl engine) {
        this.engine = engine;
    }

    public void setExpressionStatementHandler(ExpressionStatementHandler expressionStatementHandler) {
        this.expressionStatementHandler = expressionStatementHandler;
    }

    public Iterator<Record> query(String nQuery, RecordContext recordContext, final LoadedAttributes userDefinedLoadedAttributes, Object ... queryArgs) {
        Long offset;
        OrderBy ob;
        Pick pick = this.parseQuery(nQuery, Pick.class, queryArgs);
        this.assertTableExistsForTypeOrMixin(pick.getAttributeHolderName());
        String alias = pick.getAttributeHolderNameAlias();
        IfClause ifClause = pick.getIfClause();
        Ordering ordering = pick.getOrdering();
        final Set<String> requiredAttributes = ifClause == null ? (ordering == null ? Collections.EMPTY_SET : new HashSet()) : this._collectRequiredAttributesFromBooleanStatement(new HashSet<String>(), alias, ifClause.getNext());
        QueryContextFactory qcf = this.engine.getQueryContextFactory();
        QueryContext qc = qcf.buildQueryContext();
        Select select = qc.select();
        String orderByField = null;
        if (ordering != null) {
            String field = ordering.getField();
            orderByField = Util.stripEntityAliasPrefix(alias, field);
            this.addOrderByFieldToRequiredAttributes(requiredAttributes, orderByField);
        }
        LazyLoadedAttributes loadedAttributes = new LazyLoadedAttributes(){

            @Override
            public LoadedAttributes.Strategy isLoaded(Attribute attribute, String attributePath) {
                LoadedAttributes.Strategy userDefinedStrategy;
                LoadedAttributes.Strategy strategy = super.isLoaded(attribute, attributePath);
                LoadedAttributes.Strategy strategy2 = userDefinedStrategy = userDefinedLoadedAttributes == null ? null : userDefinedLoadedAttributes.isLoaded(attribute, attributePath);
                if (userDefinedStrategy != null) {
                    // empty if block
                }
                if ((strategy == LoadedAttributes.Strategy.LAZY_LOADED || strategy == LoadedAttributes.Strategy.NOT_LOADED) && requiredAttributes.contains(attributePath)) {
                    strategy = LoadedAttributes.Strategy.LOADED;
                }
                return strategy;
            }
        };
        LoadingIterator iterator = new LoadingIterator(this.engine.getTableRegistry(), select, loadedAttributes, requiredAttributes);
        iterator.iterate(pick.getAttributeHolderName());
        if (ifClause != null) {
            List<MappingBinding> bindings = iterator.getMappingBindings();
            this.createWhereClauseForBindings(ifClause, select, bindings, alias == null ? null : alias + ".");
        }
        if (ordering != null) {
            ob = select.orderBy();
            this.createOrderBy(ob, iterator.getMappingBindings(), orderByField);
            ob.direction(ordering.isAscending() ? "ASC" : "DESC");
        } else {
            ob = select.orderBy();
            ob.columnAlias(iterator.getRootMappingBinding().getTableAlias() + "." + iterator.getRootMappingBinding().getPrimaryKeyAlias().getAttributeColumn().getColumnName());
            ob.direction("ASC");
        }
        Long limit = pick.getLimit();
        if (limit != null) {
            select.limit(limit);
        }
        if ((offset = pick.getOffset()) != null) {
            select.offset(offset);
        }
        qc.setExternalMappingBindingsProvider((MappingBindingsProvider)iterator);
        Query q = qc.build(recordContext);
        Transaction tx = this.engine.getQueryRunner().createTransaction();
        ObjectReference items = tx.getQueryRunner().list(q);
        tx.commit();
        List itemsList = (List)items.get();
        return itemsList == null ? null : itemsList.iterator();
    }

    public Iterator<Record> query(String nQuery, Object ... queryArgs) {
        return this.query(nQuery, this.buildRecordContext(), null, queryArgs);
    }

    public Long count(String nQuery, Object ... queryArgs) {
        Count count = this.parseQuery(nQuery, Count.class, queryArgs);
        this.assertTableExistsForTypeOrMixin(count.getAttributeHolderName());
        String alias = count.getAttributeHolderNameAlias();
        IfClause ifClause = count.getIfClause();
        final Set<String> requiredAttributes = ifClause == null ? Collections.EMPTY_SET : this._collectRequiredAttributesFromBooleanStatement(new HashSet<String>(), alias, ifClause.getNext());
        QueryContextFactory qcf = this.engine.getQueryContextFactory();
        QueryContext qc = qcf.buildQueryContext();
        Select select = qc.select().count();
        LazyLoadedAttributes loadedAttributes = new LazyLoadedAttributes(){

            @Override
            public LoadedAttributes.Strategy isLoaded(Attribute attribute, String attributePath) {
                LoadedAttributes.Strategy strategy = super.isLoaded(attribute, attributePath);
                if ((strategy == LoadedAttributes.Strategy.LAZY_LOADED || strategy == LoadedAttributes.Strategy.NOT_LOADED) && requiredAttributes.contains(attributePath)) {
                    strategy = LoadedAttributes.Strategy.LOADED;
                }
                return strategy;
            }
        };
        LoadingIterator iterator = new LoadingIterator(this.engine.getTableRegistry(), select, loadedAttributes, requiredAttributes);
        iterator.iterate(count.getAttributeHolderName(), true);
        if (ifClause != null) {
            List<MappingBinding> bindings = iterator.getMappingBindings();
            this.createWhereClauseForBindings(ifClause, select, bindings, alias == null ? null : alias + ".");
        }
        RecordContext recordContext = this.buildRecordContext();
        Query q = qc.build(recordContext);
        Transaction tx = this.engine.getQueryRunner().createTransaction();
        ObjectReference countNumber = tx.getQueryRunner().number(q);
        tx.commit();
        return (Long)countNumber.get();
    }

    private <E extends org.bndly.schema.api.nquery.Query> E parseQuery(String nQuery, Class<E> queryType, Object ... queryArgs) {
        org.bndly.schema.api.nquery.Query query;
        try {
            query = new ParserImpl(queryArgs).expressionStatementHandler(this.expressionStatementHandler).parse(nQuery).getQuery();
        }
        catch (QueryParsingException ex) {
            throw new SchemaException("failed to parse query string: " + ex.getMessage(), (Throwable)ex);
        }
        if (!queryType.isInstance(query)) {
            throw new SchemaException("provided query is not a " + queryType.getSimpleName());
        }
        return (E)((org.bndly.schema.api.nquery.Query)queryType.cast(query));
    }

    private void assertTableExistsForTypeOrMixin(String attributeHolderName) {
        TableRegistry tr = this.engine.getTableRegistry();
        JoinTable table = tr.getJoinTableByNamedAttributeHolder(attributeHolderName);
        if (table == null) {
            table = tr.getTypeTableByType(attributeHolderName);
        }
        if (table == null) {
            throw new SchemaException("could not find table for type/mixin " + attributeHolderName);
        }
    }

    private Set<String> _collectRequiredAttributesFromBooleanStatement(final Set<String> set, final String alias, BooleanStatement booleanStatement) {
        if (booleanStatement != null) {
            RequiredAttribtuesInspector.Context ctx = new RequiredAttribtuesInspector.Context(){

                @Override
                public void collectRequiredAttributesFromBooleanStatement(BooleanStatement booleanStatement) {
                    AccessorImpl.this._collectRequiredAttributesFromBooleanStatement(set, alias, booleanStatement);
                }
            };
            for (BooleanStatement current = booleanStatement; current != null; current = current.getNext()) {
                this.resolveInspector(current).collectRequiredAttributesFromBooleanStatement(set, alias, current, ctx);
            }
        }
        return set;
    }

    private void createWhereClauseForBindings(IfClause ifClause, Select select, List<MappingBinding> bindings, final String prefix) {
        Where where = select.where();
        Expression exp = null;
        for (final MappingBinding binding : bindings) {
            exp = exp == null ? where.expression() : exp.or();
            WrapperExpression wrap = exp.wrap();
            Expression wrapped = wrap.wrapped();
            final Stack<Object> expressionStack = new Stack<Object>();
            expressionStack.push(wrap);
            expressionStack.push(wrapped);
            BooleanStatementIterator.iterate(ifClause.getNext(), new BooleanStatementIterator.NoOpCallback(){

                @Override
                public void onBooleanStatement(BooleanStatement booleanStatement, BooleanOperator operator) {
                    this.applyBooleanStatement(booleanStatement, binding, prefix);
                    Expression peek = (Expression)expressionStack.pop();
                    if (BooleanOperator.AND.equals((Object)operator)) {
                        expressionStack.push(peek.and());
                    } else if (BooleanOperator.OR.equals((Object)operator)) {
                        expressionStack.push(peek.or());
                    } else {
                        throw new IllegalStateException("unsupported boolean operator");
                    }
                }

                @Override
                public void onLastBooleanStatement(BooleanStatement booleanStatement) {
                    this.applyBooleanStatement(booleanStatement, binding, prefix);
                }

                @Override
                public void onWrapperOpened(WrapperBooleanStatement wrapper) {
                    Expression peek = (Expression)expressionStack.pop();
                    WrapperExpression wrp = peek.wrap();
                    expressionStack.push(wrp);
                    expressionStack.push(wrp.wrapped());
                }

                @Override
                public void onWrapperClosed(WrapperBooleanStatement wrapper) {
                    expressionStack.pop();
                }

                void applyBooleanStatement(BooleanStatement booleanStatement, final MappingBinding mappingBinding, final String prefix2) {
                    if (!WrapperBooleanStatement.class.isInstance(booleanStatement)) {
                        AccessorImpl.this.resolveSQLMapper(booleanStatement).map(booleanStatement, (Expression)expressionStack.peek(), prefix2, mappingBinding, new BooleanStatementSQLMapper.Context(){

                            @Override
                            public void map(BooleanStatement booleanStatement) {
                                this.applyBooleanStatement(booleanStatement, mappingBinding, prefix2);
                            }

                            @Override
                            public TableRegistry getTableRegistry() {
                                return AccessorImpl.this.engine.getTableRegistry();
                            }
                        });
                    }
                }
            });
        }
    }

    private RequiredAttribtuesInspector resolveInspector(BooleanStatement booleanStatement) {
        Class<?> key = booleanStatement.getClass();
        RequiredAttribtuesInspector insp = null;
        if (!this.requiredAttributesInspectorsByStatementType.containsKey(key)) {
            for (RequiredAttribtuesInspector inspector : this.requiredAttributesInspectors) {
                if (!inspector.supports(booleanStatement)) continue;
                insp = inspector;
                break;
            }
            this.requiredAttributesInspectorsByStatementType.put(key, insp);
        } else {
            insp = this.requiredAttributesInspectorsByStatementType.get(key);
        }
        if (insp == null) {
            throw new SchemaException("no required attributes inspector found for boolean statement");
        }
        return insp;
    }

    private BooleanStatementSQLMapper resolveSQLMapper(BooleanStatement booleanStatement) {
        Class<?> key = booleanStatement.getClass();
        BooleanStatementSQLMapper mpr = null;
        if (!this.sqlMappersByStatementType.containsKey(key)) {
            for (BooleanStatementSQLMapper mapper : this.booleanStatementSQLMappers) {
                if (!mapper.supports(booleanStatement)) continue;
                mpr = mapper;
                break;
            }
            this.sqlMappersByStatementType.put(key, mpr);
        } else {
            mpr = this.sqlMappersByStatementType.get(key);
        }
        if (mpr == null) {
            throw new SchemaException("no required attributes inspector found for boolean statement");
        }
        return mpr;
    }

    private void createOrderBy(OrderBy orderBy, List<MappingBinding> mappingBindings, String orderByField) {
        block5: {
            block4: {
                int index = orderByField.indexOf(".");
                if (index <= 0) break block4;
                String currentElement = orderByField.substring(0, index);
                if (mappingBindings == null) break block5;
                for (MappingBinding mappingBinding : mappingBindings) {
                    Map subs = mappingBinding.getSubBindings();
                    if (subs == null) continue;
                    String nextElement = orderByField.substring(index + 1);
                    this.createOrderBy(orderBy, (List)subs.get(currentElement), nextElement);
                }
                break block5;
            }
            for (MappingBinding mappingBinding : mappingBindings) {
                List aliases = mappingBinding.getAliases();
                if ("id".equals(orderByField)) {
                    AliasBinding pkAlias = mappingBinding.getPrimaryKeyAlias();
                    orderBy.columnAlias(pkAlias.getAlias());
                    continue;
                }
                if (aliases == null) continue;
                for (AliasBinding alias : aliases) {
                    if (!alias.getAttribute().getName().equals(orderByField)) continue;
                    orderBy.columnAlias(alias.getAlias());
                }
            }
        }
    }

    private void addOrderByFieldToRequiredAttributes(Set<String> requiredAttributes, String orderByField) {
        requiredAttributes.add(orderByField);
        int i = orderByField.lastIndexOf(".");
        if (i > 0) {
            this.addOrderByFieldToRequiredAttributes(requiredAttributes, orderByField.substring(0, i));
        }
    }
}

