/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bndly.schema.api.AliasBinding;
import org.bndly.schema.api.AttributeMediator;
import org.bndly.schema.api.MappingBinding;
import org.bndly.schema.api.MappingBindingsProvider;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.mapper.RowMapper;
import org.bndly.schema.api.services.Accessor;
import org.bndly.schema.impl.MediatorRegistryImpl;
import org.bndly.schema.impl.RecordImpl;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.Type;

public class AliasedRecordRowMapper
implements RowMapper<Record> {
    private final Accessor accessor;
    private final MappingBindingsProvider mappingBindingsProvider;
    private final MediatorRegistryImpl mediatorRegistry;
    private final RecordContext recordContext;

    public AliasedRecordRowMapper(MappingBindingsProvider mappingBindingsProvider, MediatorRegistryImpl mediatorRegistry, Accessor accessor, RecordContext recordContext) {
        this.mappingBindingsProvider = mappingBindingsProvider;
        this.mediatorRegistry = mediatorRegistry;
        this.accessor = accessor;
        this.recordContext = recordContext;
    }

    public Record mapRow(ResultSet rs, int i) throws SQLException {
        Record r = null;
        List mappingBindings = this.mappingBindingsProvider.getMappingBindings();
        if (mappingBindings != null) {
            Iterator it = mappingBindings.iterator();
            while (r == null && it.hasNext()) {
                MappingBinding binding = (MappingBinding)it.next();
                r = this.evaluateBinding(binding, rs);
            }
        }
        if (RecordImpl.class.isInstance(r) && r != null) {
            ((RecordImpl)r).setIsDirty(false);
        }
        return r;
    }

    private Record evaluateBinding(MappingBinding binding, ResultSet rs) throws SQLException {
        AliasBinding pkAlias = binding.getPrimaryKeyAlias();
        Attribute pkAtt = pkAlias.getAttribute();
        AttributeMediator<Attribute> mediator = this.mediatorRegistry.getMediatorForAttribute(pkAtt);
        Object value = mediator.extractFromResultSet(rs, pkAlias.getAlias(), pkAtt, this.recordContext);
        if (value == null) {
            return null;
        }
        Record record = this.recordContext.get((Type)binding.getHolder(), ((Long)value).longValue());
        if (record == null) {
            record = this.recordContext.create(binding.getHolder().getName(), ((Long)value).longValue());
        }
        this.evaluateAliasesOfBinding(binding, rs, record);
        return record;
    }

    private void evaluateAliasesOfBinding(MappingBinding binding, ResultSet rs, Record record) throws SQLException {
        Map subBindingsByAttributeName;
        List a = binding.getAliases();
        if (a != null) {
            for (AliasBinding aliasBinding : a) {
                AttributeMediator<Attribute> mediator = this.mediatorRegistry.getMediatorForAttribute(aliasBinding.getAttribute());
                Object value = mediator.extractFromResultSet(rs, aliasBinding.getAlias(), aliasBinding.getAttribute(), this.recordContext);
                record.setAttributeValue(aliasBinding.getAttribute().getName(), value);
            }
        }
        if ((subBindingsByAttributeName = binding.getSubBindings()) != null) {
            for (Map.Entry entry : subBindingsByAttributeName.entrySet()) {
                String attributeName = (String)entry.getKey();
                List list = (List)entry.getValue();
                for (MappingBinding mappingBinding : list) {
                    Record r = this.evaluateBinding(mappingBinding, rs);
                    if (r == null) continue;
                    record.setAttributeValue(attributeName, (Object)r);
                    break;
                }
                if (record.isAttributePresent(attributeName)) continue;
                record.setAttributeValue(attributeName, null);
            }
        }
    }
}

