/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bndly.schema.api.db.AttributeColumn;
import org.bndly.schema.api.services.ConstraintRegistry;
import org.bndly.schema.impl.Resetable;
import org.bndly.schema.impl.UniqueConstraintOnType;
import org.bndly.schema.model.Type;
import org.bndly.schema.model.UniqueConstraint;

public class ConstraintRegistryImpl
implements ConstraintRegistry,
Resetable {
    private final Map<String, List<UniqueConstraintOnType>> uniqueConstraintByTypeName = new HashMap<String, List<UniqueConstraintOnType>>();
    private final Map<String, List<UniqueConstraintOnType>> uniqueConstraintByTableName = new HashMap<String, List<UniqueConstraintOnType>>();

    public List<UniqueConstraint> getUniqueConstraintsForType(Type type) {
        List<UniqueConstraintOnType> l = this.uniqueConstraintByTypeName.get(type.getName());
        if (l == null) {
            return null;
        }
        ArrayList<UniqueConstraint> r = new ArrayList<UniqueConstraint>();
        for (UniqueConstraintOnType uniqueConstraintOnType : l) {
            r.add(uniqueConstraintOnType.getUniqueConstraint());
        }
        return r;
    }

    public void addUniqueConstraintsForType(UniqueConstraint uniqueConstraint, Type type, AttributeColumn columnInUniqueConstraintTable) {
        List<UniqueConstraintOnType> l = this.uniqueConstraintByTypeName.get(type.getName());
        if (l == null) {
            l = new ArrayList<UniqueConstraintOnType>();
            this.uniqueConstraintByTypeName.put(type.getName(), l);
        }
        l.add(new UniqueConstraintOnType(uniqueConstraint, type, columnInUniqueConstraintTable));
    }

    public AttributeColumn getJoinColumnForTypeInUniqueConstraintTable(UniqueConstraint constraint, Type type) {
        List<UniqueConstraintOnType> l = this.uniqueConstraintByTypeName.get(type.getName());
        if (l != null) {
            for (UniqueConstraintOnType uniqueConstraint : l) {
                if (uniqueConstraint.getUniqueConstraint() != constraint) continue;
                return uniqueConstraint.getColumnInUniqueConstraintTable();
            }
        }
        throw new IllegalStateException("could not find join column for unique constraint");
    }

    @Override
    public void reset() {
        this.uniqueConstraintByTypeName.clear();
        this.uniqueConstraintByTableName.clear();
    }
}

