/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.bndly.schema.api.exception.SchemaException;
import org.bndly.schema.api.services.Engine;
import org.bndly.schema.vendor.ErrorCodeMapper;

public class DefaultErrorCodeMapper
implements ErrorCodeMapper {
    public final SchemaException map(SQLException exception, Engine engine) {
        return this.map(null, exception, exception.getErrorCode(), engine);
    }

    public final SchemaException map(int errorCode, Engine engine) {
        return this.map(null, null, errorCode, engine);
    }

    public final SchemaException map(String message, SQLException exception, Engine engine) {
        return this.map(message, exception, exception.getErrorCode(), engine);
    }

    public final SchemaException map(String message, int errorCode, Engine engine) {
        return this.map(message, null, errorCode, engine);
    }

    protected SchemaException map(String message, SQLException exception, int errorCode, Engine engine) {
        if (message != null) {
            if (exception != null) {
                return new SchemaException(message, (Throwable)exception);
            }
            return new SchemaException(message);
        }
        if (exception != null) {
            return new SchemaException("error code: " + errorCode, (Throwable)exception);
        }
        return new SchemaException("error code: " + errorCode);
    }

    protected final SchemaException createSchemaException(Class<? extends SchemaException> exceptionClass, SQLException ex, String defaultMessage, String message) {
        SchemaException mappedExcpetion;
        Constructor<? extends SchemaException> constructor;
        boolean hasCause;
        boolean bl = hasCause = ex != null;
        if (hasCause) {
            try {
                constructor = exceptionClass.getConstructor(String.class, Throwable.class);
            }
            catch (NoSuchMethodException | SecurityException ex1) {
                return new SchemaException("failed to find constructor. original message: " + defaultMessage + "; " + message, (Throwable)ex);
            }
        }
        try {
            constructor = exceptionClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException | SecurityException ex1) {
            return new SchemaException("failed to find constructor. original message: " + defaultMessage + "; " + message);
        }
        try {
            mappedExcpetion = hasCause ? constructor.newInstance(message, ex) : constructor.newInstance(message);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex1) {
            if (hasCause) {
                return new SchemaException("failed to invoke constructor. original message: " + defaultMessage + "; " + message, (Throwable)ex1);
            }
            return new SchemaException("failed to invoke constructor. original message: " + defaultMessage + "; " + message);
        }
        return mappedExcpetion;
    }
}

