/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bndly.schema.api.mapper.LobHandler;
import org.bndly.schema.api.services.Engine;
import org.bndly.schema.vendor.VendorConfiguration;

public class DefaultLobHandler
implements LobHandler {
    private final VendorConfiguration vendorConfiguration;
    private final Engine engine;

    public DefaultLobHandler(VendorConfiguration vendorConfiguration, Engine engine) {
        this.vendorConfiguration = vendorConfiguration;
        this.engine = engine;
    }

    public byte[] getBlobAsBytes(ResultSet rs, String columnName) {
        try {
            Blob blob = rs.getBlob(columnName);
            return blob.getBytes(0L, (int)blob.length());
        }
        catch (SQLException ex) {
            throw this.vendorConfiguration.getErrorCodeMapper().map("could not get byte[] for blob in column " + columnName, ex, this.engine);
        }
    }

    public InputStream getBlobAsBinaryStream(ResultSet rs, String columnName) {
        try {
            return rs.getBinaryStream(columnName);
        }
        catch (SQLException ex) {
            throw this.vendorConfiguration.getErrorCodeMapper().map("could not get input stream for blob in column " + columnName, ex, this.engine);
        }
    }
}

