/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import org.bndly.schema.api.AttributeMediator;
import org.bndly.schema.api.ForeignKeyConstraint;
import org.bndly.schema.api.db.AttributeColumn;
import org.bndly.schema.api.db.DeploymentState;
import org.bndly.schema.api.db.Index;
import org.bndly.schema.api.db.JoinTable;
import org.bndly.schema.api.db.Table;
import org.bndly.schema.api.db.TypeTable;
import org.bndly.schema.api.db.UniqueConstraintTable;
import org.bndly.schema.api.exception.SchemaException;
import org.bndly.schema.api.listener.SchemaDeploymentListener;
import org.bndly.schema.api.services.ConstraintRegistry;
import org.bndly.schema.api.services.Deployer;
import org.bndly.schema.api.services.Engine;
import org.bndly.schema.api.tx.Template;
import org.bndly.schema.api.tx.TransactionCallback;
import org.bndly.schema.api.tx.TransactionStatus;
import org.bndly.schema.api.tx.TransactionTemplate;
import org.bndly.schema.impl.EngineImpl;
import org.bndly.schema.impl.MediatorRegistryImpl;
import org.bndly.schema.impl.Resetable;
import org.bndly.schema.impl.TableRegistryImpl;
import org.bndly.schema.impl.db.AttributeColumnImpl;
import org.bndly.schema.impl.db.IndexImpl;
import org.bndly.schema.impl.db.JoinTableImpl;
import org.bndly.schema.impl.db.TableImpl;
import org.bndly.schema.impl.db.TypeTableImpl;
import org.bndly.schema.impl.db.UniqueConstraintTableImpl;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.InverseAttribute;
import org.bndly.schema.model.Mixin;
import org.bndly.schema.model.MixinAttribute;
import org.bndly.schema.model.NamedAttributeHolder;
import org.bndly.schema.model.NamedAttributeHolderAttribute;
import org.bndly.schema.model.Schema;
import org.bndly.schema.model.SchemaUtil;
import org.bndly.schema.model.Type;
import org.bndly.schema.model.TypeAttribute;
import org.bndly.schema.model.UniqueConstraint;
import org.bndly.schema.vendor.AntiSQLInject;
import org.bndly.schema.vendor.VendorConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployerImpl
implements Deployer,
Resetable {
    private static final Logger LOG = LoggerFactory.getLogger(DeployerImpl.class);
    private TransactionTemplate transactionTemplate;
    private TableRegistryImpl tableRegistry;
    private MediatorRegistryImpl mediatorRegistry;
    private Schema schema;
    private Map<String, UniqueConstraint> uniqueConstraintsByName;
    private List<String> uniqueConstraintNames;
    private Set<String> tablesForNamedAttributeHolders;
    private List<ForeignKeyConstraint> fkConstraints;
    private List<Index> indices;
    private List<SchemaDeploymentListener> listeners;
    private ReadWriteLock deploymentListenersLock;
    private ConstraintRegistry constraintRegistry;
    private VendorConfiguration vendorConfiguration;
    private String internalDatabaseSchemaName;
    private StringBuffer deploymentSQL;
    private boolean validateOnly;
    private final EngineImpl engine;
    private static final String ALLOWED_IDENTIFIER_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
    private boolean validationErrorIgnored;
    private static final AntiSQLInject ANTI_SQL_INJECT = new AntiSQLInject(){

        public String filterCharactersForSQLIdentifier(String identifierToFilter) {
            StringBuffer sb = new StringBuffer();
            for (int index = 0; index < identifierToFilter.length(); ++index) {
                char character = identifierToFilter.charAt(index);
                if (DeployerImpl.ALLOWED_IDENTIFIER_CHARACTERS.indexOf(character) <= -1) {
                    throw new IllegalArgumentException("found unallowed character for identifier name: " + character);
                }
                sb.append(character);
            }
            String result = sb.toString();
            return result;
        }
    };

    public DeployerImpl(EngineImpl engine) {
        if (engine == null) {
            throw new IllegalArgumentException("deployer requires an engine");
        }
        this.engine = engine;
    }

    public void setValidateOnly(boolean validateOnly) {
        this.validateOnly = validateOnly;
    }

    public void setValidationErrorIgnored(boolean validationErrorIgnored) {
        this.validationErrorIgnored = validationErrorIgnored;
    }

    @Override
    public void reset() {
        this.tablesForNamedAttributeHolders = new HashSet<String>();
        this.fkConstraints = new ArrayList<ForeignKeyConstraint>();
        this.deploymentSQL = new StringBuffer();
        this.uniqueConstraintsByName = new HashMap<String, UniqueConstraint>();
        this.uniqueConstraintNames = new ArrayList<String>();
        this.indices = new ArrayList<Index>();
    }

    public Schema getDeployedSchema() {
        return this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(Schema schema) {
        try {
            this.schema = schema;
            this.reset();
            this.createTables();
            this.createMixinTables();
            this.createUniqueConstraintTables();
            this.addAttributesToTables();
            this.addForeignKeyConstraints();
            this.addIndicesOnColumns();
            this.uniqueConstraintsByName = Collections.unmodifiableMap(this.uniqueConstraintsByName);
            this.uniqueConstraintNames = Collections.unmodifiableList(new ArrayList<String>(this.uniqueConstraintsByName.keySet()));
            if (this.listeners != null) {
                this.deploymentListenersLock.readLock().lock();
                try {
                    for (SchemaDeploymentListener schemaDeploymentListener : this.listeners) {
                        schemaDeploymentListener.schemaDeployed(schema, (Engine)this.engine);
                    }
                }
                finally {
                    this.deploymentListenersLock.readLock().unlock();
                }
            }
            List<SchemaDeploymentListener> listenersTwo = this.engine.getListeners(SchemaDeploymentListener.class, null);
            for (SchemaDeploymentListener schemaDeploymentListener : listenersTwo) {
                schemaDeploymentListener.schemaDeployed(schema, (Engine)this.engine);
            }
        }
        catch (RuntimeException e) {
            LOG.error("failed to deploy schema " + schema.getName(), (Throwable)e);
            throw e;
        }
    }

    public List<String> getUniqueConstraintNames() {
        return this.uniqueConstraintNames;
    }

    public UniqueConstraint getUniqueConstraintByName(String name) {
        return this.uniqueConstraintsByName.get(name);
    }

    public String getDeploymentSQL() {
        return this.deploymentSQL == null ? null : this.deploymentSQL.toString();
    }

    private void createTables() {
        List types = this.schema.getTypes();
        if (types != null) {
            for (Type type : types) {
                this.createTable(type);
            }
        }
    }

    private String getTableNameTransformed(NamedAttributeHolder attributeHolder) {
        if (Type.class.isInstance(attributeHolder)) {
            return this.vendorConfiguration.getIdentifierAdapter().transformTableName(attributeHolder.getName());
        }
        if (Mixin.class.isInstance(attributeHolder)) {
            return this.vendorConfiguration.getIdentifierAdapter().transformTableName(attributeHolder.getName());
        }
        throw new IllegalStateException("unsupported attribute holder");
    }

    private String getTypeTableName(Type type) {
        return this.shortenIdentifier(this.getTableNameTransformed((NamedAttributeHolder)type));
    }

    private String getJoinTableName(Type type) {
        return this.shortenIdentifier(this.vendorConfiguration.getIdentifierAdapter().transformTableName("JOIN_" + type.getName()));
    }

    private String getMixinTableName(Mixin mixin) {
        return this.shortenIdentifier(this.vendorConfiguration.getIdentifierAdapter().transformTableName("MIXIN_" + mixin.getName()));
    }

    public static String filterCharactersForSQLIdentifier(String input) {
        return ANTI_SQL_INJECT.filterCharactersForSQLIdentifier(input);
    }

    private void createTable(Type type) {
        if (type.isVirtual()) {
            return;
        }
        if (this.tablesForNamedAttributeHolderNotHandled((NamedAttributeHolder)type)) {
            List subTypes;
            Type superType = type.getSuperType();
            if (superType != null) {
                this.createTable(superType);
            }
            TableImpl tableToInjectInParentJoinTable = null;
            if (!type.isAbstract()) {
                String tableName = this.getTypeTableName(type);
                TypeTableImpl table = this.tableRegistry.createTypeTable(type, tableName);
                DeploymentState state = this.assertTableExists(table);
                table.setState(state);
                if (superType != null) {
                    tableToInjectInParentJoinTable = table;
                }
            }
            if ((subTypes = type.getSubTypes()) != null && !subTypes.isEmpty()) {
                String tableName = this.getJoinTableName(type);
                JoinTableImpl joinTable = this.tableRegistry.createJoinTable((NamedAttributeHolder)type, tableName);
                DeploymentState state = this.assertTableExists(joinTable);
                joinTable.setState(state);
                if (!type.isAbstract()) {
                    joinTable.getJoinedTables().add((Table)this.tableRegistry.getTypeTableByType(type));
                }
                for (Type subType : subTypes) {
                    this.createTable(subType);
                }
                if (superType != null) {
                    tableToInjectInParentJoinTable = joinTable;
                }
            }
            if (tableToInjectInParentJoinTable != null) {
                JoinTable parentJoinTable = this.tableRegistry.getJoinTableByNamedAttributeHolder((NamedAttributeHolder)superType);
                parentJoinTable.getJoinedTables().add(tableToInjectInParentJoinTable);
            }
        }
    }

    private void createUniqueConstraintTables() {
        List uq = this.schema.getUniqueConstraints();
        if (uq != null) {
            for (UniqueConstraint uniqueConstraint : uq) {
                StringBuilder sb = new StringBuilder().append("UQ_").append(uniqueConstraint.getHolder().getName());
                for (Attribute attribute : uniqueConstraint.getAttributes()) {
                    sb.append("_").append(attribute.getName());
                }
                String tableName = this.shortenIdentifier(this.vendorConfiguration.getIdentifierAdapter().transformTableName(sb.toString()));
                UniqueConstraintTableImpl table = this.tableRegistry.createUniqueConstraintTable(uniqueConstraint, tableName);
                this.createTableWithName(table, false);
            }
        }
    }

    private void addAttributesToTables() {
        for (TypeTable typeTable : this.tableRegistry.getAllTypeTables()) {
            Type type = typeTable.getType();
            List attributes = SchemaUtil.collectAttributes((NamedAttributeHolder)type);
            Iterator iterator = attributes.iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                this.createAttributeForTable(attribute, (Table)typeTable);
            }
        }
        for (JoinTable joinTable : this.tableRegistry.getAllJoinTables()) {
            List joinedTables = joinTable.getJoinedTables();
            for (Table joinedTable : joinedTables) {
                Attribute attribute;
                if (TypeTable.class.isInstance(joinedTable)) {
                    TypeTable tt = (TypeTable)TypeTable.class.cast(joinedTable);
                    TypeAttribute attribute2 = new TypeAttribute();
                    attribute2.setType(tt.getType());
                    attribute2.setName(tt.getType().getName());
                    this.createAttributeForTable((Attribute)attribute2, (Table)joinTable);
                    continue;
                }
                if (!JoinTable.class.isInstance(joinedTable)) continue;
                JoinTable jt = (JoinTable)JoinTable.class.cast(joinedTable);
                NamedAttributeHolder holder = jt.getNamedAttributeHolder();
                if (Type.class.isInstance(holder)) {
                    Type type = (Type)Type.class.cast(holder);
                    attribute = new TypeAttribute();
                    ((TypeAttribute)attribute).setType(type);
                } else if (Mixin.class.isInstance(holder)) {
                    Mixin mixin = (Mixin)Mixin.class.cast(holder);
                    attribute = new MixinAttribute();
                    ((MixinAttribute)attribute).setMixin(mixin);
                } else {
                    throw new IllegalStateException("unsupported named attribute holder");
                }
                attribute.setName(holder.getName());
                this.createAttributeForTable(attribute, (Table)joinTable);
            }
        }
        for (UniqueConstraintTable uniqueConstraintTable : this.tableRegistry.getAllUniqueConstraintTables()) {
            UniqueConstraint uniqueConstraint = uniqueConstraintTable.getUniqueConstraint();
            NamedAttributeHolder holder = uniqueConstraint.getHolder();
            JoinTable joinTable = this.tableRegistry.getJoinTableByNamedAttributeHolder(holder);
            if (joinTable != null) {
                this.createPrimaryKeyAttributesForUniqueConstraintTable((Table)joinTable, uniqueConstraintTable);
            } else {
                TypeTable typeTable = this.tableRegistry.getTypeTableByType(holder.getName());
                this.createPrimaryKeyAttributesForUniqueConstraintTable((Table)typeTable, uniqueConstraintTable);
            }
            ArrayList<AttributeColumn> cols = new ArrayList<AttributeColumn>();
            for (Attribute attribute : uniqueConstraint.getAttributes()) {
                AttributeColumn col = this.createAttributeForTable(attribute, (Table)uniqueConstraintTable);
                if (col == null) continue;
                cols.add(col);
            }
            String constraintName = "CONST_" + uniqueConstraintTable.getTableName();
            String constraintNameTransformed = this.shortenIdentifier(this.vendorConfiguration.getIdentifierAdapter().transformConstraintName(constraintName));
            this.makeColumnsUnique(constraintNameTransformed, (Table)uniqueConstraintTable, cols.toArray(new AttributeColumn[cols.size()]));
            this.uniqueConstraintsByName.put(constraintNameTransformed, uniqueConstraint);
        }
    }

    private String shortenIdentifier(String identifierName) {
        LOG.debug("testing identifier length: '{}'", (Object)identifierName);
        int hc = identifierName.hashCode();
        if (hc < 0) {
            hc *= -1;
        }
        String hcString = "" + hc;
        int hashLength = hcString.length();
        int maxLength = this.vendorConfiguration.getIdentifierAdapter().getIdentifierMaxLength();
        if (identifierName.length() > maxLength) {
            LOG.debug("identifier length {} > {} of exceeded by '{}' {}", new Object[]{identifierName.length(), maxLength, identifierName});
            String shortened = identifierName.substring(0, maxLength - hashLength) + hcString;
            LOG.debug("shortened identifier '{}' to '{}'", (Object)identifierName, (Object)shortened);
            return shortened;
        }
        LOG.debug("no shortening for identifier '{}'", (Object)identifierName);
        return identifierName;
    }

    private void makeColumnsUnique(String constraintName, Table table, AttributeColumn ... columns) {
        if (this.isConstraintDefinedOnTable(constraintName, table)) {
            return;
        }
        StringBuilder sb = new StringBuilder().append("ALTER TABLE ").append(DeployerImpl.filterCharactersForSQLIdentifier(table.getTableName())).append(" ADD CONSTRAINT ").append(DeployerImpl.filterCharactersForSQLIdentifier(constraintName)).append(" UNIQUE(");
        boolean first = true;
        for (AttributeColumn col : columns) {
            if (col == null) continue;
            if (!first) {
                sb.append(',');
            }
            sb.append(DeployerImpl.filterCharactersForSQLIdentifier(col.getColumnName()));
            first = false;
        }
        sb.append(")");
        final String constraintSql = sb.toString();
        this.transactionTemplate.doInTransaction(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus transactionStatus, Template template) {
                template.execute(constraintSql);
                return null;
            }
        });
    }

    private void createPrimaryKeyAttributesForUniqueConstraintTable(Table table, UniqueConstraintTable uniqueConstraintTable) {
        if (JoinTable.class.isInstance(table)) {
            JoinTable jt = (JoinTable)JoinTable.class.cast(table);
            for (Table table1 : jt.getJoinedTables()) {
                this.createPrimaryKeyAttributesForUniqueConstraintTable(table1, uniqueConstraintTable);
            }
        } else if (TypeTable.class.isInstance(table)) {
            TypeTable tt = (TypeTable)TypeTable.class.cast(table);
            TypeAttribute ta = new TypeAttribute();
            ta.setType(tt.getType());
            ta.setName(tt.getType().getName());
            ta.setMandatory(false);
            AttributeColumn col = this.createAttributeForTable((Attribute)ta, (Table)uniqueConstraintTable);
            uniqueConstraintTable.getHolderColumns().add(col);
            this.constraintRegistry.addUniqueConstraintsForType(uniqueConstraintTable.getUniqueConstraint(), tt.getType(), col);
            StringBuffer sb = new StringBuffer();
            sb.append("FKNQ_").append(DeployerImpl.filterCharactersForSQLIdentifier(uniqueConstraintTable.getTableName())).append("_").append(DeployerImpl.filterCharactersForSQLIdentifier(col.getColumnName())).append("_TO_").append(DeployerImpl.filterCharactersForSQLIdentifier(tt.getTableName())).append("_").append(DeployerImpl.filterCharactersForSQLIdentifier(tt.getPrimaryKeyColumn().getColumnName()));
            String name = sb.toString();
            String nameTransformed = this.shortenIdentifier(this.vendorConfiguration.getIdentifierAdapter().transformConstraintName(name));
            ForeignKeyConstraint fk = new ForeignKeyConstraint(nameTransformed);
            fk.setOnDelete(ForeignKeyConstraint.OnDelete.CASCADE);
            fk.setReferencingColumn(col);
            fk.setReferencingTable((Table)uniqueConstraintTable);
            TypeTable referencedTable = tt;
            fk.setReferencedTable((Table)referencedTable);
            fk.setReferencedColumn(referencedTable.getPrimaryKeyColumn());
            this.fkConstraints.add(fk);
            String constraintName = "CON_" + DeployerImpl.filterCharactersForSQLIdentifier(uniqueConstraintTable.getTableName()) + DeployerImpl.filterCharactersForSQLIdentifier(this.getTableNameTransformed((NamedAttributeHolder)tt.getType()));
            String constraintNameTransformed = this.shortenIdentifier(this.vendorConfiguration.getIdentifierAdapter().transformConstraintName(constraintName));
            this.makeColumnsUnique(constraintNameTransformed, (Table)uniqueConstraintTable, col);
        }
    }

    private void createMixinTables() {
        List mixins = this.schema.getMixins();
        if (mixins != null) {
            for (Mixin mixin : mixins) {
                List joined;
                if (mixin.isVirtual() || !this.tablesForNamedAttributeHolderNotHandled((NamedAttributeHolder)mixin) || (joined = mixin.getMixedInto()) == null || joined.isEmpty()) continue;
                String tableName = this.getMixinTableName(mixin);
                JoinTableImpl jt = this.tableRegistry.createJoinTable((NamedAttributeHolder)mixin, tableName);
                DeploymentState state = this.assertTableExists(jt);
                jt.setState(state);
                for (Type joinedType : joined) {
                    List joinedTypeSubTypes = joinedType.getSubTypes();
                    Object table = joinedTypeSubTypes != null && !joinedTypeSubTypes.isEmpty() ? this.tableRegistry.getJoinTableByNamedAttributeHolder((NamedAttributeHolder)joinedType) : this.tableRegistry.getTypeTableByType(joinedType);
                    jt.getJoinedTables().add((Table)table);
                }
            }
        }
    }

    private void addForeignKeyConstraints() {
        for (JoinTable joinTable : this.tableRegistry.getAllJoinTables()) {
            this.addForeignKeyConstraintsForTable((Table)joinTable, true);
        }
        for (TypeTable typeTable : this.tableRegistry.getAllTypeTables()) {
            this.addForeignKeyConstraintsForTable((Table)typeTable, false);
        }
        for (UniqueConstraintTable uniqueConstraintTable : this.tableRegistry.getAllUniqueConstraintTables()) {
            this.addForeignKeyConstraintsForTable((Table)uniqueConstraintTable, true);
        }
        for (ForeignKeyConstraint foreignKeyConstraint : this.fkConstraints) {
            String constraintName = foreignKeyConstraint.getName();
            Table table = foreignKeyConstraint.getReferencingTable();
            StringBuilder sb = new StringBuilder().append("ALTER TABLE ").append(DeployerImpl.filterCharactersForSQLIdentifier(foreignKeyConstraint.getReferencingTable().getTableName())).append(" ADD CONSTRAINT ").append(DeployerImpl.filterCharactersForSQLIdentifier(constraintName)).append(" FOREIGN KEY (").append(DeployerImpl.filterCharactersForSQLIdentifier(foreignKeyConstraint.getReferencingColumn().getColumnName())).append(") REFERENCES ").append(DeployerImpl.filterCharactersForSQLIdentifier(foreignKeyConstraint.getReferencedTable().getTableName())).append("(").append(DeployerImpl.filterCharactersForSQLIdentifier(foreignKeyConstraint.getReferencedColumn().getColumnName())).append(")");
            ForeignKeyConstraint.OnDelete onDelete = foreignKeyConstraint.getOnDelete();
            if (onDelete == ForeignKeyConstraint.OnDelete.CASCADE) {
                sb.append(" ON DELETE CASCADE");
            } else if (onDelete == ForeignKeyConstraint.OnDelete.SETNULL) {
                sb.append(" ON DELETE SET NULL");
            }
            final String sql = sb.toString();
            this.deploymentSQL.append(sql).append(";\n");
            if (this.isConstraintDefinedOnTable(constraintName, table)) {
                LOG.info("constraint {} is already defined", (Object)constraintName);
                continue;
            }
            if (this.validateOnly) {
                if (this.validationErrorIgnored) {
                    LOG.debug("constraint did not exist: {}", (Object)constraintName);
                } else {
                    throw new SchemaException("constraint did not exist: " + constraintName);
                }
            }
            this.transactionTemplate.doInTransaction(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus transactionStatus, Template template) {
                    template.execute(sql);
                    return null;
                }
            });
        }
    }

    private void addForeignKeyConstraintsForTable(Table table, boolean cascadeDelete) {
        for (AttributeColumn attributeColumn : table.getColumns()) {
            Attribute att = attributeColumn.getAttribute();
            if (!NamedAttributeHolderAttribute.class.isInstance(att)) continue;
            NamedAttributeHolderAttribute namedAttributeHolderAttribute = (NamedAttributeHolderAttribute)att;
            NamedAttributeHolder referenced = namedAttributeHolderAttribute.getNamedAttributeHolder();
            JoinTable referencedTable = this.tableRegistry.getJoinTableByNamedAttributeHolder(referenced);
            if (referencedTable == null) {
                referencedTable = this.tableRegistry.getTypeTableByType(referenced.getName());
            }
            if (referencedTable == null) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("FKTR_").append(table.getTableName()).append("_").append(attributeColumn.getColumnName()).append("_TO_").append(referencedTable.getTableName()).append("_").append(referencedTable.getPrimaryKeyColumn().getColumnName());
            String name = sb.toString();
            String nameTransformed = this.shortenIdentifier(this.vendorConfiguration.getIdentifierAdapter().transformConstraintName(name));
            ForeignKeyConstraint fk = new ForeignKeyConstraint(nameTransformed);
            ForeignKeyConstraint.OnDelete onDelete = null;
            if (cascadeDelete) {
                onDelete = ForeignKeyConstraint.OnDelete.CASCADE;
            }
            if (namedAttributeHolderAttribute.getCascadeDelete() == null && namedAttributeHolderAttribute.getNullOnDelete() == null) {
                Type currentType = TypeTable.class.isInstance(table) ? ((TypeTable)table).getType() : null;
                List attributes = namedAttributeHolderAttribute.getNamedAttributeHolder().getAttributes();
                if (attributes != null) {
                    for (Attribute attribute : attributes) {
                        InverseAttribute ia;
                        if (!InverseAttribute.class.isInstance(attribute) || (ia = (InverseAttribute)attribute).getReferencedAttributeHolder() != currentType || !ia.getReferencedAttributeName().equals(namedAttributeHolderAttribute.getName())) continue;
                        if (ia.getDeleteOrphans() != null && ia.getDeleteOrphans().booleanValue()) {
                            namedAttributeHolderAttribute.setCascadeDelete(Boolean.valueOf(true));
                            onDelete = ForeignKeyConstraint.OnDelete.CASCADE;
                        }
                        break;
                    }
                }
            } else if (namedAttributeHolderAttribute.getCascadeDelete() != null && namedAttributeHolderAttribute.getNullOnDelete() == null) {
                if (namedAttributeHolderAttribute.getCascadeDelete().booleanValue()) {
                    onDelete = ForeignKeyConstraint.OnDelete.CASCADE;
                }
            } else if (namedAttributeHolderAttribute.getCascadeDelete() == null && namedAttributeHolderAttribute.getNullOnDelete() != null) {
                if (namedAttributeHolderAttribute.getNullOnDelete().booleanValue()) {
                    onDelete = ForeignKeyConstraint.OnDelete.SETNULL;
                }
            } else {
                throw new IllegalStateException("either cascade delete or set null on delete has to be used");
            }
            fk.setOnDelete(onDelete);
            fk.setReferencedTable((Table)referencedTable);
            fk.setReferencedColumn(referencedTable.getPrimaryKeyColumn());
            fk.setReferencingColumn(attributeColumn);
            fk.setReferencingTable(table);
            this.fkConstraints.add(fk);
        }
    }

    private void addIndicesOnColumns() {
        for (JoinTable joinTable : this.tableRegistry.getAllJoinTables()) {
            this.addIndicesForTable((Table)joinTable);
        }
        for (TypeTable typeTable : this.tableRegistry.getAllTypeTables()) {
            this.addIndicesForTable((Table)typeTable);
        }
        for (UniqueConstraintTable uniqueConstraintTable : this.tableRegistry.getAllUniqueConstraintTables()) {
            this.addIndicesForTable((Table)uniqueConstraintTable);
        }
    }

    private void addIndicesForTable(Table table) {
        List columns = table.getColumns();
        if (columns != null) {
            for (AttributeColumn column : columns) {
                if (!column.requiresIndex()) continue;
                String indexName = this.shortenIdentifier(DeployerImpl.filterCharactersForSQLIdentifier(new StringBuffer("IDX_").append(table.getTableName()).append("_").append(column.getColumnName()).toString()));
                String finalIndexName = this.vendorConfiguration.getIdentifierAdapter().transformIndexName(indexName);
                StringBuilder sb = new StringBuilder();
                sb.append("CREATE INDEX ");
                sb.append(finalIndexName);
                sb.append(" ON ");
                if (this.internalDatabaseSchemaName != null) {
                    sb.append(DeployerImpl.filterCharactersForSQLIdentifier(this.internalDatabaseSchemaName));
                    sb.append(".");
                }
                sb.append(DeployerImpl.filterCharactersForSQLIdentifier(table.getTableName()));
                sb.append("(");
                sb.append(DeployerImpl.filterCharactersForSQLIdentifier(column.getColumnName()));
                sb.append(")");
                final String sql = sb.toString();
                this.deploymentSQL.append(sql).append(";\n");
                List<AttributeColumn> indexedColumns = Collections.unmodifiableList(Arrays.asList(column));
                IndexImpl index = new IndexImpl(finalIndexName, indexedColumns, table);
                this.indices.add(index);
                boolean doesExist = this.vendorConfiguration.getIndexExistenceAdapter().isIndexDefinedOnTableColumn(this.internalDatabaseSchemaName, finalIndexName, table, this.transactionTemplate);
                if (!doesExist) {
                    if (this.validateOnly) {
                        if (this.validationErrorIgnored) {
                            LOG.debug("index did not exist: {}", (Object)finalIndexName);
                        } else {
                            throw new SchemaException("index did not exist: " + finalIndexName);
                        }
                    }
                    LOG.debug("trying to create index {} on {}.{}", new Object[]{finalIndexName, table.getTableName(), column.getColumnName()});
                    try {
                        this.transactionTemplate.doInTransaction(new TransactionCallback(){

                            public Object doInTransaction(TransactionStatus transactionStatus, Template template) {
                                template.execute(sql);
                                return null;
                            }
                        });
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("could not create index " + finalIndexName + ": " + ex.getMessage(), ex);
                    }
                    index.setState(DeploymentState.CREATED);
                    continue;
                }
                LOG.debug("skipping creation of index {} on {}.{}, because it does already exist", new Object[]{finalIndexName, table.getTableName(), column.getColumnName()});
                index.setState(DeploymentState.FOUND);
            }
        }
    }

    private void createTableWithName(TableImpl table, boolean generatePrimaryKey) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(DeployerImpl.filterCharactersForSQLIdentifier(table.getTableName()));
        sb.append("(");
        sb.append(this.vendorConfiguration.getIdentifierAdapter().transformColumnName("ID"));
        String primaryKeyDefinition = this.vendorConfiguration.getPrimaryKeyAdapter().getTablePrimaryKeyAttributeDefinition();
        if (primaryKeyDefinition != null) {
            sb.append(primaryKeyDefinition);
        }
        sb.append(")");
        final String sql = sb.toString();
        this.deploymentSQL.append(sql).append(";\n");
        if (this.tableExists(table.getTableName())) {
            table.setState(DeploymentState.FOUND);
            return;
        }
        table.setState(DeploymentState.CREATED);
        if (this.validateOnly) {
            if (this.validationErrorIgnored) {
                LOG.debug("required table did not exist: table={}", (Object)table.getTableName());
            } else {
                throw new SchemaException("could not deploy schema, because a required table did not exist: table=" + table.getTableName());
            }
        }
        try {
            this.transactionTemplate.doInTransaction(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus transactionStatus, Template template) {
                    template.execute(sql);
                    return null;
                }
            });
        }
        catch (Exception ex) {
            throw new IllegalStateException("could not create table: " + ex.getMessage(), ex);
        }
        if (!this.tableExists(table.getTableName())) {
            throw new IllegalStateException("created table, but can not query it.");
        }
        LOG.debug("CREATED TABLE: " + table.getTableName());
    }

    private void createTableWithNameAndPrimaryKey(TableImpl table) {
        this.createTableWithName(table, true);
    }

    private boolean doesColumnExistInTable(String tableName, String columnName) {
        return this.vendorConfiguration.getColumnExistenceAdapter().isColumnDefinedOnTable(this.internalDatabaseSchemaName, columnName, tableName, this.transactionTemplate);
    }

    private boolean tableExists(String name) {
        return this.vendorConfiguration.getTableExistenceAdapter().isTableDefined(this.internalDatabaseSchemaName, name, this.transactionTemplate, ANTI_SQL_INJECT);
    }

    private boolean isConstraintDefinedOnTable(String constraintName, Table table) {
        return this.vendorConfiguration.getConstraintExistenceAdapter().isConstraintDefinedOnTable(this.internalDatabaseSchemaName, constraintName, table, this.transactionTemplate);
    }

    private AttributeColumn createAttributeForTable(Attribute attribute, Table table) {
        if (attribute.isVirtual()) {
            return null;
        }
        String tableName = table.getTableName();
        AttributeMediator<Attribute> mediator = this.mediatorRegistry.getMediatorForAttribute(attribute);
        if (mediator.requiresColumnMapping(attribute)) {
            String columnNameTransformed = this.getAttributeColumnNameTransformed(attribute);
            String columnType = mediator.columnType(attribute);
            if (columnNameTransformed != null && columnType != null) {
                boolean hasUniqueConstraint;
                boolean requiresIndex;
                boolean bl = requiresIndex = attribute.isIndexed() && !attribute.isVirtual();
                if (requiresIndex && this.vendorConfiguration.getIndexExistenceAdapter().isUniqueColumnIndexedAutomatically() && (hasUniqueConstraint = this.isSingleColumnUniqueConstraintDefinedForAttribute(attribute))) {
                    requiresIndex = false;
                }
                AttributeColumnImpl attributeColumn = new AttributeColumnImpl(attribute, columnNameTransformed, columnType, table, requiresIndex, false);
                StringBuilder sb = new StringBuilder();
                sb.append("ALTER TABLE ");
                sb.append(DeployerImpl.filterCharactersForSQLIdentifier(tableName));
                sb.append(" ADD COLUMN ");
                sb.append(DeployerImpl.filterCharactersForSQLIdentifier(columnNameTransformed));
                sb.append(" ");
                sb.append(columnType);
                if (attribute.isMandatory()) {
                    sb.append(" NOT");
                }
                sb.append(" NULL");
                final String sql = sb.toString();
                this.deploymentSQL.append(sql).append(";\n");
                boolean columnExists = this.doesColumnExistInTable(tableName, columnNameTransformed);
                if (columnExists) {
                    table.getColumns().add(attributeColumn);
                    return attributeColumn;
                }
                if (!columnExists && this.validateOnly) {
                    if (this.validationErrorIgnored) {
                        LOG.debug("could not find column table: {}.{}({})", new Object[]{tableName, columnNameTransformed, columnType});
                    } else {
                        throw new SchemaException("could not find column table: " + tableName + "." + columnNameTransformed + "(" + columnType + ")");
                    }
                }
                try {
                    this.transactionTemplate.doInTransaction(new TransactionCallback(){

                        public Object doInTransaction(TransactionStatus transactionStatus, Template template) {
                            template.execute(sql);
                            return null;
                        }
                    });
                }
                catch (Exception ex) {
                    LOG.error("COULD NOT CREATE COLUMN FOR ATTRIBUTE: " + columnNameTransformed + " " + attribute.getName(), (Throwable)ex);
                    throw new IllegalStateException("could not create column for attribute: " + ex.getMessage(), ex);
                }
                table.getColumns().add(attributeColumn);
                LOG.debug("CREATED COLUMN FOR ATTRIBUTE: " + columnNameTransformed + " " + attribute.getName());
                return attributeColumn;
            }
        }
        return null;
    }

    private boolean isSingleColumnUniqueConstraintDefinedForAttribute(Attribute attribute) {
        for (UniqueConstraint uniqueConstraint : this.uniqueConstraintsByName.values()) {
            List attributes = uniqueConstraint.getAttributes();
            if (attributes == null || attributes.size() != 1 || attribute != attributes.get(0)) continue;
            return true;
        }
        return false;
    }

    private boolean tablesForNamedAttributeHolderNotHandled(NamedAttributeHolder nah) {
        String n = nah.getName();
        boolean r = !this.tablesForNamedAttributeHolders.contains(n);
        this.tablesForNamedAttributeHolders.add(n);
        return r;
    }

    public void setMediatorRegistry(MediatorRegistryImpl mediatorRegistry) {
        this.mediatorRegistry = mediatorRegistry;
    }

    public void setTableRegistry(TableRegistryImpl tableRegistry) {
        this.tableRegistry = tableRegistry;
    }

    private DeploymentState assertTableExists(TableImpl table) {
        this.createTableWithNameAndPrimaryKey(table);
        return table.getState();
    }

    public void setDatabaseSchemaName(String schemaName) {
        this.internalDatabaseSchemaName = schemaName;
    }

    public void setListeners(List<SchemaDeploymentListener> listeners, ReadWriteLock deploymentListenersLock) {
        this.listeners = listeners;
        this.deploymentListenersLock = deploymentListenersLock;
    }

    public void setConstraintRegistry(ConstraintRegistry constraintRegistry) {
        this.constraintRegistry = constraintRegistry;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    private String getAttributeColumnNameTransformed(Attribute attribute) {
        AttributeMediator<Attribute> med = this.mediatorRegistry.getMediatorForAttribute(attribute);
        if (med == null) {
            throw new IllegalStateException("could not find mediator for attribute " + attribute.getName());
        }
        String columnNameTransformed = this.vendorConfiguration.getIdentifierAdapter().transformColumnName(med.columnName(attribute));
        return columnNameTransformed;
    }

    public void setVendorConfiguration(VendorConfiguration vendorConfiguration) {
        this.vendorConfiguration = vendorConfiguration;
    }
}

