/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bndly.schema.api.listener.DeleteListener;
import org.bndly.schema.api.listener.MergeListener;
import org.bndly.schema.api.listener.PersistListener;
import org.bndly.schema.api.listener.PreDeleteListener;
import org.bndly.schema.api.listener.PreMergeListener;
import org.bndly.schema.api.listener.PrePersistListener;
import org.bndly.schema.api.listener.SchemaDeploymentListener;
import org.bndly.schema.api.listener.TransactionListener;

class ListenerRegistry {
    private final Map<TypeBoundListenerKey<?>, List<Object>> listenersByJavaTypeAndSchemaType = new HashMap();
    private Map<TypeBoundListenerKey<?>, List<Object>> listenersByJavaTypeAndSchemaTypeDefensive = new HashMap();
    private final ReadWriteLock listenersLock = new ReentrantReadWriteLock();
    private static final Class[] TYPE_RELATED_LISTENER_TYPES = new Class[]{PreMergeListener.class, MergeListener.class, PrePersistListener.class, PersistListener.class, PreDeleteListener.class, DeleteListener.class};
    private static final Class[] GLOBAL_LISTENER_TYPES = new Class[]{SchemaDeploymentListener.class, TransactionListener.class};

    ListenerRegistry() {
    }

    void addListener(Object object) {
        this.addListenerForTypes(object, new String[0]);
    }

    void addListenerForTypes(Object object, String ... typeNames) {
        if (object == null) {
            return;
        }
        this.listenersLock.writeLock().lock();
        try {
            this.addAsListener(object, SchemaDeploymentListener.class, new String[0]);
            this.addAsListener(object, TransactionListener.class, new String[0]);
            this.addAsListener(object, PreMergeListener.class, typeNames);
            this.addAsListener(object, MergeListener.class, typeNames);
            this.addAsListener(object, PrePersistListener.class, typeNames);
            this.addAsListener(object, PersistListener.class, typeNames);
            this.addAsListener(object, PreDeleteListener.class, typeNames);
            this.addAsListener(object, DeleteListener.class, typeNames);
            this.updateListeners(GLOBAL_LISTENER_TYPES, TYPE_RELATED_LISTENER_TYPES, typeNames);
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    void removeListener(Object object) {
        if (object == null) {
            return;
        }
        this.listenersLock.writeLock().lock();
        try {
            HashSet<String> affectedTypeNames = new HashSet<String>();
            this.removeAsListener(object, SchemaDeploymentListener.class, affectedTypeNames);
            this.removeAsListener(object, TransactionListener.class, affectedTypeNames);
            this.removeAsListener(object, PreMergeListener.class, affectedTypeNames);
            this.removeAsListener(object, MergeListener.class, affectedTypeNames);
            this.removeAsListener(object, PrePersistListener.class, affectedTypeNames);
            this.removeAsListener(object, PersistListener.class, affectedTypeNames);
            this.removeAsListener(object, PreDeleteListener.class, affectedTypeNames);
            this.removeAsListener(object, DeleteListener.class, affectedTypeNames);
            this.updateListeners(GLOBAL_LISTENER_TYPES, TYPE_RELATED_LISTENER_TYPES, affectedTypeNames.toArray(new String[affectedTypeNames.size()]));
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    void updateListeners(Class[] globalListenerTypes, Class[] typeRelatedListenerTypes, String ... typeNames) {
        this.listenersByJavaTypeAndSchemaTypeDefensive = new HashMap();
        for (Class listenerType : typeRelatedListenerTypes) {
            for (String typeName : typeNames) {
                this.compileListeners(listenerType, typeName);
            }
        }
        for (Class listenerType : globalListenerTypes) {
            this.compileListeners(listenerType, null);
        }
    }

    private void removeAsListener(Object object, Class<?> listenerType, Collection<String> affectedTypeNames) {
        if (listenerType.isInstance(object)) {
            Iterator<Map.Entry<TypeBoundListenerKey<?>, List<Object>>> entrySetIter = this.listenersByJavaTypeAndSchemaType.entrySet().iterator();
            while (entrySetIter.hasNext()) {
                List<Object> l;
                Map.Entry<TypeBoundListenerKey<?>, List<Object>> entry = entrySetIter.next();
                TypeBoundListenerKey<?> key = entry.getKey();
                if (!((TypeBoundListenerKey)key).listenerType.equals(listenerType) || (l = entry.getValue()) == null) continue;
                Iterator<Object> iterator = l.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != object) continue;
                    iterator.remove();
                    affectedTypeNames.add(((TypeBoundListenerKey)key).typeName);
                }
                if (!l.isEmpty()) continue;
                entrySetIter.remove();
            }
        }
    }

    private void addAsListener(Object object, Class<?> listenerType, String ... typeNames) {
        if (listenerType.isInstance(object)) {
            if (typeNames != null && typeNames.length > 0) {
                for (String typeName : typeNames) {
                    TypeBoundListenerKey key = new TypeBoundListenerKey(listenerType, typeName);
                    List<Object> l = this.listenersByJavaTypeAndSchemaType.get(key);
                    if (l == null) {
                        l = new ArrayList<Object>();
                        this.listenersByJavaTypeAndSchemaType.put(key, l);
                    }
                    l.add(object);
                }
            } else {
                TypeBoundListenerKey key = new TypeBoundListenerKey(listenerType, null);
                List<Object> l = this.listenersByJavaTypeAndSchemaType.get(key);
                if (l == null) {
                    l = new ArrayList<Object>();
                    this.listenersByJavaTypeAndSchemaType.put(key, l);
                }
                l.add(object);
            }
        }
    }

    <E> List<E> getListeners(Class<E> listenerType, String typeName) {
        return this.compileListeners(listenerType, typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> List<E> compileListeners(Class<E> listenerType, String typeName) {
        Map<TypeBoundListenerKey<?>, List<Object>> map = this.listenersByJavaTypeAndSchemaTypeDefensive;
        TypeBoundListenerKey<E> key = new TypeBoundListenerKey<E>(listenerType, typeName);
        List<Object> result = map.get(key);
        if (result == null) {
            this.listenersLock.writeLock().lock();
            try {
                List<Object> typeSpecificListeners;
                result = new ArrayList<Object>();
                if (typeName != null) {
                    result.addAll(this.compileListeners(listenerType, null));
                }
                if ((typeSpecificListeners = this.listenersByJavaTypeAndSchemaType.get(key)) != null) {
                    result.addAll(typeSpecificListeners);
                }
                map.put(key, result);
            }
            finally {
                this.listenersLock.writeLock().unlock();
            }
        }
        return result;
    }

    private static final class TypeBoundListenerKey<E> {
        private final Class<E> listenerType;
        private final String typeName;

        public TypeBoundListenerKey(Class<E> listenerType, String typeName) {
            this.listenerType = listenerType;
            this.typeName = typeName;
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + Objects.hashCode(this.listenerType);
            hash = 97 * hash + Objects.hashCode(this.typeName);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeBoundListenerKey other = (TypeBoundListenerKey)obj;
            if (!Objects.equals(this.typeName, other.typeName)) {
                return false;
            }
            return Objects.equals(this.listenerType, other.listenerType);
        }

        public String toString() {
            return this.listenerType.getSimpleName() + "->" + this.typeName;
        }
    }
}

