/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bndly.schema.api.AliasBinding;
import org.bndly.schema.api.AttributeMediator;
import org.bndly.schema.api.LoadedAttributes;
import org.bndly.schema.api.MappingBinding;
import org.bndly.schema.api.MappingBindingsProvider;
import org.bndly.schema.api.ObjectReference;
import org.bndly.schema.api.Pagination;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.Transaction;
import org.bndly.schema.api.db.AttributeColumn;
import org.bndly.schema.api.db.Table;
import org.bndly.schema.api.db.TypeTable;
import org.bndly.schema.api.query.Expression;
import org.bndly.schema.api.query.NestedQueryAttribute;
import org.bndly.schema.api.query.OrderBy;
import org.bndly.schema.api.query.PreparedStatementValueProvider;
import org.bndly.schema.api.query.QueryAttribute;
import org.bndly.schema.api.query.QueryContext;
import org.bndly.schema.api.query.Select;
import org.bndly.schema.api.query.SimpleQueryAttribute;
import org.bndly.schema.api.query.ValueProvider;
import org.bndly.schema.api.query.Where;
import org.bndly.schema.api.query.WrapperExpression;
import org.bndly.schema.api.services.QueryByExample;
import org.bndly.schema.api.services.TableRegistry;
import org.bndly.schema.impl.EngineImpl;
import org.bndly.schema.impl.LoadingIterator;
import org.bndly.schema.impl.query.ExpressionProducer;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.BinaryAttribute;
import org.bndly.schema.model.InverseAttribute;
import org.bndly.schema.model.NamedAttributeHolder;
import org.bndly.schema.model.NamedAttributeHolderAttribute;
import org.bndly.schema.model.SchemaUtil;
import org.bndly.schema.model.Type;

public class QueryByExampleImpl
implements QueryByExample {
    private final EngineImpl engine;
    private final NamedAttributeHolder namedAttributeHolder;
    private final QueryContext queryContext;
    private final Map<String, Attribute> attributesByName = new HashMap<String, Attribute>();
    private final Select select;
    private Where where;
    private Table rootTable;
    private final List<QueryAttribute> queryAttributes = new ArrayList<QueryAttribute>();
    private final List<QueryAttribute> rootQueryAttributes = new ArrayList<QueryAttribute>();
    private LoadingIterator loadingIterator;
    private final RecordContext recordContext;
    private String sortDirection;
    private Attribute sortAttribute;

    public QueryByExampleImpl(NamedAttributeHolder namedAttributeHolder, EngineImpl engine, RecordContext recordContext) {
        this.namedAttributeHolder = namedAttributeHolder;
        this.engine = engine;
        this.queryContext = engine.getQueryContextFactory().buildQueryContext();
        this.select = this.queryContext.select();
        for (Attribute attribute : SchemaUtil.collectAttributes((NamedAttributeHolder)namedAttributeHolder)) {
            this.attributesByName.put(attribute.getName(), attribute);
        }
        this.rootTable = engine.getTableRegistry().getJoinTableByNamedAttributeHolder(namedAttributeHolder);
        if (this.rootTable == null) {
            this.rootTable = engine.getTableRegistry().getTypeTableByType(namedAttributeHolder.getName());
        }
        this.recordContext = recordContext;
    }

    public QueryByExample lazy() {
        return this.applyLoadingStrategy(false);
    }

    public QueryByExample eager() {
        return this.applyLoadingStrategy(true);
    }

    private QueryByExample applyLoadingStrategy(final boolean eager) {
        if (this.loadingIterator != null) {
            throw new IllegalStateException("a loading strategy has already been defined.");
        }
        final HashSet<String> attributePaths = new HashSet<String>();
        this.addQueriedAttributePaths(attributePaths, this.queryAttributes, "");
        TableRegistry tableRegistry = this.engine.getTableRegistry();
        this.loadingIterator = new LoadingIterator(tableRegistry, this.select, new LoadedAttributes(){

            public LoadedAttributes.Strategy isLoaded(Attribute attribute, String attributePath) {
                LoadedAttributes.Strategy strategy = LoadedAttributes.Strategy.LOADED;
                if (!attributePaths.contains(attributePath)) {
                    if (attributePath.contains(".")) {
                        strategy = eager ? strategy : LoadedAttributes.Strategy.NOT_LOADED;
                    } else if (NamedAttributeHolderAttribute.class.isInstance(attribute)) {
                        strategy = eager ? strategy : LoadedAttributes.Strategy.LAZY_LOADED;
                    }
                }
                return strategy;
            }
        }, Collections.EMPTY_SET);
        this.loadingIterator.iterate(this.namedAttributeHolder.getName());
        this.queryContext.setExternalMappingBindingsProvider((MappingBindingsProvider)this.loadingIterator);
        return this;
    }

    public QueryByExample attribute(String attributeName, Object value) {
        this.assertAttributeIsKnown(attributeName);
        Attribute attribute = this.attributesByName.get(attributeName);
        if (attribute != null) {
            QueryAttribute qa = this.buildQueryAttribute(attribute, value);
            this.queryAttributes.add(qa);
        } else {
            AttributeColumn pkColumn = this.rootTable.getPrimaryKeyColumn();
            Attribute att = pkColumn.getAttribute();
            if (attributeName.equals(att.getName())) {
                SimpleQueryAttribute qa = new SimpleQueryAttribute(value, att);
                this.rootQueryAttributes.add((QueryAttribute)qa);
            } else {
                throw new IllegalArgumentException("unknown attribute: " + attributeName);
            }
        }
        return this;
    }

    private Attribute assertAttributeIsKnown(String attributeName) throws IllegalArgumentException {
        if (!this.attributesByName.containsKey(attributeName) && !"id".equals(attributeName)) {
            throw new IllegalArgumentException("unknown attribute: " + attributeName + " in " + this.namedAttributeHolder.getName());
        }
        return this.attributesByName.get(attributeName);
    }

    private void appendNestedAttributesToQuery(Record r, NestedQueryAttribute nqa) {
        for (Attribute attribute : SchemaUtil.collectAttributes((NamedAttributeHolder)r.getType())) {
            Object v;
            if (!r.isAttributePresent(attribute.getName()) || BinaryAttribute.class.isInstance(v = r.getAttributeValue(attribute.getName())) || InverseAttribute.class.isInstance(v)) continue;
            QueryAttribute qa = this.buildQueryAttribute(attribute, v);
            nqa.getNested().add(qa);
        }
    }

    private QueryAttribute buildQueryAttribute(Attribute attribute, Object value) {
        if (Record.class.isInstance(value)) {
            Record r = (Record)value;
            Type type = r.getType();
            Long id = r.getId();
            NestedQueryAttribute nqa = new NestedQueryAttribute((NamedAttributeHolder)type, attribute);
            if (id != null) {
                TypeTable tt = this.engine.getTableRegistry().getTypeTableByType(type);
                Attribute primaryKeyAttribute = tt.getPrimaryKeyColumn().getAttribute();
                SimpleQueryAttribute sqa = new SimpleQueryAttribute((Object)id, primaryKeyAttribute);
                nqa.getNested().add(sqa);
            }
            this.appendNestedAttributesToQuery(r, nqa);
            return nqa;
        }
        SimpleQueryAttribute qa = new SimpleQueryAttribute(value, attribute);
        return qa;
    }

    public QueryByExample pagination(Pagination p) {
        Long s;
        Long o = p.getOffset();
        if (o != null) {
            this.select.offset(o);
        }
        if ((s = p.getSize()) != null) {
            this.select.limit(s);
        }
        return this;
    }

    public List<QueryAttribute> getQueryAttributes() {
        ArrayList<QueryAttribute> l = new ArrayList<QueryAttribute>();
        l.addAll(this.rootQueryAttributes);
        l.addAll(this.queryAttributes);
        return l;
    }

    public Record single() {
        if (this.loadingIterator == null) {
            this.lazy();
        }
        this.appendQueryAttributes(this.loadingIterator);
        Transaction tx = this.engine.getQueryRunner().createTransaction();
        ObjectReference ref = tx.getQueryRunner().single(this.queryContext.build(this.recordContext));
        tx.commit();
        return (Record)ref.get();
    }

    public List<Record> all() {
        if (this.loadingIterator == null) {
            this.lazy();
        }
        this.appendQueryAttributes(this.loadingIterator);
        this.appendSorting(this.loadingIterator);
        Transaction tx = this.engine.getQueryRunner().createTransaction();
        ObjectReference ref = tx.getQueryRunner().list(this.queryContext.build(this.recordContext));
        tx.commit();
        return (List)ref.get();
    }

    public long count() {
        if (this.loadingIterator == null) {
            this.lazy();
        }
        this.select.count();
        this.appendQueryAttributes(this.loadingIterator);
        Transaction tx = this.engine.getQueryRunner().createTransaction();
        ObjectReference ref = tx.getQueryRunner().number(this.queryContext.build(this.recordContext));
        tx.commit();
        Long number = (Long)ref.get();
        if (number == null) {
            return 0L;
        }
        return number;
    }

    private void appendQueryAttributes(MappingBindingsProvider mbp) {
        if (this.queryAttributes.isEmpty() && this.rootQueryAttributes.isEmpty()) {
            return;
        }
        if (this.where == null) {
            this.where = this.select.where();
        }
        final ExpressionProducer producer = new ExpressionProducer(){
            private Expression exp = null;

            @Override
            public Expression produce() {
                this.exp = this.exp == null ? QueryByExampleImpl.this.where.expression() : this.exp.and();
                return this.exp;
            }
        };
        if (!this.rootQueryAttributes.isEmpty()) {
            for (QueryAttribute queryAttribute : this.rootQueryAttributes) {
                this.appendQueryAttribute(queryAttribute, mbp.getRootMappingBinding(), producer);
            }
        }
        if (!this.queryAttributes.isEmpty()) {
            final ExpressionProducer bindingRootProducer = new ExpressionProducer(){
                private WrapperExpression wrap;

                @Override
                public Expression produce() {
                    this.wrap = this.wrap == null ? producer.produce().wrap() : this.wrap.or().wrap();
                    return this.wrap.wrapped();
                }
            };
            for (MappingBinding mappingBinding : mbp.getMappingBindings()) {
                ExpressionProducer bindingBasedProducer = new ExpressionProducer(){
                    private Expression exp = null;

                    @Override
                    public Expression produce() {
                        this.exp = this.exp == null ? bindingRootProducer.produce() : this.exp.and();
                        return this.exp;
                    }
                };
                AliasBinding pkAlias = mappingBinding.getPrimaryKeyAlias();
                String tbAlias = mappingBinding.getTableAlias();
                bindingBasedProducer.produce().criteria().field(tbAlias + "." + pkAlias.getAttributeColumn().getColumnName()).isNotNull();
                for (QueryAttribute queryAttribute : this.queryAttributes) {
                    this.appendQueryAttribute(queryAttribute, mappingBinding, bindingBasedProducer);
                }
            }
        }
    }

    private void appendQueryAttribute(QueryAttribute queryAttribute, MappingBinding mappingBinding, ExpressionProducer expressionProducer) {
        if (SimpleQueryAttribute.class.isInstance(queryAttribute)) {
            this.appendSimpleQueryAttribute((SimpleQueryAttribute)queryAttribute, mappingBinding, expressionProducer);
        } else if (NestedQueryAttribute.class.isInstance(queryAttribute)) {
            List sbList;
            NestedQueryAttribute nqa = (NestedQueryAttribute)queryAttribute;
            Attribute att = nqa.getAttribute();
            Map sb = mappingBinding.getSubBindings();
            if (sb != null && (sbList = (List)sb.get(att.getName())) != null) {
                for (MappingBinding subBinding : sbList) {
                    if (subBinding.getHolder() != nqa.getHolder()) continue;
                    this.appendNestedQueryAttribute(nqa, subBinding, expressionProducer);
                    return;
                }
            }
        }
    }

    private void appendSimpleQueryAttribute(SimpleQueryAttribute queryAttribute, MappingBinding mappingBinding, ExpressionProducer expressionProducer) {
        AliasBinding aliasBinding;
        List aliases = mappingBinding.getAliases();
        if (aliases != null) {
            for (AliasBinding aliasBinding2 : aliases) {
                Attribute att = queryAttribute.getAttribute();
                Object val = queryAttribute.getValue();
                if (aliasBinding2.getAttribute() != att) continue;
                String field = mappingBinding.getTableAlias() + "." + aliasBinding2.getAttributeColumn().getColumnName();
                Expression exp = expressionProducer.produce();
                if (val != null) {
                    exp.criteria().field(field).equal().value((ValueProvider)this.createPreparedStatementValueProvider(aliasBinding2.getAttribute(), val));
                } else {
                    exp.criteria().field(field).isNull();
                }
                return;
            }
        }
        if ((aliasBinding = mappingBinding.getPrimaryKeyAlias()).getAttribute() == queryAttribute.getAttribute()) {
            String field = mappingBinding.getTableAlias() + "." + aliasBinding.getAttributeColumn().getColumnName();
            Expression exp = expressionProducer.produce();
            exp.criteria().field(field).equal().value((ValueProvider)this.createPreparedStatementValueProvider(aliasBinding.getAttribute(), queryAttribute.getValue()));
        }
    }

    private PreparedStatementValueProvider createPreparedStatementValueProvider(final Attribute attribute, final Object rawValue) {
        return new PreparedStatementValueProvider(){

            public Object get() {
                return rawValue;
            }

            public void set(int index, PreparedStatement ps) throws SQLException {
                AttributeMediator<Attribute> mediator = QueryByExampleImpl.this.engine.getMediatorRegistry().getMediatorForAttribute(attribute);
                mediator.setRawParameterInPreparedStatement(index, ps, attribute, this.get());
            }
        };
    }

    private void appendNestedQueryAttribute(NestedQueryAttribute queryAttribute, MappingBinding mappingBinding, ExpressionProducer expressionProducer) {
        List nested = queryAttribute.getNested();
        for (QueryAttribute nestedQueryAttribute : nested) {
            this.appendQueryAttribute(nestedQueryAttribute, mappingBinding, expressionProducer);
        }
    }

    public QueryByExample orderBy(String attributeName) {
        this.sortAttribute = this.assertAttributeIsKnown(attributeName);
        return this;
    }

    public QueryByExample asc() {
        this.sortDirection = "ASC";
        return this;
    }

    public QueryByExample desc() {
        this.sortDirection = "DESC";
        return this;
    }

    private void appendSorting(MappingBindingsProvider mbp) {
        if (this.sortDirection == null) {
            this.asc();
        }
        OrderBy orderBy = this.select.orderBy();
        if (this.sortAttribute != null) {
            MappingBinding rootMappingBinding = mbp.getRootMappingBinding();
            List aliases = mbp.getRootMappingBinding().getAliases();
            if (aliases != null) {
                for (AliasBinding aliasBinding : aliases) {
                    if (aliasBinding.getAttribute() != this.sortAttribute) continue;
                    String alias = rootMappingBinding.getTableAlias() + "." + aliasBinding.getAttributeColumn().getColumnName();
                    orderBy.columnAlias(alias);
                }
            } else {
                List bindings = mbp.getMappingBindings();
                for (MappingBinding mappingBinding : bindings) {
                    List localAliases = mappingBinding.getAliases();
                    if (localAliases == null) continue;
                    for (AliasBinding aliasBinding : localAliases) {
                        if (aliasBinding.getAttribute() != this.sortAttribute) continue;
                        String alias = mappingBinding.getTableAlias() + "." + aliasBinding.getAttributeColumn().getColumnName();
                        orderBy.columnAlias(alias);
                    }
                }
            }
            orderBy.direction(this.sortDirection);
        } else {
            MappingBinding rootMappingBinding = mbp.getRootMappingBinding();
            String pkColumnName = rootMappingBinding.getPrimaryKeyAlias().getAttributeColumn().getColumnName();
            orderBy.columnAlias(rootMappingBinding.getTableAlias() + "." + pkColumnName);
        }
        orderBy.direction(this.sortDirection);
    }

    private void addQueriedAttributePaths(Set<String> attributePaths, List<QueryAttribute> queryAttributes, String prefix) {
        if (queryAttributes == null || queryAttributes.isEmpty()) {
            return;
        }
        for (QueryAttribute queryAttribute : queryAttributes) {
            if (NestedQueryAttribute.class.isInstance(queryAttribute)) {
                List nested = ((NestedQueryAttribute)queryAttribute).getNested();
                String currentPath = prefix + queryAttribute.getAttribute().getName();
                attributePaths.add(currentPath);
                this.addQueriedAttributePaths(attributePaths, nested, currentPath + ".");
                continue;
            }
            if (!SimpleQueryAttribute.class.isInstance(queryAttribute)) continue;
            attributePaths.add(prefix + queryAttribute.getAttribute().getName());
        }
    }
}

