/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bndly.schema.api.AliasBinding;
import org.bndly.schema.api.MappingBinding;
import org.bndly.schema.api.MappingBindingsProvider;
import org.bndly.schema.api.PreparedStatementArgumentSetter;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.db.AttributeColumn;
import org.bndly.schema.api.db.Table;
import org.bndly.schema.api.db.TypeTable;
import org.bndly.schema.api.mapper.RowMapper;
import org.bndly.schema.api.query.Delete;
import org.bndly.schema.api.query.Insert;
import org.bndly.schema.api.query.QueryContext;
import org.bndly.schema.api.query.QueryFragmentRenderer;
import org.bndly.schema.api.query.QueryRenderContext;
import org.bndly.schema.api.query.Select;
import org.bndly.schema.api.query.Update;
import org.bndly.schema.api.services.Accessor;
import org.bndly.schema.api.services.TableRegistry;
import org.bndly.schema.impl.AliasedRecordRowMapper;
import org.bndly.schema.impl.ConfigurableMappingBindingsProvider;
import org.bndly.schema.impl.MediatorRegistryImpl;
import org.bndly.schema.impl.SingleTableMappingBindingsProvider;
import org.bndly.schema.impl.query.DeleteImpl;
import org.bndly.schema.impl.query.InsertImpl;
import org.bndly.schema.impl.query.QueryImpl;
import org.bndly.schema.impl.query.SelectImpl;
import org.bndly.schema.impl.query.UpdateImpl;
import org.bndly.schema.vendor.VendorConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryContextImpl
implements QueryContext {
    private static final Logger LOG = LoggerFactory.getLogger(QueryContextImpl.class);
    private final Accessor accessor;
    private final TableRegistry tableRegistry;
    private final List<String> usedTableNames = new ArrayList<String>();
    private final Map<String, Table> tablesByAlias = new HashMap<String, Table>();
    private final VendorConfiguration vendorConfiguration;
    private QueryFragmentRenderer command;
    private final MediatorRegistryImpl mediatorRegistry;
    private MappingBindingsProvider externalMappingBindingsProvider;
    private final ConfigurableMappingBindingsProvider configurableMappingBindingsProvider = new ConfigurableMappingBindingsProvider();

    public QueryContextImpl(TableRegistry tableRegistry, MediatorRegistryImpl mediatorRegistry, Accessor accessor, VendorConfiguration vendorConfiguration) {
        this.tableRegistry = tableRegistry;
        this.mediatorRegistry = mediatorRegistry;
        this.accessor = accessor;
        this.vendorConfiguration = vendorConfiguration;
    }

    public void setExternalMappingBindingsProvider(MappingBindingsProvider externalMappingBindingsProvider) {
        this.externalMappingBindingsProvider = externalMappingBindingsProvider;
    }

    public Select select() {
        SelectImpl select = new SelectImpl(this, this.vendorConfiguration);
        this.command = select;
        return select;
    }

    public Insert insert() {
        InsertImpl insert = new InsertImpl(this, this.vendorConfiguration);
        this.command = insert;
        return insert;
    }

    public Update update() {
        UpdateImpl update = new UpdateImpl(this, this.vendorConfiguration);
        this.command = update;
        return update;
    }

    public Delete delete() {
        DeleteImpl delete = new DeleteImpl(this, this.vendorConfiguration);
        this.command = delete;
        return delete;
    }

    public void useTable(String tableName, String alias) {
        if (alias != null) {
            Table table = this.tableRegistry.getTableByName(tableName);
            this.tablesByAlias.put(alias, table);
        }
        this.usedTableNames.add(tableName);
    }

    public void registerSelectAlias(String tableNameOrTableAlias, String fieldName, String alias) {
        Table table = this.tablesByAlias.get(tableNameOrTableAlias);
        if (table == null) {
            table = this.tableRegistry.getTableByName(tableNameOrTableAlias);
        }
        AttributeColumn column = null;
        List cols = table.getColumns();
        for (AttributeColumn attributeColumn : cols) {
            if (!attributeColumn.getColumnName().equals(fieldName)) continue;
            column = attributeColumn;
            break;
        }
        if (TypeTable.class.isInstance(table) && column != null) {
            TypeTable tt = (TypeTable)table;
            MappingBinding mappingBinding = this.configurableMappingBindingsProvider.getMappingBindingFor(tt.getType());
            if (mappingBinding != null) {
                AliasBinding aliasBinding = new AliasBinding(alias, column, tableNameOrTableAlias);
                mappingBinding.addAlias(aliasBinding);
            } else {
                throw new IllegalStateException("creating a select alias before mapping binding for type exists.");
            }
        }
        boolean isPkFieldName = false;
        AttributeColumn pkCol = table.getPrimaryKeyColumn();
        if (pkCol != null) {
            isPkFieldName = pkCol.getColumnName().equals(fieldName);
        }
        if (isPkFieldName && TypeTable.class.isInstance(table)) {
            TypeTable tt = (TypeTable)table;
            AliasBinding pkAlias = new AliasBinding(alias, tt.getPrimaryKeyColumn(), tableNameOrTableAlias);
            MappingBinding mappingBinding = this.configurableMappingBindingsProvider.getMappingBindingFor(tt.getType());
            if (mappingBinding == null) {
                this.configurableMappingBindingsProvider.createMappingBinding(tt.getType(), pkAlias, tableNameOrTableAlias);
            }
        }
    }

    private QueryRenderContext buildNewQueryRenderContext() {
        return new QueryRenderContext(){
            final StringBuilder sb = new StringBuilder();
            final ArrayList<Object> args = new ArrayList();
            final ArrayList<PreparedStatementArgumentSetter> argumentSetters = new ArrayList();

            public StringBuilder getSql() {
                return this.sb;
            }

            public List<Object> getArgs() {
                return this.args;
            }

            public List<PreparedStatementArgumentSetter> getArgumentSetters() {
                return this.argumentSetters;
            }
        };
    }

    public QueryImpl build(RecordContext recordContext) {
        QueryRenderContext ctx = this.buildNewQueryRenderContext();
        this.command.renderQueryFragment(ctx);
        RowMapper<Record> mapper = this.buildMapper(recordContext);
        PreparedStatementArgumentSetter[] setters = new PreparedStatementArgumentSetter[ctx.getArgumentSetters().size()];
        ctx.getArgumentSetters().toArray(setters);
        boolean asUpdate = !Select.class.isInstance(this.command);
        QueryImpl query = new QueryImpl(ctx.getSql().toString(), ctx.getArgs().toArray(), mapper, setters, asUpdate);
        LOG.trace("query with sql: {}", (Object)query.getSql());
        return query;
    }

    private RowMapper<Record> buildMapper(RecordContext recordContext) {
        Table t;
        this.configurableMappingBindingsProvider.setParent(this.externalMappingBindingsProvider);
        TypeTable table = null;
        if (this.usedTableNames.size() == 1 && TypeTable.class.isInstance(t = this.tableRegistry.getTableByName(this.usedTableNames.get(0)))) {
            table = (TypeTable)t;
        }
        SingleTableMappingBindingsProvider st = new SingleTableMappingBindingsProvider();
        st.setTable(table);
        st.setParent(this.configurableMappingBindingsProvider);
        SingleTableMappingBindingsProvider mappingBindingsProvider = st;
        return new AliasedRecordRowMapper(mappingBindingsProvider, this.mediatorRegistry, this.accessor, recordContext);
    }
}

