/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bndly.schema.api.QueryBasedRecordListInitializer;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordAttributeIterator;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.RecordList;
import org.bndly.schema.api.RecordValue;
import org.bndly.schema.api.exception.SchemaException;
import org.bndly.schema.api.query.Query;
import org.bndly.schema.api.services.Accessor;
import org.bndly.schema.impl.RecordContextEntry;
import org.bndly.schema.impl.RecordContextImpl;
import org.bndly.schema.impl.RecordValueImpl;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.InverseAttribute;
import org.bndly.schema.model.NamedAttributeHolder;
import org.bndly.schema.model.NamedAttributeHolderAttribute;
import org.bndly.schema.model.SchemaUtil;
import org.bndly.schema.model.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordImpl
implements Record {
    private static final Logger LOG = LoggerFactory.getLogger(RecordImpl.class);
    private final Accessor accessor;
    private final Map<String, RecordValue> values = new HashMap<String, RecordValue>();
    private Map<String, Attribute> attributes;
    private Type type;
    private Long id;
    private boolean isReference;
    private boolean isDirty;
    private RecordContextEntry recordContextEntry;

    public RecordImpl(Accessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException("can't create a record without accessor object");
        }
        this.accessor = accessor;
    }

    public final RecordContextEntry getRecordContextEntry() {
        return this.recordContextEntry;
    }

    public final void setRecordContextEntry(RecordContextEntry recordContextEntry) {
        if (recordContextEntry == null) {
            throw new IllegalArgumentException("can't create a record without recordContextEntry object");
        }
        if (this.recordContextEntry != null) {
            throw new IllegalArgumentException("can't set another recordContextEntry object");
        }
        this.recordContextEntry = recordContextEntry;
    }

    public RecordContextImpl getContext() {
        if (this.recordContextEntry == null) {
            throw new IllegalStateException("created a record without setting the recordContextEntry");
        }
        return this.recordContextEntry.getRecordContext();
    }

    public final void dropAttribute(String attributeName) {
        this.dropAttribute(attributeName, true);
    }

    private void dropAttribute(String attributeName, boolean removeValue) {
        Attribute att = this.assertAttributeIsKnown(attributeName);
        RecordValue val = this.values.get(att.getName());
        if (val != null) {
            RecordList rl;
            Object realValue = val.getValue();
            if (Record.class.isInstance(realValue)) {
                RecordContextEntry entry = ((RecordImpl)realValue).getRecordContextEntry();
                List<RecordContext.RecordReference> refs = entry.getReferences();
                Iterator<RecordContext.RecordReference> iterator = refs.iterator();
                while (iterator.hasNext()) {
                    RecordContext.RecordReference ref = iterator.next();
                    if (ref.getReferencedBy() != this || ref.getReferencedAs() != att) continue;
                    iterator.remove();
                }
            } else if (RecordList.class.isInstance(realValue) && (rl = (RecordList)realValue).didInitialize()) {
                for (Record item : rl) {
                    if (!RecordImpl.class.isInstance(item)) continue;
                    RecordContextEntry entry = ((RecordImpl)item).getRecordContextEntry();
                    List<RecordContext.RecordReference> list = entry.getReferences();
                }
            }
            if (removeValue) {
                this.values.remove(att.getName());
            }
        }
    }

    public final void dropAttributes() {
        for (String attributeName : this.values.keySet()) {
            this.dropAttribute(attributeName, false);
        }
        this.values.clear();
    }

    public boolean isReference() {
        return this.isReference;
    }

    public void setIsReference(boolean isReference) {
        this.isReference = isReference;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final void setIsDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
        List tmp = SchemaUtil.collectAttributes((NamedAttributeHolder)type);
        this.attributes = new HashMap<String, Attribute>();
        for (Attribute attribute : tmp) {
            this.attributes.put(attribute.getName(), attribute);
        }
    }

    public final <E> E setAttributeValue(String attributeName, E value) {
        Attribute attribute;
        block7: {
            block6: {
                attribute = this.assertAttributeIsKnown(attributeName);
                this.dropAttribute(attributeName);
                if (!NamedAttributeHolderAttribute.class.isInstance(attribute)) break block6;
                NamedAttributeHolderAttribute naha = (NamedAttributeHolderAttribute)attribute;
                if (value == null) break block7;
                if (!Record.class.isInstance(value) && !Long.class.isInstance(value)) {
                    throw new IllegalArgumentException("can not set a named attribute holder attribute to values other than Long or Record.");
                }
                if (!Record.class.isInstance(value)) break block7;
                value = this.getContext().attach((Record)value);
                List<RecordContext.RecordReference> refs = ((RecordImpl)value).getRecordContextEntry().getReferences();
                refs.add(new RecordContextEntry.RecordReferenceImpl(this, attribute));
                break block7;
            }
            if (InverseAttribute.class.isInstance(attribute) && value != null) {
                if (!RecordList.class.isInstance(value)) {
                    throw new SchemaException("inverse attributes should be set as RecordList!");
                }
                RecordList rl = (RecordList)value;
                if (rl.getContext() != this.getContext()) {
                    throw new SchemaException("record list is from a different record context!");
                }
                Iterator iter = rl.iterator();
                NamedAttributeHolderAttribute attributeInChild = ((InverseAttribute)attribute).getReferencedAttribute();
                List<RecordContext.RecordReference> refs = this.getRecordContextEntry().getReferences();
                while (iter.hasNext()) {
                    Record next = (Record)iter.next();
                    refs.add(new RecordContextEntry.RecordReferenceImpl(next, (Attribute)attributeInChild));
                }
            }
        }
        this.values.put(attributeName, new RecordValueImpl(this, attribute, value));
        if (!attribute.isVirtual()) {
            this.setIsDirty(true);
        }
        return value;
    }

    public boolean isAttributePresent(String attributeName) {
        this.assertAttributeIsKnown(attributeName);
        return this.values.containsKey(attributeName);
    }

    public final <E> E getAttributeValue(String attributeName, Class<E> desiredType) {
        Object returnValue;
        Attribute att = this.assertAttributeIsKnown(attributeName);
        RecordValue v = this.values.get(attributeName);
        if (v == null) {
            if (InverseAttribute.class.isInstance(att)) {
                if (att.isVirtual()) {
                    returnValue = null;
                } else {
                    RecordList found = null;
                    if (this.id != null) {
                        final InverseAttribute ia = (InverseAttribute)InverseAttribute.class.cast(att);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("loading inverse attribute: " + ia.getName() + " in " + this.type.getName() + " for record " + this.id + " in instance " + this.hashCode());
                        }
                        String attName = ia.getReferencedAttributeName();
                        final RecordImpl parent = this;
                        QueryBasedRecordListInitializer initializer = new QueryBasedRecordListInitializer(this.accessor, "PICK " + ia.getReferencedAttributeHolder().getName() + " x IF x." + attName + ".id=? AND x." + attName + " TYPED ?", parent.getContext(), new Object[]{this.id, this.type.getName()}){

                            public Record onIterated(Record iteratedRecord) {
                                iteratedRecord.setAttributeValue(ia.getReferencedAttributeName(), (Object)parent);
                                return super.onIterated(iteratedRecord);
                            }
                        };
                        found = this.getContext().createList((RecordContext.RecordListInitializer)initializer, (Record)parent, ia);
                    }
                    this.setAttributeValue(attributeName, found);
                    returnValue = desiredType.cast(found);
                }
            } else {
                returnValue = null;
            }
        } else {
            Object raw = v.getValue();
            if (raw == null) {
                returnValue = null;
            } else if (NamedAttributeHolderAttribute.class.isInstance(att)) {
                if (Record.class.isInstance(raw)) {
                    Record rawRec = (Record)raw;
                    Long rId = rawRec.getId();
                    if (Long.class.isAssignableFrom(desiredType)) {
                        if (rId == null) {
                            LOG.debug("attribute {} in {} referenced a record with an id", (Object)attributeName, (Object)this);
                            return null;
                        }
                        long transformedId = this.accessor.readIdAsNamedAttributeHolder(((NamedAttributeHolderAttribute)att).getNamedAttributeHolder(), rawRec.getType(), rId.longValue(), (RecordContext)this.getContext());
                        returnValue = desiredType.cast(transformedId);
                    } else {
                        returnValue = Query.class.isAssignableFrom(desiredType) ? this.accessor.createIdAsNamedAttributeHolderQuery(((NamedAttributeHolderAttribute)att).getNamedAttributeHolder(), rawRec.getType(), rId.longValue(), (RecordContext)this.getContext()) : raw;
                    }
                } else if (Long.class.isInstance(raw)) {
                    if (Record.class.isAssignableFrom(desiredType)) {
                        Record rec = this.accessor.readById(((NamedAttributeHolderAttribute)att).getNamedAttributeHolder().getName(), ((Long)raw).longValue(), (RecordContext)this.getContext());
                        this.setAttributeValue(attributeName, rec);
                        returnValue = rec;
                    } else {
                        returnValue = desiredType.cast(raw);
                    }
                } else {
                    returnValue = raw;
                }
            } else {
                returnValue = desiredType.cast(raw);
            }
        }
        return (E)returnValue;
    }

    public boolean isAttributeDefined(String attributeName) {
        Attribute attribute = null;
        if (this.attributes != null) {
            attribute = this.attributes.get(attributeName);
        }
        return attribute != null;
    }

    private Attribute assertAttributeIsKnown(String attributeName) throws IllegalStateException {
        Attribute attribute = null;
        if (this.attributes != null) {
            attribute = this.attributes.get(attributeName);
        }
        if (attribute == null) {
            throw new IllegalStateException("unknown attribute " + attributeName + " for type " + this.type.getName());
        }
        return attribute;
    }

    public Object getAttributeValue(String attributeName) {
        return this.getAttributeValue(attributeName, Object.class);
    }

    public boolean isVirtualAttribute(String attributeName) {
        return this.assertAttributeIsKnown(attributeName).isVirtual();
    }

    public Attribute getAttributeDefinition(String attributeName) {
        return this.getAttributeDefinition(attributeName, Attribute.class);
    }

    public <E extends Attribute> E getAttributeDefinition(String attributeName, Class<E> definitionType) {
        Attribute att = this.assertAttributeIsKnown(attributeName);
        return (E)att;
    }

    public void iterateValues(RecordAttributeIterator listener) {
        for (Attribute attribute : this.attributes.values()) {
            listener.handleAttribute(attribute, (Record)this);
        }
    }

    public void iteratePresentValues(RecordAttributeIterator listener) {
        for (Attribute attribute : this.attributes.values()) {
            if (!this.isAttributePresent(attribute.getName())) continue;
            listener.handleAttribute(attribute, (Record)this);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Record: ").append(this.type.getName()).append("[");
        if (this.id == null) {
            sb.append("hash-").append(this.hashCode());
        } else {
            sb.append(this.id);
        }
        sb.append("]");
        if (this.isReference) {
            sb.append("[REF]");
        }
        String stringValue = sb.toString();
        return stringValue;
    }
}

