/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.bndly.schema.api.db.AttributeColumn;
import org.bndly.schema.api.db.JoinTable;
import org.bndly.schema.api.db.Table;
import org.bndly.schema.api.db.TypeTable;
import org.bndly.schema.api.exception.SchemaException;
import org.bndly.schema.api.services.TableRegistry;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.Mixin;
import org.bndly.schema.model.NamedAttributeHolder;
import org.bndly.schema.model.NamedAttributeHolderAttribute;

public final class TableHierarchyIterator {
    private TableHierarchyIterator() {
    }

    public static void iterateTypeHierarchyDown(NamedAttributeHolder attributeHolder, TableRegistry tableRegistry, IterationCallback callback) {
        TableHierarchyIterator.iterateTypeHierarchyDown(attributeHolder.getName(), tableRegistry, callback);
    }

    public static void iterateTypeHierarchyDown(String attributeHoldername, TableRegistry tableRegistry, IterationCallback callback) {
        TableHierarchyIterator.bootIterateTypeHierarchyDown(attributeHoldername, tableRegistry, false, callback);
    }

    public static void iterateTypeHierarchyDownAndFollowAttributes(String attributeHoldername, TableRegistry tableRegistry, IterationCallback callback) {
        TableHierarchyIterator.bootIterateTypeHierarchyDown(attributeHoldername, tableRegistry, true, callback);
    }

    private static void bootIterateTypeHierarchyDown(String attributeHoldername, TableRegistry tableRegistry, boolean followAttributes, IterationCallback callback) {
        Table table = TableHierarchyIterator.getIterationStartTable(attributeHoldername, tableRegistry);
        callback.onStart(table);
        TableHierarchyIterator.iterateTypeHierarchyDown(table, tableRegistry, followAttributes, new Stack<Attribute>(), new Stack<Attribute>(), callback);
        callback.onEnd(table);
    }

    public static String buildAttributePath(Attribute[] attributeStack) {
        StringBuilder sb = null;
        for (Attribute att : attributeStack) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append(".");
            }
            sb.append(att.getName());
        }
        return sb == null ? "" : sb.toString();
    }

    private static void iterateTypeHierarchyDown(Table table, TableRegistry tableRegistry, boolean followAttributes, Stack<Attribute> attributeStack, Stack<Attribute> domainAttributeStack, IterationCallback callback) {
        boolean drillDown;
        AttributeColumn primaryKeyColumn = table.getPrimaryKeyColumn();
        boolean isCycle = attributeStack.contains(primaryKeyColumn.getAttribute());
        if (isCycle) {
            Attribute[] dAttributeStack = TableHierarchyIterator.convertStackToArray(domainAttributeStack);
            IterationCommand result = callback.onCyclicColumn(primaryKeyColumn, table, true, TableHierarchyIterator.convertStackToArray(attributeStack), dAttributeStack);
            if (result == null) {
                throw new IllegalStateException("no command after cyclic column iteration");
            }
            drillDown = result == IterationCommand.CONTINUE;
        } else {
            drillDown = true;
        }
        if (drillDown) {
            Attribute[] attStackWithoutPK;
            Attribute[] attStackWithPK;
            attributeStack.push(primaryKeyColumn.getAttribute());
            if (TypeTable.class.isInstance(table)) {
                domainAttributeStack.push(primaryKeyColumn.getAttribute());
                attStackWithPK = TableHierarchyIterator.convertStackToArray(domainAttributeStack);
                domainAttributeStack.pop();
                attStackWithoutPK = TableHierarchyIterator.convertStackToArray(domainAttributeStack);
            } else {
                attStackWithPK = attStackWithoutPK = TableHierarchyIterator.convertStackToArray(domainAttributeStack);
            }
            if (JoinTable.class.isInstance(table)) {
                JoinTable joinTable = (JoinTable)table;
                callback.onJoinTable(joinTable, attStackWithPK, attStackWithoutPK);
                callback.onColumn(primaryKeyColumn, table, true, attStackWithPK, attStackWithoutPK);
                callback.afterColumn(primaryKeyColumn, table, true, attStackWithPK, attStackWithoutPK);
                List columns = joinTable.getColumns();
                if (columns != null) {
                    for (AttributeColumn column : columns) {
                        callback.onColumn(column, table, false, attStackWithPK, attStackWithoutPK);
                        NamedAttributeHolderAttribute att = (NamedAttributeHolderAttribute)column.getAttribute();
                        Table joinedTable = TableHierarchyIterator.getIterationStartTable(att.getNamedAttributeHolder(), tableRegistry);
                        if (joinedTable == joinTable) {
                            joinedTable = tableRegistry.getTypeTableByType(att.getNamedAttributeHolder().getName());
                        }
                        callback.onJoinedTable(joinedTable, joinTable, column);
                        TableHierarchyIterator.iterateTypeHierarchyDown(joinedTable, tableRegistry, followAttributes, attributeStack, domainAttributeStack, callback);
                        callback.afterJoinedTable(joinedTable, joinTable, column);
                        callback.afterColumn(column, table, false, attStackWithPK, attStackWithoutPK);
                    }
                }
                callback.afterJoinTable(joinTable, attStackWithPK, attStackWithoutPK);
            } else if (TypeTable.class.isInstance(table)) {
                TypeTable typeTable = (TypeTable)table;
                callback.onTypeTable(typeTable, attStackWithPK, attStackWithoutPK);
                callback.onColumn(primaryKeyColumn, table, true, attStackWithPK, attStackWithoutPK);
                callback.afterColumn(primaryKeyColumn, table, true, attStackWithPK, attStackWithoutPK);
                List cols = typeTable.getColumns();
                if (cols != null) {
                    for (AttributeColumn col : cols) {
                        NamedAttributeHolder namedAttributeHolder;
                        Attribute attribute = col.getAttribute();
                        attributeStack.push(attribute);
                        domainAttributeStack.push(attribute);
                        Attribute[] attStackWithoutPKAndWithCurrentAttribute = TableHierarchyIterator.convertStackToArray(domainAttributeStack);
                        callback.onColumn(col, table, false, attStackWithPK, attStackWithoutPKAndWithCurrentAttribute);
                        if (followAttributes && !attribute.isVirtual() && NamedAttributeHolderAttribute.class.isInstance(attribute) && !(namedAttributeHolder = ((NamedAttributeHolderAttribute)attribute).getNamedAttributeHolder()).isVirtual()) {
                            boolean isUnusedMixin = false;
                            if (Mixin.class.isInstance(namedAttributeHolder)) {
                                List mixedInto = ((Mixin)namedAttributeHolder).getMixedInto();
                                boolean bl = isUnusedMixin = mixedInto == null || mixedInto.isEmpty();
                            }
                            if (!isUnusedMixin) {
                                Table foreignTable = TableHierarchyIterator.getIterationStartTable(namedAttributeHolder, tableRegistry);
                                callback.onAttributeForeignTable(foreignTable, col, table, false, attStackWithPK, attStackWithoutPKAndWithCurrentAttribute);
                                TableHierarchyIterator.iterateTypeHierarchyDown(foreignTable, tableRegistry, followAttributes, attributeStack, domainAttributeStack, callback);
                                callback.afterAttributeForeignTable(foreignTable, col, table, false, attStackWithPK, attStackWithoutPKAndWithCurrentAttribute);
                            }
                        }
                        callback.afterColumn(col, table, false, attStackWithPK, attStackWithoutPKAndWithCurrentAttribute);
                        domainAttributeStack.pop();
                        attributeStack.pop();
                    }
                }
                callback.afterTypeTable(typeTable, attStackWithPK, attStackWithoutPK);
            }
            attributeStack.pop();
        }
    }

    private static Table getIterationStartTable(NamedAttributeHolder namedAttributeHolder, TableRegistry tableRegistry) {
        return TableHierarchyIterator.getIterationStartTable(namedAttributeHolder.getName(), tableRegistry);
    }

    private static Table getIterationStartTable(String attributeHoldername, TableRegistry tableRegistry) {
        JoinTable table = tableRegistry.getJoinTableByNamedAttributeHolder(attributeHoldername);
        if (table == null) {
            table = tableRegistry.getTypeTableByType(attributeHoldername);
        }
        if (table == null) {
            throw new SchemaException("no table found for " + attributeHoldername);
        }
        return table;
    }

    private static Attribute[] convertStackToArray(Stack<Attribute> attributeStack) {
        Attribute[] arr = new Attribute[attributeStack.size()];
        int i = 0;
        Iterator iterator = attributeStack.iterator();
        while (iterator.hasNext()) {
            Attribute att;
            arr[i] = att = (Attribute)iterator.next();
            ++i;
        }
        return arr;
    }

    public static class NoOpIterationCallback
    implements IterationCallback {
        @Override
        public void onStart(Table table) {
        }

        @Override
        public void onEnd(Table table) {
        }

        @Override
        public void onAttributeForeignTable(Table foreignTable, AttributeColumn column, Table table, boolean isPrimaryKeyColumn, Attribute[] attributeStack, Attribute[] domainAttributeStack) {
        }

        @Override
        public void afterAttributeForeignTable(Table foreignTable, AttributeColumn column, Table table, boolean isPrimaryKeyColumn, Attribute[] attributeStack, Attribute[] domainAttributeStack) {
        }

        @Override
        public void onColumn(AttributeColumn column, Table table, boolean isPrimaryKeyColumn, Attribute[] attributeStack, Attribute[] domainAttributeStack) {
        }

        @Override
        public void afterColumn(AttributeColumn column, Table table, boolean isPrimaryKeyColumn, Attribute[] attributeStack, Attribute[] domainAttributeStack) {
        }

        @Override
        public IterationCommand onCyclicColumn(AttributeColumn column, Table table, boolean isPrimaryKeyColumn, Attribute[] attributeStack, Attribute[] domainAttributeStack) {
            return IterationCommand.SKIP;
        }

        @Override
        public void onJoinedTable(Table joinedTable, JoinTable joinTable, AttributeColumn attributeColumn) {
        }

        @Override
        public void afterJoinedTable(Table joinedTable, JoinTable joinTable, AttributeColumn attributeColumn) {
        }

        @Override
        public void onTypeTable(TypeTable typeTable, Attribute[] attributeStack, Attribute[] domainAttributeStack) {
        }

        @Override
        public void afterTypeTable(TypeTable typeTable, Attribute[] attributeStack, Attribute[] domainAttributeStack) {
        }

        @Override
        public void onJoinTable(JoinTable joinTable, Attribute[] attributeStack, Attribute[] domainAttributeStack) {
        }

        @Override
        public void afterJoinTable(JoinTable joinTable, Attribute[] attributeStack, Attribute[] domainAttributeStack) {
        }
    }

    public static interface IterationCallback {
        public void onStart(Table var1);

        public void onEnd(Table var1);

        public void onColumn(AttributeColumn var1, Table var2, boolean var3, Attribute[] var4, Attribute[] var5);

        public void afterColumn(AttributeColumn var1, Table var2, boolean var3, Attribute[] var4, Attribute[] var5);

        public void onAttributeForeignTable(Table var1, AttributeColumn var2, Table var3, boolean var4, Attribute[] var5, Attribute[] var6);

        public void afterAttributeForeignTable(Table var1, AttributeColumn var2, Table var3, boolean var4, Attribute[] var5, Attribute[] var6);

        public IterationCommand onCyclicColumn(AttributeColumn var1, Table var2, boolean var3, Attribute[] var4, Attribute[] var5);

        public void onJoinedTable(Table var1, JoinTable var2, AttributeColumn var3);

        public void afterJoinedTable(Table var1, JoinTable var2, AttributeColumn var3);

        public void onTypeTable(TypeTable var1, Attribute[] var2, Attribute[] var3);

        public void afterTypeTable(TypeTable var1, Attribute[] var2, Attribute[] var3);

        public void onJoinTable(JoinTable var1, Attribute[] var2, Attribute[] var3);

        public void afterJoinTable(JoinTable var1, Attribute[] var2, Attribute[] var3);
    }

    public static enum IterationCommand {
        CONTINUE,
        SKIP,
        ABORT;

    }
}

