/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.util.List;
import org.bndly.schema.api.db.JoinTable;
import org.bndly.schema.api.db.Table;
import org.bndly.schema.api.db.TypeTable;

public final class TableIterator {
    private TableIterator() {
    }

    public static void iterate(JoinTable table, Listener listener) {
        List joinedTables = table.getJoinedTables();
        for (Table joinedTable : joinedTables) {
            String localJoinedColumn;
            if (TypeTable.class.isInstance(joinedTable)) {
                TypeTable tt = (TypeTable)TypeTable.class.cast(joinedTable);
                localJoinedColumn = tt.getType().getName() + "_id";
                listener.join(table, tt, localJoinedColumn);
                continue;
            }
            if (JoinTable.class.isInstance(joinedTable)) {
                JoinTable jt = (JoinTable)JoinTable.class.cast(joinedTable);
                localJoinedColumn = jt.getNamedAttributeHolder().getName() + "_id";
                listener.nestedJoinPush(table, jt, localJoinedColumn);
                TableIterator.iterate(jt, listener);
                listener.nestedJoinPop(table, jt, localJoinedColumn);
                continue;
            }
            throw new IllegalStateException("unsupported joined table.");
        }
    }

    public static interface Listener {
        public void join(JoinTable var1, TypeTable var2, String var3);

        public void nestedJoinPush(JoinTable var1, JoinTable var2, String var3);

        public void nestedJoinPop(JoinTable var1, JoinTable var2, String var3);
    }
}

