/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.bndly.schema.api.exception.SchemaException;
import org.bndly.schema.api.services.Engine;
import org.bndly.schema.api.tx.Template;
import org.bndly.schema.api.tx.TransactionCallback;
import org.bndly.schema.api.tx.TransactionStatus;
import org.bndly.schema.api.tx.TransactionTemplate;
import org.bndly.schema.impl.ConnectionCallback;
import org.bndly.schema.impl.TemplateImpl;
import org.bndly.schema.vendor.VendorConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionTemplateImpl
implements TransactionTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionTemplateImpl.class);
    private DataSource dataSource;
    private boolean closeConnectionAfterUsage;
    private final ThreadLocal<Boolean> synchronizationLocale = new ThreadLocal();
    private final VendorConfiguration vendorConfiguration;
    private final Engine engine;

    public TransactionTemplateImpl(VendorConfiguration vendorConfiguration, Engine engine) {
        this.vendorConfiguration = vendorConfiguration;
        this.engine = engine;
    }

    protected Connection getConnection() throws SchemaException {
        if (this.dataSource == null) {
            throw new SchemaException("can not get connection, when no datasource is present.");
        }
        try {
            Connection c = this.dataSource.getConnection();
            return c;
        }
        catch (SQLException e) {
            throw this.vendorConfiguration.getErrorCodeMapper().map("could not obtain connection: " + e.getMessage(), e, this.engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> E runOnConnection(ConnectionCallback<E> connectionCallback) {
        Connection toClose = null;
        try {
            if (this.synchronizationLocale.get() != null && this.synchronizationLocale.get().booleanValue()) {
                throw new IllegalStateException("running on connection in a recursive pattern.");
            }
            this.synchronizationLocale.set(true);
            Connection connection = this.getConnection();
            if (this.closeConnectionAfterUsage) {
                toClose = connection;
            }
            E e = connectionCallback.doWithConnection(connection);
            return e;
        }
        finally {
            if (toClose != null) {
                try {
                    toClose.close();
                }
                catch (SQLException ex) {
                    LOG.error("failed to close connection: " + ex.getMessage(), (Throwable)ex);
                }
            }
            this.synchronizationLocale.remove();
        }
    }

    public <E> E doInTransaction(final TransactionCallback<E> transactionCallback) {
        return this.runOnConnection(new ConnectionCallback<E>(){

            @Override
            public <E> E doWithConnection(final Connection connection) {
                boolean shouldEnableAutoCommit = true;
                try {
                    LOG.debug("disabling auto commit");
                    shouldEnableAutoCommit = connection.getAutoCommit();
                    if (shouldEnableAutoCommit) {
                        connection.setAutoCommit(false);
                    }
                }
                catch (SQLException e) {
                    throw TransactionTemplateImpl.this.vendorConfiguration.getErrorCodeMapper().map("could not disable auto commit on connection", e, TransactionTemplateImpl.this.engine);
                }
                TransactionStatus tx = new TransactionStatus(){
                    private boolean rollbackOnly = false;

                    public boolean isRollbackOnly() {
                        return this.rollbackOnly;
                    }

                    public Connection getConnection() {
                        return connection;
                    }

                    public void setRollbackOnly() {
                        this.rollbackOnly = true;
                        try {
                            connection.rollback();
                        }
                        catch (SQLException ex) {
                            throw TransactionTemplateImpl.this.vendorConfiguration.getErrorCodeMapper().map(ex, TransactionTemplateImpl.this.engine);
                        }
                    }
                };
                TemplateImpl template = new TemplateImpl(TransactionTemplateImpl.this.vendorConfiguration, TransactionTemplateImpl.this.engine, connection);
                Object result = transactionCallback.doInTransaction(tx, (Template)template);
                try {
                    if (shouldEnableAutoCommit) {
                        if (connection.getAutoCommit()) {
                            throw new SchemaException("can not commit auto commited connection");
                        }
                        LOG.debug("commiting");
                        connection.commit();
                    }
                }
                catch (SQLException ex) {
                    throw TransactionTemplateImpl.this.vendorConfiguration.getErrorCodeMapper().map(ex, TransactionTemplateImpl.this.engine);
                }
                finally {
                    try {
                        if (shouldEnableAutoCommit) {
                            LOG.debug("enabling auto commit");
                            connection.setAutoCommit(true);
                        }
                    }
                    catch (SQLException ex) {
                        throw TransactionTemplateImpl.this.vendorConfiguration.getErrorCodeMapper().map("failed to re-enable connection auto-commit", ex, TransactionTemplateImpl.this.engine);
                    }
                }
                return (E)result;
            }
        });
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public final void setCloseConnectionAfterUsage(boolean closeConnectionAfterUsage) {
        this.closeConnectionAfterUsage = closeConnectionAfterUsage;
    }
}

