/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.events;

import java.util.ArrayList;
import java.util.List;
import org.bndly.schema.api.CommitHandler;
import org.bndly.schema.api.Logic;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.Transaction;
import org.bndly.schema.api.listener.DeleteListener;
import org.bndly.schema.api.listener.MergeListener;
import org.bndly.schema.api.listener.PersistListener;
import org.bndly.schema.impl.EngineImpl;

public class PersistenceEventBuilder {
    private final EngineImpl engine;
    private List<Logic> logic;

    public PersistenceEventBuilder(EngineImpl engine) {
        if (engine == null) {
            throw new IllegalArgumentException("engine is not allowed to be null");
        }
        this.engine = engine;
    }

    public void scheduleMergeEvent(final Record record) {
        if (this.logic == null) {
            this.logic = new ArrayList<Logic>();
        }
        this.logic.add(new Logic(){

            public void execute(Transaction transaction) {
                List<MergeListener> listeners = PersistenceEventBuilder.this.engine.getListeners(MergeListener.class, record.getType().getName());
                for (MergeListener listener : listeners) {
                    listener.onMerge(record);
                }
            }
        });
    }

    public void schedulePersistEvent(final Record record) {
        if (this.logic == null) {
            this.logic = new ArrayList<Logic>();
        }
        this.logic.add(new Logic(){

            public void execute(Transaction transaction) {
                List<PersistListener> listeners = PersistenceEventBuilder.this.engine.getListeners(PersistListener.class, record.getType().getName());
                for (PersistListener listener : listeners) {
                    listener.onPersist(record);
                }
            }
        });
    }

    public void scheduleDeleteEvent(final Record record) {
        if (this.logic == null) {
            this.logic = new ArrayList<Logic>();
        }
        this.logic.add(new Logic(){

            public void execute(Transaction transaction) {
                List<DeleteListener> listeners = PersistenceEventBuilder.this.engine.getListeners(DeleteListener.class, record.getType().getName());
                for (DeleteListener listener : listeners) {
                    listener.onDelete(record);
                }
            }
        });
    }

    public boolean hasEventsScheduled() {
        return this.logic != null;
    }

    public void attachToTransaction(Transaction transaction) {
        transaction.afterCommit(new CommitHandler(){

            public void didCommit(Transaction transaction) {
                for (Logic l : PersistenceEventBuilder.this.logic) {
                    l.execute(transaction);
                }
            }
        });
    }
}

