/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.factory;

import org.bndly.common.osgi.util.ServiceRegistrationBuilder;
import org.bndly.schema.vendor.VendorConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.osgi.util.tracker.ServiceTracker;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(factory=true, ocd=Configuration.class)
public class EngineConfiguration {
    private ServiceTracker<VendorConfiguration, VendorConfiguration> tracker;
    private ServiceRegistration<EngineConfiguration> reg;
    private String schema;
    private String datasource;
    private String dialect;
    private String connection;
    private boolean validateOnly;
    private boolean ignoreValidationErrors;
    private VendorConfiguration vendorConfig;

    @Activate
    public void activate(Configuration configuration, final BundleContext bundleContext) throws InvalidSyntaxException {
        this.schema = configuration.schema();
        this.datasource = configuration.datasource();
        this.dialect = configuration.dialect();
        this.connection = configuration.connection();
        this.validateOnly = configuration.validateOnly();
        this.tracker = new ServiceTracker<VendorConfiguration, VendorConfiguration>(bundleContext, bundleContext.createFilter("(&(objectClass=" + VendorConfiguration.class.getName() + ")(name=" + this.dialect + "))"), null){

            public VendorConfiguration addingService(ServiceReference<VendorConfiguration> reference) {
                VendorConfiguration tmp = (VendorConfiguration)super.addingService(reference);
                EngineConfiguration.this.register(tmp, bundleContext);
                return tmp;
            }

            public void removedService(ServiceReference<VendorConfiguration> reference, VendorConfiguration service) {
                EngineConfiguration.this.unregister(service);
            }
        };
        this.tracker.open();
    }

    @Deactivate
    public void deactivate() {
        this.tracker.close();
    }

    private void unregister(VendorConfiguration tmp) {
        if (this.reg != null && this.vendorConfig == tmp) {
            this.reg.unregister();
            this.reg = null;
            this.vendorConfig = null;
        }
    }

    private void register(VendorConfiguration tmp, BundleContext context) {
        if (this.reg == null) {
            this.vendorConfig = tmp;
            this.reg = ServiceRegistrationBuilder.newInstance(EngineConfiguration.class, (Object)this).property("schema", (Object)this.schema).property("datasource", (Object)this.datasource).property("dialect", (Object)this.dialect).property("connection", (Object)this.connection).property("validateOnly", (Object)this.validateOnly).register(context);
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public String getDialect() {
        return this.dialect;
    }

    public VendorConfiguration getVendorConfig() {
        return this.vendorConfig;
    }

    public String getConnection() {
        return this.connection;
    }

    public boolean isValidateOnly() {
        return this.validateOnly;
    }

    public boolean isValidationErrorIgnored() {
        return this.ignoreValidationErrors;
    }

    @ObjectClassDefinition(name="Schema Engine Configuration", description="The schema engine configuration binds a schema to a datasource, where the schema should be deployed.")
    public static @interface Configuration {
        @AttributeDefinition(name="Schema name", description="The technical name of the schema. This value should only contain [a-z] symbols.")
        public String schema() default "myschema";

        @AttributeDefinition(name="Datasource name", description="The name of the datasource to use for the schema deployment.")
        public String datasource() default "mydatasource";

        @AttributeDefinition(name="Dialect", description="The dialect to use for the datasource. The built in defaults are: mysql, h2, postgres and mariadb.")
        public String dialect() default "mysql";

        @AttributeDefinition(name="Connection", description="The type of connections handling", options={@Option(label="Pooled connection", value="pooled"), @Option(label="Single connection", value="single")})
        public String connection() default "pooled";

        @AttributeDefinition(name="Schema validation only", description="If checked, the schema will only be validated")
        public boolean validateOnly() default false;

        @AttributeDefinition(name="Ignore schema validation errors", description="If checked, the validation of the schema will not throw exceptions.")
        public boolean ignoreValidationErrors() default false;
    }
}

