/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bndly.common.osgi.util.DictionaryAdapter;
import org.bndly.schema.api.listener.DeleteListener;
import org.bndly.schema.api.listener.MergeListener;
import org.bndly.schema.api.listener.PersistListener;
import org.bndly.schema.api.listener.PreDeleteListener;
import org.bndly.schema.api.listener.PreMergeListener;
import org.bndly.schema.api.listener.PrePersistListener;
import org.bndly.schema.api.listener.SchemaDeploymentListener;
import org.bndly.schema.api.listener.TransactionListener;
import org.bndly.schema.api.services.Engine;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ListenerTracker
extends ServiceTracker {
    private static final String COND_LISTENER_DEPLOYMENT = "(objectClass=" + SchemaDeploymentListener.class.getName() + ")";
    private static final String COND_LISTENER_TRANSACTION = "(objectClass=" + TransactionListener.class.getName() + ")";
    private static final String COND_LISTENER_PRE_MERGE = "(objectClass=" + PreMergeListener.class.getName() + ")";
    private static final String COND_LISTENER_MERGE = "(objectClass=" + MergeListener.class.getName() + ")";
    private static final String COND_LISTENER_PRE_PERSIST = "(objectClass=" + PrePersistListener.class.getName() + ")";
    private static final String COND_LISTENER_PERSIST = "(objectClass=" + PersistListener.class.getName() + ")";
    private static final String COND_LISTENER_PRE_DELETE = "(objectClass=" + PreDeleteListener.class.getName() + ")";
    private static final String COND_LISTENER_DELETE = "(objectClass=" + DeleteListener.class.getName() + ")";
    private final Engine engine;
    private final List<Object> listeners = new ArrayList<Object>();
    private final Lock lock = new ReentrantLock();

    public ListenerTracker(BundleContext bundleContext, Engine engine, String schemaName) throws InvalidSyntaxException {
        super(bundleContext, bundleContext.createFilter("(&(|" + COND_LISTENER_DEPLOYMENT + COND_LISTENER_TRANSACTION + COND_LISTENER_PRE_MERGE + COND_LISTENER_MERGE + COND_LISTENER_PRE_PERSIST + COND_LISTENER_PERSIST + COND_LISTENER_PRE_DELETE + COND_LISTENER_DELETE + ")(schema=" + schemaName + "))"), null);
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        this.lock.lock();
        try {
            Object listener = super.addingService(reference);
            this.listeners.add(listener);
            Collection schemaTypes = new DictionaryAdapter(reference).emptyStringAsNull().getStringCollection("schemaTypes", new String[0]);
            if (schemaTypes != null && !schemaTypes.isEmpty()) {
                String[] tpyeNamesArray = schemaTypes.toArray(new String[schemaTypes.size()]);
                this.engine.addListenerForTypes(listener, tpyeNamesArray);
            } else {
                this.engine.addListener(listener);
            }
            Object object = listener;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference reference, Object service) {
        this.lock.lock();
        try {
            Iterator<Object> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != service) continue;
                iterator.remove();
            }
            this.engine.removeListener(service);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        super.close();
        this.lock.lock();
        try {
            for (Object listener : this.listeners) {
                this.engine.removeListener(listener);
            }
            this.listeners.clear();
        }
        finally {
            this.lock.unlock();
        }
    }
}

