/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.factory;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bndly.schema.api.SchemaBeanProvider;
import org.bndly.schema.api.services.Engine;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SchemaBeanServicesListener {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaBeanServicesListener.class);
    protected final BundleContext bundleContext;
    private final String schemaName;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private ServiceTracker<Engine, Engine> engineTracker;
    private ServiceTracker<SchemaBeanProvider, SchemaBeanProvider> schemaBeanProviderTracker;
    private Engine engine;
    private SchemaBeanProvider schemaBeanProvider;
    private boolean ready;
    private boolean shutdown;

    public SchemaBeanServicesListener(BundleContext bundleContext, String schemaName) {
        this.bundleContext = bundleContext;
        this.schemaName = schemaName;
    }

    public void init() throws InvalidSyntaxException {
        String engineFilterString = "(&(objectClass=" + Engine.class.getName() + ")(" + "service.pid" + "=" + Engine.class.getName() + "." + this.schemaName + "))";
        this.engineTracker = new ServiceTracker(this.bundleContext, this.bundleContext.createFilter(engineFilterString), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Engine, Engine>(){

            public Engine addingService(ServiceReference<Engine> sr) {
                SchemaBeanServicesListener.this.lock.writeLock().lock();
                try {
                    SchemaBeanServicesListener.this.engine = (Engine)SchemaBeanServicesListener.this.bundleContext.getService(sr);
                    if (SchemaBeanServicesListener.this.engine != null && SchemaBeanServicesListener.this.schemaBeanProvider != null) {
                        SchemaBeanServicesListener.this.onReadyInternal(SchemaBeanServicesListener.this.engine, SchemaBeanServicesListener.this.schemaBeanProvider);
                    }
                    Engine engine = SchemaBeanServicesListener.this.engine;
                    return engine;
                }
                finally {
                    SchemaBeanServicesListener.this.lock.writeLock().unlock();
                }
            }

            public void modifiedService(ServiceReference<Engine> sr, Engine t) {
            }

            public void removedService(ServiceReference<Engine> sr, Engine t) {
                SchemaBeanServicesListener.this.lock.writeLock().lock();
                try {
                    SchemaBeanServicesListener.this.engine = null;
                    SchemaBeanServicesListener.this.onShutdownInternal(SchemaBeanServicesListener.this.engine, SchemaBeanServicesListener.this.schemaBeanProvider);
                }
                finally {
                    SchemaBeanServicesListener.this.lock.writeLock().unlock();
                }
            }
        });
        this.engineTracker.open();
        String schemaBeanProviderFilterString = "(&(objectClass=" + SchemaBeanProvider.class.getName() + ")(" + "service.pid" + "=" + SchemaBeanProvider.class.getName() + "." + this.schemaName + "))";
        this.schemaBeanProviderTracker = new ServiceTracker(this.bundleContext, this.bundleContext.createFilter(schemaBeanProviderFilterString), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<SchemaBeanProvider, SchemaBeanProvider>(){

            public SchemaBeanProvider addingService(ServiceReference<SchemaBeanProvider> sr) {
                SchemaBeanServicesListener.this.lock.writeLock().lock();
                try {
                    SchemaBeanServicesListener.this.schemaBeanProvider = (SchemaBeanProvider)SchemaBeanServicesListener.this.bundleContext.getService(sr);
                    if (SchemaBeanServicesListener.this.engine != null && SchemaBeanServicesListener.this.schemaBeanProvider != null) {
                        SchemaBeanServicesListener.this.onReadyInternal(SchemaBeanServicesListener.this.engine, SchemaBeanServicesListener.this.schemaBeanProvider);
                    }
                    SchemaBeanProvider schemaBeanProvider = SchemaBeanServicesListener.this.schemaBeanProvider;
                    return schemaBeanProvider;
                }
                finally {
                    SchemaBeanServicesListener.this.lock.writeLock().unlock();
                }
            }

            public void modifiedService(ServiceReference<SchemaBeanProvider> sr, SchemaBeanProvider t) {
            }

            public void removedService(ServiceReference<SchemaBeanProvider> sr, SchemaBeanProvider t) {
                SchemaBeanServicesListener.this.lock.writeLock().lock();
                try {
                    SchemaBeanServicesListener.this.schemaBeanProvider = null;
                    SchemaBeanServicesListener.this.onShutdownInternal(SchemaBeanServicesListener.this.engine, SchemaBeanServicesListener.this.schemaBeanProvider);
                }
                finally {
                    SchemaBeanServicesListener.this.lock.writeLock().unlock();
                }
            }
        });
        this.schemaBeanProviderTracker.open();
    }

    public void destroy() {
    }

    private void onReadyInternal(Engine engine, SchemaBeanProvider schemaBeanProvider) {
        if (!this.ready) {
            this.ready = true;
            this.shutdown = false;
            LOG.info("schema bean factory for schema {} should become ready now", (Object)this.schemaName);
            this.onReady(engine, schemaBeanProvider);
        }
    }

    private void onShutdownInternal(Engine engine, SchemaBeanProvider schemaBeanProvider) {
        if (!this.shutdown && this.ready) {
            this.shutdown = true;
            this.ready = false;
            LOG.info("schema bean factory for schema {} should shut down now", (Object)this.schemaName);
            this.onShutdown(engine, schemaBeanProvider);
        }
    }

    protected abstract void onReady(Engine var1, SchemaBeanProvider var2);

    protected abstract void onShutdown(Engine var1, SchemaBeanProvider var2);
}

