/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.mapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.bndly.schema.api.AttributeMediator;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.db.AttributeColumn;
import org.bndly.schema.api.db.TypeTable;
import org.bndly.schema.api.mapper.RowMapper;
import org.bndly.schema.api.services.Accessor;
import org.bndly.schema.impl.MediatorRegistryImpl;
import org.bndly.schema.impl.RecordImpl;
import org.bndly.schema.model.Attribute;

public class SingleTableToRecordRowMapper
implements RowMapper<Record> {
    private final Accessor accessor;
    private final TypeTable table;
    private final MediatorRegistryImpl mediatorRegistry;
    private final RecordContext recordContext;

    public SingleTableToRecordRowMapper(TypeTable table, MediatorRegistryImpl mediatorRegistry, Accessor accessor, RecordContext recordContext) {
        this.table = table;
        this.mediatorRegistry = mediatorRegistry;
        this.accessor = accessor;
        this.recordContext = recordContext;
    }

    public Record mapRow(ResultSet rs, int i) throws SQLException {
        long id = rs.getLong("id");
        Record r = this.recordContext.get(this.table.getType(), id);
        List columns = this.table.getColumns();
        for (AttributeColumn col : columns) {
            Attribute attribute = col.getAttribute();
            AttributeMediator<Attribute> mediator = this.mediatorRegistry.getMediatorForAttribute(attribute);
            Object value = mediator.extractFromResultSet(rs, col.getColumnName(), attribute, this.recordContext);
            r.setAttributeValue(attribute.getName(), value);
        }
        if (RecordImpl.class.isInstance(r) && r != null) {
            ((RecordImpl)r).setIsDirty(false);
        }
        return r;
    }
}

