/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery;

import java.util.Stack;
import org.bndly.schema.api.nquery.ExpressionStatementHandler;
import org.bndly.schema.api.nquery.Parser;
import org.bndly.schema.api.nquery.ParsingState;
import org.bndly.schema.api.nquery.Query;
import org.bndly.schema.api.nquery.QueryParsingException;
import org.bndly.schema.api.nquery.ReservedKeywords;
import org.bndly.schema.impl.nquery.states.CommandDetectionState;
import org.bndly.schema.impl.nquery.states.ConsumeWhiteSpacesState;

public final class ParserImpl
implements ReservedKeywords,
Parser {
    private final Stack<ParsingState> states = new Stack();
    private final StringBuffer whatHasBeenParsed = new StringBuffer();
    private final Object[] queryArgs;
    private final CommandDetectionState cmdDetection;
    private ExpressionStatementHandler expressionStatementHandler;
    private int queryArgsPos = 0;
    private int markerQueryArgsPos;

    public ParserImpl(Object ... queryArgs) {
        this.queryArgs = queryArgs;
        this.cmdDetection = new CommandDetectionState();
        this.push(new ConsumeWhiteSpacesState(){

            @Override
            protected void onNonWhiteSpace(char character, Parser parser) throws QueryParsingException {
                parser.pop();
                parser.push((ParsingState)ParserImpl.this.cmdDetection).handleChar(character, parser);
            }
        });
    }

    public final Object[] getQueryArgs() {
        return this.queryArgs;
    }

    public final Object getQueryArg(int index) {
        return this.getQueryArgs()[index];
    }

    public Object getNextQueryArg() {
        Object arg = this.getQueryArg(this.queryArgsPos);
        ++this.queryArgsPos;
        return arg;
    }

    public Parser resetQueryArgPosition() {
        this.queryArgsPos = this.markerQueryArgsPos;
        return this;
    }

    public Parser markQueryArgPosition() {
        this.markerQueryArgsPos = this.queryArgsPos;
        return this;
    }

    public Parser parse(String queryString) throws QueryParsingException {
        return this.parseInternal(queryString, true, true);
    }

    public Parser reparse(String string) throws QueryParsingException {
        return this.parseInternal(string, false, false);
    }

    public final Query getQuery() {
        return this.cmdDetection.getQuery();
    }

    public ParserImpl expressionStatementHandler(ExpressionStatementHandler expressionStatementHandler) {
        this.expressionStatementHandler = expressionStatementHandler;
        return this;
    }

    private Parser parseInternal(String queryString, boolean appendToWhatHasBeenRead, boolean throwEnd) throws QueryParsingException {
        ParserImpl that;
        ParserImpl p = that = this;
        if (appendToWhatHasBeenRead) {
            p = new Parser(){

                public ParsingState pop() {
                    return that.pop();
                }

                public ParsingState push(ParsingState parsingState) {
                    return that.push(parsingState);
                }

                public ParsingState peek() {
                    return that.peek();
                }

                public ExpressionStatementHandler getExpressionStatementHandler() {
                    return that.getExpressionStatementHandler();
                }

                public ReservedKeywords getReservedKeywords() {
                    return that.getReservedKeywords();
                }

                public Object[] getQueryArgs() {
                    return that.getQueryArgs();
                }

                public Object getQueryArg(int index) {
                    return that.getQueryArg(index);
                }

                public Object getNextQueryArg() {
                    return that.getNextQueryArg();
                }

                public Parser resetQueryArgPosition() {
                    that.resetQueryArgPosition();
                    return this;
                }

                public Parser markQueryArgPosition() {
                    that.markQueryArgPosition();
                    return this;
                }

                public Parser parse(String string) throws QueryParsingException {
                    ParserImpl.this.parseInternal(string, false, true);
                    return this;
                }

                public Parser reparse(String string) throws QueryParsingException {
                    ParserImpl.this.parseInternal(string, false, false);
                    return this;
                }

                public Query getQuery() {
                    return that.getQuery();
                }
            };
        }
        for (int i = 0; i < queryString.length(); ++i) {
            char character = queryString.charAt(i);
            if (appendToWhatHasBeenRead) {
                this.whatHasBeenParsed.append(character);
            }
            ParsingState currentPeek = this.peek();
            currentPeek.handleChar(character, (Parser)p);
        }
        if (throwEnd) {
            ParsingState currentPeek = this.peek();
            currentPeek.onEnd((Parser)p);
        }
        return this;
    }

    public final ParsingState peek() {
        if (this.states.isEmpty()) {
            return null;
        }
        return this.states.peek();
    }

    public final ParsingState push(ParsingState parsingState) {
        if (parsingState != null) {
            this.states.push(parsingState);
        }
        return parsingState;
    }

    public final ParsingState pop() {
        if (this.states.isEmpty()) {
            return null;
        }
        return this.states.pop();
    }

    public ReservedKeywords getReservedKeywords() {
        return this;
    }

    public ExpressionStatementHandler getExpressionStatementHandler() {
        return this.expressionStatementHandler;
    }

    public boolean isReservedKeyword(String keyword) {
        return "PICK".equals(keyword) || "COUNT".equals(keyword) || "?".equals(keyword) || "!".equals(keyword) || "=".equals(keyword) || ">".equals(keyword) || ">=".equals(keyword) || "<".equals(keyword) || "<=".equals(keyword) || "INRANGE".equals(keyword) || "TYPED".equals(keyword) || "IF".equals(keyword) || "AND".equals(keyword) || "OR".equals(keyword) || "(".equals(keyword) || ")".equals(keyword) || "ORDERBY".equals(keyword) || "LIMIT".equals(keyword) || "OFFSET".equals(keyword);
    }
}

