/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery.expression;

import org.bndly.schema.api.nquery.Expression;
import org.bndly.schema.api.nquery.ExpressionStatementHandler;
import org.bndly.schema.api.nquery.Parser;
import org.bndly.schema.api.nquery.QueryParsingException;
import org.bndly.schema.impl.nquery.ComparisonExpression;
import org.bndly.schema.impl.nquery.ComparisonExpressionImpl;
import org.bndly.schema.impl.nquery.ContextVariable;
import org.bndly.schema.impl.nquery.expression.AbstractSimpleExpressionStatementHandler;

public class ComparisonExpressionStatementHandler
extends AbstractSimpleExpressionStatementHandler {
    private final ComparisonExpression.Type type;
    private final boolean allowParameterNull;

    public ComparisonExpressionStatementHandler(String keyword, ComparisonExpression.Type type, boolean allowParameterNull) {
        super(keyword);
        this.type = type;
        this.allowParameterNull = allowParameterNull;
    }

    @Override
    protected Expression createExpression(ContextVariable l, ContextVariable r, Boolean negated, ExpressionStatementHandler.Context context, Parser parser, String statement) throws QueryParsingException {
        ComparisonExpressionImpl comparisonExpressionImpl = new ComparisonExpressionImpl(statement, this.type);
        comparisonExpressionImpl.setNegated(negated);
        comparisonExpressionImpl.setLeft(l);
        comparisonExpressionImpl.setRight(r);
        comparisonExpressionImpl.setNextOperator(context.nextOperator());
        if (!this.allowParameterNull && l.isArg() && l.getArg() == null) {
            throw new QueryParsingException("parameter was null but should have been a non-null value");
        }
        if (!this.allowParameterNull && r.isArg() && r.getArg() == null) {
            throw new QueryParsingException("parameter was null but should have been a non-null value");
        }
        return comparisonExpressionImpl;
    }
}

