/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery.expression;

import java.util.ArrayList;
import java.util.List;
import org.bndly.schema.api.ObjectReference;
import org.bndly.schema.api.nquery.BooleanOperator;
import org.bndly.schema.api.nquery.Expression;
import org.bndly.schema.api.nquery.ExpressionStatementHandler;
import org.bndly.schema.api.nquery.Parser;
import org.bndly.schema.api.nquery.ParsingState;
import org.bndly.schema.api.nquery.QueryParsingException;

public class DelegatingExpressionStatementHandler
implements ExpressionStatementHandler {
    private final List<ExpressionStatementHandler> handlers = new ArrayList<ExpressionStatementHandler>();

    public void handleStatement(String statement, Parser parser, final ExpressionStatementHandler.Context context) throws QueryParsingException {
        ParsingState peekAfter;
        final ObjectReference exp = new ObjectReference();
        ExpressionStatementHandler.Context ctx = new ExpressionStatementHandler.Context(){

            public BooleanOperator nextOperator() {
                return context.nextOperator();
            }

            public void expressionCreated(Expression expression) throws QueryParsingException {
                context.expressionCreated(expression);
                exp.set((Object)expression);
            }
        };
        parser.markQueryArgPosition();
        ParsingState peekBefore = parser.peek();
        for (ExpressionStatementHandler handler : this.handlers) {
            ParsingState localPeekBefore = parser.peek();
            try {
                parser.resetQueryArgPosition();
                handler.handleStatement(statement, parser, ctx);
            }
            catch (QueryParsingException queryParsingException) {
                // empty catch block
            }
            ParsingState localPeekAfter = parser.peek();
            if (localPeekBefore != localPeekAfter) {
                throw new QueryParsingException("expression statement handler did alter the peek parsing state stack");
            }
            if (exp.get() == null) continue;
            break;
        }
        if (peekBefore != (peekAfter = parser.peek())) {
            throw new QueryParsingException("peek parsing states have changed while parsing an expression statement");
        }
        if (exp.get() == null) {
            throw new QueryParsingException("statement could not be converted to an expression");
        }
    }

    public void addExpressionStatementHandler(ExpressionStatementHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
        }
    }

    public void removeExpressionStatementHandler(ExpressionStatementHandler handler) {
        if (handler != null) {
            this.handlers.remove(handler);
        }
    }

    public void clear() {
        this.handlers.clear();
    }
}

