/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery.expression;

import org.bndly.schema.api.nquery.Expression;
import org.bndly.schema.api.nquery.ExpressionStatementHandler;
import org.bndly.schema.api.nquery.Parser;
import org.bndly.schema.api.nquery.ParsingState;
import org.bndly.schema.api.nquery.QueryParsingException;
import org.bndly.schema.impl.nquery.ContextVariable;
import org.bndly.schema.impl.nquery.EntityAttributeReferenceVariable;
import org.bndly.schema.impl.nquery.TypedExpressionImpl;
import org.bndly.schema.impl.nquery.states.AcceptStringState;
import org.bndly.schema.impl.nquery.states.ConsumeWhiteSpacesState;
import org.bndly.schema.impl.nquery.states.ReadContextVariableState;

public class TypedExpressionStatementHandler
implements ExpressionStatementHandler {
    public void handleStatement(final String statement, Parser parser, final ExpressionStatementHandler.Context context) throws QueryParsingException {
        parser.push((ParsingState)new ReadContextVariableState(){

            @Override
            protected void onContextVariable(final ContextVariable field, Character character, Parser parser) throws QueryParsingException {
                if (field.isArg()) {
                    throw new QueryParsingException("expected an entity attribute reference left of TYPED keyword");
                }
                parser.push((ParsingState)new ConsumeWhiteSpacesState(){

                    @Override
                    protected void onNonWhiteSpace(char character, Parser parser) throws QueryParsingException {
                        parser.pop();
                        parser.push((ParsingState)new AcceptStringState("TYPED"){

                            @Override
                            protected void accepted(Parser parser) throws QueryParsingException {
                                parser.pop();
                                parser.push((ParsingState)new ReadContextVariableState(){

                                    @Override
                                    protected void onContextVariable(ContextVariable contextVariable, Character character, Parser parser) throws QueryParsingException {
                                        if (!contextVariable.isArg()) {
                                            throw new QueryParsingException("expected a query argument right of TYPED keyword");
                                        }
                                        Object val = contextVariable.getArg();
                                        if (!String.class.isInstance(val)) {
                                            throw new QueryParsingException("query argument should be a string for TYPED expression");
                                        }
                                        TypedExpressionImpl typedExpressionImpl = new TypedExpressionImpl(statement);
                                        EntityAttributeReferenceVariable f = new EntityAttributeReferenceVariable(field.getName() + ".id");
                                        typedExpressionImpl.setField(f);
                                        typedExpressionImpl.setTypeName((String)val);
                                        typedExpressionImpl.setNextOperator(context.nextOperator());
                                        context.expressionCreated((Expression)typedExpressionImpl);
                                    }
                                });
                            }

                            @Override
                            protected void notAccepted(Character character, Parser parser) throws QueryParsingException {
                                parser.pop();
                                throw new QueryParsingException("statement did not contain TYPED keyword");
                            }
                        }).handleChar(character, parser);
                    }
                });
            }
        });
        parser.parse(statement);
    }
}

