/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery.sqlmapper;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Set;
import org.bndly.schema.api.AliasBinding;
import org.bndly.schema.api.AttributeMediator;
import org.bndly.schema.api.MappingBinding;
import org.bndly.schema.api.db.AttributeColumn;
import org.bndly.schema.api.query.Criteria;
import org.bndly.schema.api.query.PreparedStatementValueProvider;
import org.bndly.schema.api.query.ValueProvider;
import org.bndly.schema.impl.nquery.ComparisonExpression;
import org.bndly.schema.impl.nquery.ContextVariable;
import org.bndly.schema.impl.nquery.sqlmapper.AbstractFieldCentricMapper;
import org.bndly.schema.impl.nquery.sqlmapper.BooleanStatementSQLMapper;
import org.bndly.schema.impl.nquery.sqlmapper.MediatorProvider;
import org.bndly.schema.impl.nquery.sqlmapper.RequiredAttribtuesInspector;
import org.bndly.schema.impl.nquery.sqlmapper.Util;
import org.bndly.schema.impl.query.ExpressionProducer;
import org.bndly.schema.model.Attribute;

public class ComparisonExpressionMapper
extends AbstractFieldCentricMapper<ComparisonExpression>
implements BooleanStatementSQLMapper<ComparisonExpression>,
RequiredAttribtuesInspector<ComparisonExpression> {
    private final MediatorProvider mediatorProvider;

    public ComparisonExpressionMapper(MediatorProvider mediatorProvider) {
        super(ComparisonExpression.class);
        if (mediatorProvider == null) {
            throw new IllegalArgumentException("mediatorProvider is not allowed to be null");
        }
        this.mediatorProvider = mediatorProvider;
    }

    @Override
    protected void map(ComparisonExpression booleanStatement, ExpressionProducer expressionProducer, String prefix, MappingBinding mappingBinding, BooleanStatementSQLMapper.Context context, AliasBinding aliasBinding) {
        Criteria criteria = expressionProducer.produce().criteria();
        this.mapComparisonExpressionToCriteria(booleanStatement, criteria, aliasBinding);
    }

    @Override
    protected String getAttributePath(ComparisonExpression booleanStatement) {
        return booleanStatement.getLeft().getName();
    }

    @Override
    public void collectRequiredAttributesFromBooleanStatement(Set<String> set, String alias, ComparisonExpression booleanStatement, RequiredAttribtuesInspector.Context context) {
        ContextVariable left = booleanStatement.getLeft();
        ContextVariable right = booleanStatement.getRight();
        if (!left.isArg()) {
            Util.addAttributeToSet(set, Util.stripEntityAliasPrefix(alias, left.getName()));
        }
        if (!right.isArg()) {
            Util.addAttributeToSet(set, Util.stripEntityAliasPrefix(alias, right.getName()));
        }
    }

    private void mapComparisonExpressionToCriteria(ComparisonExpression ee, Criteria criteria, AliasBinding alias) {
        String fieldName = alias.getTableAlias() + "." + alias.getAttributeColumn().getColumnName();
        if (ee.getComparisonType() == ComparisonExpression.Type.EQUAL) {
            this.mapEquals(ee, criteria, fieldName, alias.getAttributeColumn());
        } else if (ee.getComparisonType() == ComparisonExpression.Type.GREATER) {
            this.mapGreater(ee, criteria, fieldName, alias.getAttributeColumn());
        } else if (ee.getComparisonType() == ComparisonExpression.Type.LOWER) {
            this.mapLower(ee, criteria, fieldName, alias.getAttributeColumn());
        } else if (ee.getComparisonType() == ComparisonExpression.Type.GREATER_EQUAL) {
            this.mapGreaterEqual(ee, criteria, fieldName, alias.getAttributeColumn());
        } else if (ee.getComparisonType() == ComparisonExpression.Type.LOWER_EQUAL) {
            this.mapLowerEqual(ee, criteria, fieldName, alias.getAttributeColumn());
        } else {
            throw new IllegalStateException("unsupported comparison type");
        }
    }

    private void mapEquals(ComparisonExpression ee, Criteria criteria, String fieldName, AttributeColumn attributeColumn) {
        if (ee.getRight().getArg() == null) {
            if (ee.isNegated()) {
                criteria.field(fieldName).isNotNull();
            } else {
                criteria.field(fieldName).isNull();
            }
        } else if (ee.isNegated()) {
            criteria.field(fieldName).notEqual().value((ValueProvider)this.createPreparedStatementValueProvider(attributeColumn, ee.getRight()));
        } else {
            criteria.field(fieldName).equal().value((ValueProvider)this.createPreparedStatementValueProvider(attributeColumn, ee.getRight()));
        }
    }

    private PreparedStatementValueProvider createPreparedStatementValueProvider(AttributeColumn attributeColumn, ContextVariable contextVariable) {
        return ComparisonExpressionMapper.createPreparedStatementValueProvider(this.mediatorProvider, attributeColumn, contextVariable);
    }

    static PreparedStatementValueProvider createPreparedStatementValueProvider(MediatorProvider mediatorProvider, AttributeColumn attributeColumn, final ContextVariable contextVariable) {
        final Attribute attribute = attributeColumn.getAttribute();
        final AttributeMediator mediator = mediatorProvider.getMediatorForAttribute(attribute);
        return new PreparedStatementValueProvider(){

            public Object get() {
                return contextVariable.getArg();
            }

            public void set(int index, PreparedStatement ps) throws SQLException {
                mediator.setRawParameterInPreparedStatement(index, ps, attribute, this.get());
            }
        };
    }

    private void mapGreater(ComparisonExpression ee, Criteria criteria, String fieldName, AttributeColumn attributeColumn) {
        criteria.field(fieldName);
        ContextVariable contextVariable = ee.getRight().isArg() ? ee.getRight() : ee.getLeft();
        PreparedStatementValueProvider vp = this.createPreparedStatementValueProvider(attributeColumn, contextVariable);
        if (ee.isNegated()) {
            criteria.equalOrLowerThan().value((ValueProvider)vp);
        } else {
            criteria.greaterThan().value((ValueProvider)vp);
        }
    }

    private void mapLower(ComparisonExpression ee, Criteria criteria, String fieldName, AttributeColumn attributeColumn) {
        criteria.field(fieldName);
        ContextVariable contextVariable = ee.getRight().isArg() ? ee.getRight() : ee.getLeft();
        PreparedStatementValueProvider vp = this.createPreparedStatementValueProvider(attributeColumn, contextVariable);
        if (ee.isNegated()) {
            criteria.equalOrGreaterThan().value((ValueProvider)vp);
        } else {
            criteria.lowerThan().value((ValueProvider)vp);
        }
    }

    private void mapLowerEqual(ComparisonExpression ee, Criteria criteria, String fieldName, AttributeColumn attributeColumn) {
        criteria.field(fieldName);
        ContextVariable contextVariable = ee.getRight().isArg() ? ee.getRight() : ee.getLeft();
        PreparedStatementValueProvider vp = this.createPreparedStatementValueProvider(attributeColumn, contextVariable);
        if (ee.isNegated()) {
            criteria.greaterThan().value((ValueProvider)vp);
        } else {
            criteria.equalOrLowerThan().value((ValueProvider)vp);
        }
    }

    private void mapGreaterEqual(ComparisonExpression ee, Criteria criteria, String fieldName, AttributeColumn attributeColumn) {
        criteria.field(fieldName);
        ContextVariable contextVariable = ee.getRight().isArg() ? ee.getRight() : ee.getLeft();
        PreparedStatementValueProvider vp = this.createPreparedStatementValueProvider(attributeColumn, contextVariable);
        if (ee.isNegated()) {
            criteria.lowerThan().value((ValueProvider)vp);
        } else {
            criteria.equalOrGreaterThan().value((ValueProvider)vp);
        }
    }
}

