/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery.sqlmapper;

import java.util.Set;
import org.bndly.schema.api.AliasBinding;
import org.bndly.schema.api.MappingBinding;
import org.bndly.schema.api.query.Criteria;
import org.bndly.schema.api.query.Expression;
import org.bndly.schema.api.query.PreparedStatementValueProvider;
import org.bndly.schema.api.query.ValueProvider;
import org.bndly.schema.impl.nquery.ContextVariable;
import org.bndly.schema.impl.nquery.InRangeExpression;
import org.bndly.schema.impl.nquery.sqlmapper.AbstractFieldCentricMapper;
import org.bndly.schema.impl.nquery.sqlmapper.BooleanStatementSQLMapper;
import org.bndly.schema.impl.nquery.sqlmapper.ComparisonExpressionMapper;
import org.bndly.schema.impl.nquery.sqlmapper.MediatorProvider;
import org.bndly.schema.impl.nquery.sqlmapper.RequiredAttribtuesInspector;
import org.bndly.schema.impl.nquery.sqlmapper.Util;
import org.bndly.schema.impl.query.ExpressionProducer;

public class InRangeExpressionMapper
extends AbstractFieldCentricMapper<InRangeExpression>
implements RequiredAttribtuesInspector<InRangeExpression> {
    private final MediatorProvider mediatorProvider;

    public InRangeExpressionMapper(MediatorProvider mediatorProvider) {
        super(InRangeExpression.class);
        if (mediatorProvider == null) {
            throw new IllegalArgumentException("mediatorProvider is not allowed to be null");
        }
        this.mediatorProvider = mediatorProvider;
    }

    @Override
    protected void map(InRangeExpression booleanStatement, ExpressionProducer expressionProducer, String prefix, MappingBinding mappingBinding, BooleanStatementSQLMapper.Context context, AliasBinding aliasBinding) {
        this.mapToCriteria(booleanStatement, expressionProducer, aliasBinding);
    }

    @Override
    public void collectRequiredAttributesFromBooleanStatement(Set<String> set, String alias, InRangeExpression booleanStatement, RequiredAttribtuesInspector.Context context) {
        InRangeExpressionMapper.addAttributesToSet(booleanStatement.getField(), set, alias);
        InRangeExpressionMapper.addAttributesToSet(booleanStatement.getLowerBorder(), set, alias);
        InRangeExpressionMapper.addAttributesToSet(booleanStatement.getUpperBorder(), set, alias);
    }

    static void addAttributesToSet(ContextVariable cv, Set<String> set, String alias) {
        if (!cv.isArg()) {
            Util.addAttributeToSet(set, Util.stripEntityAliasPrefix(alias, cv.getName()));
        }
    }

    @Override
    protected String getAttributePath(InRangeExpression booleanStatement) {
        return booleanStatement.getField().getName();
    }

    private void mapToCriteria(InRangeExpression booleanStatement, ExpressionProducer expressionProducer, AliasBinding aliasBinding) {
        String fieldName = aliasBinding.getTableAlias() + "." + aliasBinding.getAttributeColumn().getColumnName();
        Object lower = booleanStatement.getLowerBorder().getArg();
        Object upper = booleanStatement.getUpperBorder().getArg();
        if (lower != null && upper != null) {
            PreparedStatementValueProvider lowerValueProvider = ComparisonExpressionMapper.createPreparedStatementValueProvider(this.mediatorProvider, aliasBinding.getAttributeColumn(), booleanStatement.getLowerBorder());
            PreparedStatementValueProvider upperValueProvider = ComparisonExpressionMapper.createPreparedStatementValueProvider(this.mediatorProvider, aliasBinding.getAttributeColumn(), booleanStatement.getUpperBorder());
            if (booleanStatement.isNegated()) {
                Expression expression = expressionProducer.produce().wrap().wrapped();
                expression.criteria().field(fieldName).lowerThan().value((ValueProvider)lowerValueProvider);
                expression.or().criteria().field(fieldName).greaterThan().value((ValueProvider)upperValueProvider);
            } else {
                Criteria criteria = expressionProducer.produce().criteria();
                criteria.field(fieldName).between().left((ValueProvider)lowerValueProvider).right((ValueProvider)upperValueProvider);
            }
        } else if (lower != null && upper == null) {
            Criteria criteria = expressionProducer.produce().criteria();
            PreparedStatementValueProvider lowerValueProvider = ComparisonExpressionMapper.createPreparedStatementValueProvider(this.mediatorProvider, aliasBinding.getAttributeColumn(), booleanStatement.getLowerBorder());
            if (booleanStatement.isNegated()) {
                criteria.field(fieldName).lowerThan().value((ValueProvider)lowerValueProvider);
            } else {
                criteria.field(fieldName).equalOrGreaterThan().value((ValueProvider)lowerValueProvider);
            }
        } else if (lower == null && upper != null) {
            Criteria criteria = expressionProducer.produce().criteria();
            PreparedStatementValueProvider upperValueProvider = ComparisonExpressionMapper.createPreparedStatementValueProvider(this.mediatorProvider, aliasBinding.getAttributeColumn(), booleanStatement.getUpperBorder());
            if (booleanStatement.isNegated()) {
                criteria.field(fieldName).greaterThan().value((ValueProvider)upperValueProvider);
            } else {
                criteria.field(fieldName).equalOrLowerThan().value((ValueProvider)upperValueProvider);
            }
        } else {
            throw new IllegalStateException("neither left or right border are defined for INRANGE");
        }
    }
}

