/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery.states;

import java.util.Stack;
import org.bndly.schema.api.ObjectReference;
import org.bndly.schema.api.nquery.BooleanOperator;
import org.bndly.schema.api.nquery.BooleanStatement;
import org.bndly.schema.api.nquery.Expression;
import org.bndly.schema.api.nquery.ExpressionStatementHandler;
import org.bndly.schema.api.nquery.Parser;
import org.bndly.schema.api.nquery.ParsingState;
import org.bndly.schema.api.nquery.QueryParsingException;
import org.bndly.schema.api.nquery.WrapperBooleanStatement;
import org.bndly.schema.impl.nquery.ExpressionImpl;
import org.bndly.schema.impl.nquery.WrapperBooleanStatementImpl;
import org.bndly.schema.impl.nquery.states.ConsumeWhiteSpacesState;
import org.bndly.schema.impl.nquery.states.ReadAheadState;

public abstract class BooleanStatementState
extends ConsumeWhiteSpacesState {
    private final Stack<BooleanStatement> statementStack = new Stack();
    private BooleanStatement first;

    @Override
    protected void onNonWhiteSpace(char character, Parser parser) throws QueryParsingException {
        parser.push((ParsingState)this.createReadAheadState());
        this.doContinue(Character.valueOf(character), parser);
    }

    private ReadAheadState createReadAheadState() {
        return new ReadAheadState(new String[]{"(", ")", "AND", "OR", "ORDERBY", "LIMIT", "OFFSET"}){

            @Override
            protected void onStopWord(String bufferedBeforeStopWord, String stopWord, char character, Parser parser) throws QueryParsingException {
                parser.pop();
                BooleanStatementState.this.addStatement(bufferedBeforeStopWord, stopWord, parser);
                if ("(".equals(stopWord) || ")".equals(stopWord) || "AND".equals(stopWord) || "OR".equals(stopWord)) {
                    parser.push((ParsingState)BooleanStatementState.this.createReadAheadState());
                } else {
                    BooleanStatementState.this.onEndOfBooleanStatement(stopWord, parser);
                }
            }

            @Override
            public void onEnd(Parser parser) throws QueryParsingException {
                parser.pop();
                BooleanStatementState.this.addStatement(this.getBuffered(), null, parser);
                boolean isPeek = true;
                while (!BooleanStatementState.this.statementStack.isEmpty()) {
                    BooleanStatement wrapped;
                    BooleanStatement top = (BooleanStatement)BooleanStatementState.this.statementStack.pop();
                    if (WrapperBooleanStatement.class.isInstance(top) && ((wrapped = ((WrapperBooleanStatement)top).getWrapped()) == null || !isPeek)) {
                        throw new QueryParsingException("wrapper element was not closed");
                    }
                    isPeek = false;
                }
            }
        };
    }

    private void addStatement(String originalStatement, String stopWord, Parser parser) throws QueryParsingException {
        String statement = originalStatement.trim();
        Object operator = "AND".equals(stopWord) ? BooleanOperator.AND : ("OR".equals(stopWord) ? BooleanOperator.OR : null);
        if (!statement.isEmpty()) {
            ExpressionStatementHandler handler = parser.getExpressionStatementHandler();
            if (handler == null) {
                throw new QueryParsingException("can not parse statement, when no expression statementhandler is provided by the parser");
            }
            ObjectReference isCreatedRef = new ObjectReference((Object)Boolean.FALSE);
            handler.handleStatement(statement, parser, new ExpressionStatementHandler.Context((BooleanOperator)operator, isCreatedRef){
                final /* synthetic */ BooleanOperator val$operator;
                final /* synthetic */ ObjectReference val$isCreatedRef;
                {
                    this.val$operator = booleanOperator;
                    this.val$isCreatedRef = objectReference;
                }

                public BooleanOperator nextOperator() {
                    return this.val$operator;
                }

                public void expressionCreated(Expression expression) throws QueryParsingException {
                    if (!((Boolean)this.val$isCreatedRef.get()).booleanValue()) {
                        this.val$isCreatedRef.set((Object)Boolean.TRUE);
                        if (expression.getNextOperator() != this.val$operator) {
                            throw new IllegalArgumentException("created expression did not contain the boolean operator for the next expression");
                        }
                    } else {
                        throw new IllegalStateException("already created boolean statement for expression");
                    }
                    BooleanStatementState.this.appendBooleanStatement((BooleanStatement)expression);
                }
            });
            if (!((Boolean)isCreatedRef.get()).booleanValue()) {
                throw new QueryParsingException("no expression created for statement string");
            }
        } else if ("(".equals(stopWord)) {
            this.appendBooleanStatement((BooleanStatement)new WrapperBooleanStatementImpl());
        } else if (operator != null && !this.statementStack.isEmpty() && WrapperBooleanStatementImpl.class.isInstance(this.statementStack.peek())) {
            ((WrapperBooleanStatementImpl)this.statementStack.peek()).setNextOperator((BooleanOperator)operator);
        } else if (operator != null && this.statementStack.isEmpty()) {
            throw new QueryParsingException("can not append a boolean operator, when there is no preceding element in the statement stack");
        }
        if (")".equals(stopWord)) {
            BooleanStatement top = this.statementStack.pop();
            if (!WrapperBooleanStatement.class.isInstance(top) && this.statementStack.isEmpty()) {
                throw new QueryParsingException("wrapper was closed before it was actually opened");
            }
            if (!this.statementStack.isEmpty()) {
                top = this.statementStack.pop();
            }
            if (!WrapperBooleanStatement.class.isInstance(top)) {
                throw new QueryParsingException("stack of boolean statements was messed up when closing a wrapper.");
            }
            if (((WrapperBooleanStatement)top).getWrapped() != null) {
                this.statementStack.push(top);
            }
        }
    }

    private void appendBooleanStatement(BooleanStatement toAppend) throws QueryParsingException {
        if (this.first == null) {
            this.first = toAppend;
            this.onFirstBooleanStatement(toAppend);
        }
        if (this.statementStack.isEmpty()) {
            this.statementStack.push(toAppend);
        } else {
            BooleanStatement peek = this.statementStack.peek();
            BooleanOperator operator = peek.getNextOperator();
            if (ExpressionImpl.class.isInstance(peek)) {
                if (operator == null) {
                    throw new QueryParsingException("can not append a statement when there is not operator provided");
                }
                ((ExpressionImpl)peek).setNext(toAppend);
                this.statementStack.pop();
                this.statementStack.push(toAppend);
            } else if (WrapperBooleanStatementImpl.class.isInstance(peek)) {
                WrapperBooleanStatementImpl wrapper = (WrapperBooleanStatementImpl)peek;
                BooleanStatement wrapped = wrapper.getWrapped();
                if (wrapped != null) {
                    if (operator == null) {
                        throw new QueryParsingException("can not append a statement when there is not operator provided");
                    }
                    wrapper.setNext(toAppend);
                    this.statementStack.pop();
                } else {
                    wrapper.setWrapped(toAppend);
                }
                this.statementStack.push(toAppend);
            } else {
                throw new IllegalStateException("unsupported stackelement. can not append boolean statement.");
            }
        }
    }

    protected abstract void onFirstBooleanStatement(BooleanStatement var1);

    protected abstract void onEndOfBooleanStatement(String var1, Parser var2) throws QueryParsingException;
}

