/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery.states;

import org.bndly.schema.api.nquery.Parser;
import org.bndly.schema.api.nquery.ParsingState;
import org.bndly.schema.api.nquery.QueryParsingException;
import org.bndly.schema.impl.nquery.ContextVariable;
import org.bndly.schema.impl.nquery.EntityAttributeReferenceVariable;
import org.bndly.schema.impl.nquery.IfClauseImpl;
import org.bndly.schema.impl.nquery.OrderingImpl;
import org.bndly.schema.impl.nquery.PickImpl;
import org.bndly.schema.impl.nquery.states.AcceptStringState;
import org.bndly.schema.impl.nquery.states.ConsumeWhiteSpacesState;
import org.bndly.schema.impl.nquery.states.IfClauseState;
import org.bndly.schema.impl.nquery.states.ReadContextVariableState;
import org.bndly.schema.impl.nquery.states.ReservedKeywordState;
import org.bndly.schema.impl.nquery.states.TokenState;

public class PickState
extends ConsumeWhiteSpacesState {
    private final PickImpl pickImpl;

    public PickState(PickImpl pickImpl) {
        this.pickImpl = pickImpl;
    }

    @Override
    protected void onNonWhiteSpace(char character, Parser parser) throws QueryParsingException {
        parser.pop();
        parser.push((ParsingState)new TokenState(){

            @Override
            protected void onTokenComplete(Character character, Parser parser) throws QueryParsingException {
                PickState.this.pickImpl.setAttributeHolderName(this.getToken());
                parser.pop();
                parser.push((ParsingState)new ConsumeWhiteSpacesState(){

                    @Override
                    protected void onNonWhiteSpace(char character, Parser parser) throws QueryParsingException {
                        parser.pop();
                        parser.push((ParsingState)new ReservedKeywordState(){

                            @Override
                            protected void onAlias(String alias, Character character, Parser parser) throws QueryParsingException {
                                PickState.this.onParsedAlias(alias, character, parser);
                            }

                            @Override
                            protected void onKeyword(String kw, Character character, Parser parser) throws QueryParsingException {
                                PickState.this.onParsedKeyword(kw, character, parser);
                            }
                        }).handleChar(character, parser);
                    }
                });
                this.doContinue(character, parser);
            }
        }).handleChar(character, parser);
    }

    @Override
    public void onEnd(Parser parser) throws QueryParsingException {
        if (this.pickImpl.getAttributeHolderName() == null) {
            throw new QueryParsingException("parsing a PICK failed because not attribute holder was provided");
        }
    }

    private void onParsedKeyword(String kw, Character character, Parser parser) throws QueryParsingException {
        if ("IF".equals(kw)) {
            IfClauseImpl ifClauseImpl = new IfClauseImpl();
            this.pickImpl.setIfClause(ifClauseImpl);
            parser.push((ParsingState)new IfClauseState(ifClauseImpl));
        } else if ("LIMIT".equals(kw)) {
            if (this.pickImpl.getLimit() != null) {
                throw new QueryParsingException("LIMIT has already been defined");
            }
            parser.push((ParsingState)new ReadContextVariableState(){

                @Override
                protected void onContextVariable(ContextVariable contextVariable, Character character, Parser parser) throws QueryParsingException {
                    if (!contextVariable.isArg()) {
                        throw new QueryParsingException("expected an argument as a context variable for LIMIT");
                    }
                    Object limit = contextVariable.getArg();
                    if (!Number.class.isInstance(limit)) {
                        throw new QueryParsingException("LIMIT has to be a number");
                    }
                    PickState.this.pickImpl.setLimit(((Number)limit).longValue());
                }
            });
        } else if ("OFFSET".equals(kw)) {
            if (this.pickImpl.getOffset() != null) {
                throw new QueryParsingException("OFFSET has already been defined");
            }
            parser.push((ParsingState)new ReadContextVariableState(){

                @Override
                protected void onContextVariable(ContextVariable contextVariable, Character character, Parser parser) throws QueryParsingException {
                    if (!contextVariable.isArg()) {
                        throw new QueryParsingException("expected an argument as a context variable for OFFSET");
                    }
                    Object offset = contextVariable.getArg();
                    if (!Number.class.isInstance(offset)) {
                        throw new QueryParsingException("OFFSET has to be a number");
                    }
                    PickState.this.pickImpl.setOffset(((Number)offset).longValue());
                }
            });
        } else if ("ORDERBY".equals(kw)) {
            parser.push((ParsingState)new ReadContextVariableState(){

                @Override
                protected void onContextVariable(ContextVariable contextVariable, Character character, Parser parser) throws QueryParsingException {
                    if (!EntityAttributeReferenceVariable.class.isInstance(contextVariable)) {
                        throw new QueryParsingException("ORDERBY only supports EntityAttributeReferenceVariable");
                    }
                    EntityAttributeReferenceVariable v = (EntityAttributeReferenceVariable)contextVariable;
                    final OrderingImpl orderingImpl = new OrderingImpl();
                    orderingImpl.setField(v.getName());
                    orderingImpl.setAscending(true);
                    parser.push((ParsingState)new ConsumeWhiteSpacesState(){

                        @Override
                        protected void onNonWhiteSpace(char character, Parser parser) throws QueryParsingException {
                            parser.pop();
                            if ("ASC".charAt(0) == character) {
                                parser.push((ParsingState)PickState.this.createParseDirectionAscendingState(orderingImpl)).handleChar(character, parser);
                            } else if ("DESC".charAt(0) == character) {
                                parser.push((ParsingState)PickState.this.createParseDirectionDescendingState(orderingImpl)).handleChar(character, parser);
                            } else {
                                orderingImpl.setAscending(true);
                                parser.peek().handleChar(character, parser);
                            }
                        }
                    });
                    PickState.this.pickImpl.setOrdering(orderingImpl);
                }
            });
        } else {
            if (kw == null) {
                return;
            }
            throw new QueryParsingException("unsupported keyword " + kw);
        }
        this.doContinue(character, parser);
    }

    private AcceptStringState createParseDirectionDescendingState(final OrderingImpl orderingImpl) {
        return new AcceptStringState("DESC"){

            @Override
            protected void accepted(Parser parser) throws QueryParsingException {
                orderingImpl.setAscending(false);
                parser.pop();
            }

            @Override
            protected void notAccepted(Character character, Parser parser) throws QueryParsingException {
                throw new QueryParsingException("unsupported ordering direction");
            }
        };
    }

    private AcceptStringState createParseDirectionAscendingState(final OrderingImpl orderingImpl) {
        return new AcceptStringState("ASC"){

            @Override
            protected void accepted(Parser parser) throws QueryParsingException {
                orderingImpl.setAscending(true);
                parser.pop();
            }

            @Override
            protected void notAccepted(Character character, Parser parser) throws QueryParsingException {
                throw new QueryParsingException("unsupported ordering direction");
            }
        };
    }

    private void onParsedAlias(String alias, Character character, Parser parser) throws QueryParsingException {
        this.pickImpl.setAttributeHolderNameAlias(alias);
        parser.pop();
        parser.push((ParsingState)new ConsumeWhiteSpacesState(){

            @Override
            protected void onNonWhiteSpace(char character, Parser parser) throws QueryParsingException {
                parser.pop();
                parser.push((ParsingState)new TokenState(){

                    @Override
                    protected void onTokenComplete(Character character, Parser parser) throws QueryParsingException {
                        String tkn = this.getToken();
                        PickState.this.onParsedKeyword(tkn, character, parser);
                        this.sb = null;
                    }
                });
                this.doContinue(Character.valueOf(character), parser);
            }
        });
        this.doContinue(character, parser);
    }
}

