/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery.states;

import org.bndly.schema.api.nquery.Parser;
import org.bndly.schema.api.nquery.QueryParsingException;
import org.bndly.schema.impl.nquery.states.ConsumeWhiteSpacesState;

public abstract class WrapperState
extends ConsumeWhiteSpacesState {
    private boolean didOpen;
    private boolean didClose;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void onNonWhiteSpace(char character, Parser parser) throws QueryParsingException {
        if ("(".equals(Character.toString(character))) {
            if (!this.didOpen) {
                this.didOpen = true;
                return;
            } else {
                this.onNestedWrapperOpened(character, parser);
            }
            return;
        } else if (")".equals(Character.toString(character))) {
            if (!this.didOpen || this.didClose) throw new QueryParsingException("wrong wrapper was closed");
            this.didClose = true;
            this.onWrapperClosed(character, parser);
            return;
        } else {
            if (!this.didOpen || this.didClose) {
                throw new QueryParsingException("wrapper state found illegal character before/after wrapper was opened/closed");
            }
            this.onWrappedCharacter(character, parser);
        }
    }

    protected abstract void onWrappedCharacter(char var1, Parser var2) throws QueryParsingException;

    protected abstract void onNestedWrapperOpened(char var1, Parser var2) throws QueryParsingException;

    protected abstract void onWrapperClosed(char var1, Parser var2) throws QueryParsingException;
}

