/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.persistence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordAttributeIterator;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.Transaction;
import org.bndly.schema.impl.AccessorImpl;
import org.bndly.schema.impl.EngineImpl;
import org.bndly.schema.impl.IdTypeBinding;
import org.bndly.schema.impl.persistence.TypeTableReferenceUpdate;
import org.bndly.schema.impl.persistence.UniqueConstraintTableReferenceUpdate;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.InverseAttribute;
import org.bndly.schema.model.NamedAttributeHolderAttribute;

public class PersistenceManager {
    private final EngineImpl engineImpl;
    private final AccessorImpl accessorImpl;
    private final Transaction transaction;
    private final Set<Record> handledRecords = new HashSet<Record>();
    private final Map<Record, Runnable> cycleBreakersPerRecord = new LinkedHashMap<Record, Runnable>();

    public PersistenceManager(EngineImpl engineImpl, Transaction transaction) {
        this.engineImpl = engineImpl;
        this.accessorImpl = engineImpl.getAccessor();
        this.transaction = transaction;
    }

    public Transaction finalizeTransaction() {
        for (Runnable value : this.cycleBreakersPerRecord.values()) {
            value.run();
        }
        this.cycleBreakersPerRecord.clear();
        return this.transaction;
    }

    public boolean isScheduled(Record record) {
        return this.handledRecords.contains(record);
    }

    public PersistenceManager append(Record record) {
        if (this.handledRecords.contains(record)) {
            return this;
        }
        this.iterateGraphForPersistence(record);
        return this;
    }

    private boolean iterateGraphForPersistence(Record record) {
        if (record.isReference()) {
            return false;
        }
        if (this.handledRecords.contains(record)) {
            return true;
        }
        this.handledRecords.add(record);
        boolean isInsert = record.getId() == null;
        final ArrayList inverseAttributes = new ArrayList();
        record.iteratePresentValues(new RecordAttributeIterator(){

            public void handleAttribute(Attribute attribute, final Record currentRecord) {
                if (NamedAttributeHolderAttribute.class.isInstance(attribute)) {
                    Record referencedRecord;
                    Object value;
                    NamedAttributeHolderAttribute naha = (NamedAttributeHolderAttribute)NamedAttributeHolderAttribute.class.cast(attribute);
                    if (currentRecord.isAttributePresent(naha.getName()) && Record.class.isInstance(value = currentRecord.getAttributeValue(naha.getName())) && !(referencedRecord = (Record)Record.class.cast(value)).isReference()) {
                        boolean isCycle;
                        if (naha.getToOneAttribute() != null) {
                            referencedRecord.setAttributeValue(naha.getToOneAttribute(), (Object)currentRecord);
                        }
                        if ((isCycle = PersistenceManager.this.iterateGraphForPersistence(referencedRecord)) && !PersistenceManager.this.cycleBreakersPerRecord.containsKey(currentRecord)) {
                            PersistenceManager.this.cycleBreakersPerRecord.put(currentRecord, new Runnable(){

                                @Override
                                public void run() {
                                    PersistenceManager.this.updateReferences(currentRecord);
                                }
                            });
                        }
                    }
                } else if (InverseAttribute.class.isInstance(attribute) && !attribute.isVirtual()) {
                    inverseAttributes.add((InverseAttribute)attribute);
                }
            }
        });
        if (isInsert) {
            this.insert(record);
        } else {
            this.update(record);
        }
        for (InverseAttribute inverseAttribute : inverseAttributes) {
            List value;
            if (!record.isAttributePresent(inverseAttribute.getName())) continue;
            Iterator<Record> existingEntriesAsDefensiveCopy = this.loadEntriesOfInverseAttribute(inverseAttribute, record, this.accessorImpl.buildRecordContext());
            HashMap<IdTypeBinding, Record> existingRecordsThatCouldBeDeleted = new HashMap<IdTypeBinding, Record>();
            if (existingEntriesAsDefensiveCopy != null) {
                while (existingEntriesAsDefensiveCopy.hasNext()) {
                    Record existingEntryRecord = existingEntriesAsDefensiveCopy.next();
                    existingRecordsThatCouldBeDeleted.put(new IdTypeBinding(existingEntryRecord), existingEntryRecord);
                }
            }
            if ((value = (List)record.getAttributeValue(inverseAttribute.getName())) != null) {
                for (Record record2 : value) {
                    boolean itemHadPersistence;
                    Object shouldBeRecord;
                    if (record2.isReference()) continue;
                    boolean isRef = record.isReference();
                    if (!isRef) {
                        record.setIsReference(true);
                    }
                    if ((shouldBeRecord = record2.getAttributeValue(inverseAttribute.getReferencedAttributeName())) != record) {
                        record2.setAttributeValue(inverseAttribute.getReferencedAttributeName(), (Object)record);
                    }
                    boolean bl = itemHadPersistence = record2.getId() != null;
                    if (itemHadPersistence) {
                        existingRecordsThatCouldBeDeleted.remove(new IdTypeBinding(record2));
                    }
                    this.iterateGraphForPersistence(record2);
                    if (isRef) continue;
                    record.setIsReference(false);
                }
            }
            for (Map.Entry entry : existingRecordsThatCouldBeDeleted.entrySet()) {
                Record unreferencedItem = (Record)entry.getValue();
                this.engineImpl.getAccessor().delete(unreferencedItem, this.transaction);
            }
        }
        return false;
    }

    private Iterator<Record> loadEntriesOfInverseAttribute(InverseAttribute inverseAttribute, Record parent, RecordContext targetRecordContext) {
        if (parent.getId() == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (targetRecordContext == null) {
            targetRecordContext = parent.getContext();
        }
        Iterator<Record> children = this.accessorImpl.query("PICK " + inverseAttribute.getReferencedAttributeHolder().getName() + " c IF c." + inverseAttribute.getReferencedAttributeName() + ".id=? AND c." + inverseAttribute.getReferencedAttributeName() + " TYPED ?", targetRecordContext, null, parent.getId(), parent.getType().getName());
        return children;
    }

    private void insert(Record record) {
        this.accessorImpl.buildInsertQuery(record, this.transaction);
    }

    private void update(Record record) {
        this.accessorImpl.buildUpdateQuery(record, this.transaction);
    }

    private void updateReferences(Record record) {
        TypeTableReferenceUpdate.INSTANCE.append(this.transaction, record, this.engineImpl);
        UniqueConstraintTableReferenceUpdate.INSTANCE.append(this.transaction, record, this.engineImpl);
    }
}

