/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.persistence;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.bndly.schema.api.AttributeMediator;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.Transaction;
import org.bndly.schema.api.db.AttributeColumn;
import org.bndly.schema.api.db.JoinTable;
import org.bndly.schema.api.exception.SchemaException;
import org.bndly.schema.api.query.Insert;
import org.bndly.schema.api.query.PreparedStatementValueProvider;
import org.bndly.schema.api.query.Query;
import org.bndly.schema.api.query.QueryContext;
import org.bndly.schema.api.query.ValueProvider;
import org.bndly.schema.impl.EngineImpl;
import org.bndly.schema.impl.persistence.TransactionAppender;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.Mixin;
import org.bndly.schema.model.NamedAttributeHolder;
import org.bndly.schema.model.NamedAttributeHolderAttribute;
import org.bndly.schema.model.Type;

public class TypeJoinInsert
implements TransactionAppender {
    public static TypeJoinInsert INSTANCE = new TypeJoinInsert();

    @Override
    public void append(Transaction tx, final Record record, EngineImpl engine) {
        this._buildTypeJoinTableInsertQueries(record, new ValueProvider<Long>(){

            public Long get() {
                return record.getId();
            }
        }, tx, engine);
    }

    private void _buildTypeJoinTableInsertQueries(Record record, ValueProvider<Long> idRef, Transaction transaction, EngineImpl engine) {
        Type currentSuperType;
        Type currentSubType = currentSuperType = record.getType();
        ValueProvider<Long> currentIdReferenceOfSubType = idRef;
        while (currentSuperType != null) {
            List mixins;
            if (currentSuperType.getSubTypes() != null && !currentSuperType.getSubTypes().isEmpty()) {
                JoinTable joinTable = engine.getTableRegistry().getJoinTableByNamedAttributeHolder((NamedAttributeHolder)currentSuperType);
                currentIdReferenceOfSubType = this.insertRecordIdIntoJoinTable(joinTable, (NamedAttributeHolder)currentSubType, currentIdReferenceOfSubType, record.getContext(), transaction, engine);
            }
            if ((mixins = currentSuperType.getMixins()) != null && !mixins.isEmpty()) {
                for (Mixin mixin : mixins) {
                    if (mixin.isVirtual()) continue;
                    JoinTable joinTable = engine.getTableRegistry().getJoinTableByNamedAttributeHolder((NamedAttributeHolder)mixin);
                    this.insertRecordIdIntoJoinTable(joinTable, (NamedAttributeHolder)currentSuperType, currentIdReferenceOfSubType, record.getContext(), transaction, engine);
                }
            }
            currentSubType = currentSuperType;
            currentSuperType = currentSuperType.getSuperType();
        }
    }

    private ValueProvider<Long> insertRecordIdIntoJoinTable(JoinTable joinTable, NamedAttributeHolder namedAttributeHolder, ValueProvider<Long> recordId, RecordContext recordContext, Transaction transaction, EngineImpl engine) {
        Query q = this._buildInsertRecordIdIntoJoinTableQuery(joinTable, namedAttributeHolder, recordId, recordContext, engine);
        return transaction.getQueryRunner().number(q, joinTable.getPrimaryKeyColumn().getColumnName());
    }

    private Query _buildInsertRecordIdIntoJoinTableQuery(JoinTable joinTable, NamedAttributeHolder namedAttributeHolder, final ValueProvider<Long> recordId, RecordContext recordContext, EngineImpl engine) {
        List joinTableColumns = joinTable.getColumns();
        AttributeColumn colToFill = null;
        NamedAttributeHolderAttribute attribute = null;
        for (AttributeColumn attributeColumn : joinTableColumns) {
            attribute = (NamedAttributeHolderAttribute)attributeColumn.getAttribute();
            if (!attribute.getNamedAttributeHolder().getName().equals(namedAttributeHolder.getName())) continue;
            colToFill = attributeColumn;
            break;
        }
        if (colToFill != null) {
            QueryContext qc = engine.getQueryContextFactory().buildQueryContext();
            Insert insert = qc.insert();
            insert.into(joinTable.getTableName());
            AttributeMediator<NamedAttributeHolderAttribute> mediator = engine.getMediatorRegistry().getMediatorForAttribute(attribute);
            int sqlType = mediator.columnSqlType((Attribute)attribute);
            insert.value(colToFill.getColumnName(), (ValueProvider)new PreparedStatementValueProvider(){

                public Long get() {
                    return (Long)recordId.get();
                }

                public void set(int index, PreparedStatement ps) throws SQLException {
                    ps.setLong(index, this.get());
                }
            }, sqlType);
            Query q = qc.build(recordContext);
            return q;
        }
        throw new SchemaException("could not find column to fill in join table");
    }
}

