/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.persistence;

import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordAttributeIterator;
import org.bndly.schema.api.Transaction;
import org.bndly.schema.api.db.TypeTable;
import org.bndly.schema.api.exception.SchemaException;
import org.bndly.schema.api.query.Delete;
import org.bndly.schema.api.query.Query;
import org.bndly.schema.api.query.QueryContext;
import org.bndly.schema.api.query.ValueProvider;
import org.bndly.schema.impl.AccessorImpl;
import org.bndly.schema.impl.EngineImpl;
import org.bndly.schema.impl.persistence.TransactionAppender;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.NamedAttributeHolderAttribute;

public class TypeTableDelete
implements TransactionAppender {
    public static final TypeTableDelete INSTANCE = new TypeTableDelete();

    @Override
    public void append(final Transaction tx, Record record, final EngineImpl engine) {
        Query q = this._buildDeleteQuery(record, engine);
        tx.getQueryRunner().run(q);
        record.iterateValues(new RecordAttributeIterator(){

            public void handleAttribute(Attribute attribute, Record record) {
                Record parentRecord;
                NamedAttributeHolderAttribute naha;
                Boolean deleteOrphans;
                if (NamedAttributeHolderAttribute.class.isInstance(attribute) && (deleteOrphans = (naha = (NamedAttributeHolderAttribute)attribute).getDeleteOrphans()) != null && deleteOrphans.booleanValue() && (parentRecord = (Record)record.getAttributeValue(attribute.getName(), Record.class)) != null) {
                    TypeTableDelete.this.append(tx, parentRecord, engine);
                }
            }
        });
    }

    private Query _buildDeleteQuery(Record record, EngineImpl engine) {
        Long id = record.getId();
        if (id == null) {
            throw new SchemaException("can not delete a record without id");
        }
        TypeTable table = engine.getTableRegistry().getTypeTableByType(record.getType());
        QueryContext qc = engine.getQueryContextFactory().buildQueryContext();
        Delete delete = qc.delete();
        delete.from(table.getTableName()).where().expression().criteria().field(table.getPrimaryKeyColumn().getColumnName()).equal().value((ValueProvider)AccessorImpl.createRecordIdPreparedStatementValueProvider(table.getPrimaryKeyColumn(), record, engine.getMediatorRegistry()));
        Query q = qc.build(record.getContext());
        return q;
    }
}

