/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.persistence;

import java.util.List;
import org.bndly.schema.api.Logic;
import org.bndly.schema.api.ObjectReference;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RollbackHandler;
import org.bndly.schema.api.Transaction;
import org.bndly.schema.api.db.AttributeColumn;
import org.bndly.schema.api.db.TypeTable;
import org.bndly.schema.api.query.Insert;
import org.bndly.schema.api.query.Query;
import org.bndly.schema.api.query.QueryContext;
import org.bndly.schema.impl.AccessorImpl;
import org.bndly.schema.impl.EngineImpl;
import org.bndly.schema.impl.UpdateQueryImpl;
import org.bndly.schema.impl.persistence.TransactionAppender;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.BinaryAttribute;

public class TypeTableInsert
implements TransactionAppender {
    public static final TypeTableInsert INSTANCE = new TypeTableInsert();

    @Override
    public void append(Transaction tx, final Record record, EngineImpl engine) {
        QueryContext qc = engine.getQueryContextFactory().buildQueryContext();
        Insert insert = qc.insert();
        final TypeTable table = engine.getTableRegistry().getTypeTableByType(record.getType());
        insert.into(table.getTableName());
        List columns = table.getColumns();
        for (AttributeColumn attributeColumn : columns) {
            Attribute attribute = attributeColumn.getAttribute();
            if (!record.isAttributePresent(attribute.getName()) || BinaryAttribute.class.isInstance(attribute)) continue;
            AccessorImpl.appendValueToInsert(insert, attributeColumn, record, engine.getMediatorRegistry());
        }
        Query q = qc.build(record.getContext());
        UpdateQueryImpl uq = new UpdateQueryImpl(q){

            @Override
            public AttributeColumn getPrimaryKeyColumn() {
                return table.getPrimaryKeyColumn();
            }
        };
        final ObjectReference idRef = tx.getQueryRunner().number((Query)uq, uq.getPrimaryKeyColumn().getColumnName());
        tx.add(new Logic(){

            public void execute(Transaction transaction) {
                record.setId((Long)idRef.get());
            }
        });
        tx.afterRollback(new RollbackHandler(){

            public void didRollback(Transaction transaction) {
                record.setId(null);
            }
        });
    }
}

