/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.persistence;

import org.bndly.schema.api.AttributeMediator;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.Transaction;
import org.bndly.schema.api.db.AttributeColumn;
import org.bndly.schema.api.db.TypeTable;
import org.bndly.schema.api.query.Query;
import org.bndly.schema.api.query.QueryContext;
import org.bndly.schema.api.query.Update;
import org.bndly.schema.api.query.ValueProvider;
import org.bndly.schema.impl.AccessorImpl;
import org.bndly.schema.impl.EngineImpl;
import org.bndly.schema.impl.persistence.TransactionAppender;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.BinaryAttribute;

public class TypeTableUpdate
implements TransactionAppender {
    public static final TypeTableUpdate INSTANCE = new TypeTableUpdate();

    @Override
    public void append(Transaction tx, Record record, EngineImpl engine) {
        TypeTable table = engine.getTableRegistry().getTypeTableByType(record.getType());
        QueryContext qc = engine.getQueryContextFactory().buildQueryContext();
        Update update = qc.update();
        update.table(table.getTableName());
        boolean hasAttributesPresent = false;
        for (AttributeColumn attributeColumn : table.getColumns()) {
            Attribute attribute = attributeColumn.getAttribute();
            AttributeMediator<Attribute> mediator = engine.getMediatorRegistry().getMediatorForAttribute(attribute);
            if (!mediator.isAttributePresent(record, attribute) || BinaryAttribute.class.isInstance(attribute)) continue;
            update.set(attributeColumn.getColumnName(), mediator.createValueProviderFor(record, attribute), mediator.columnSqlType(attribute));
            hasAttributesPresent = true;
        }
        if (hasAttributesPresent) {
            update.where().expression().criteria().field(table.getPrimaryKeyColumn().getColumnName()).equal().value((ValueProvider)AccessorImpl.createRecordIdPreparedStatementValueProvider(table.getPrimaryKeyColumn(), record, engine.getMediatorRegistry()));
            Query q = qc.build(record.getContext());
            tx.getQueryRunner().run(q);
        }
    }
}

