/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.persistence;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.bndly.schema.api.AttributeMediator;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.Transaction;
import org.bndly.schema.api.db.AttributeColumn;
import org.bndly.schema.api.db.UniqueConstraintTable;
import org.bndly.schema.api.query.Insert;
import org.bndly.schema.api.query.PreparedStatementValueProvider;
import org.bndly.schema.api.query.Query;
import org.bndly.schema.api.query.QueryContext;
import org.bndly.schema.api.query.ValueProvider;
import org.bndly.schema.impl.AccessorImpl;
import org.bndly.schema.impl.EngineImpl;
import org.bndly.schema.impl.persistence.TransactionAppender;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.NamedAttributeHolderAttribute;
import org.bndly.schema.model.UniqueConstraint;

public class UniqueConstraintTableInsert
implements TransactionAppender {
    public static final UniqueConstraintTableInsert INSTANCE = new UniqueConstraintTableInsert();

    @Override
    public void append(Transaction tx, final Record record, EngineImpl engine) {
        this._buildTypeUniqueConstraintInsertQueries(record, new ValueProvider<Long>(){

            public Long get() {
                return record.getId();
            }
        }, tx, engine);
    }

    private void _buildTypeUniqueConstraintInsertQueries(final Record record, ValueProvider<Long> idRef, Transaction transaction, EngineImpl engine) {
        List constraints = engine.getConstraintRegistry().getUniqueConstraintsForType(record.getType());
        if (constraints != null) {
            for (UniqueConstraint uniqueConstraint : constraints) {
                QueryContext qc = engine.getQueryContextFactory().buildQueryContext();
                Insert insert = qc.insert();
                UniqueConstraintTable table = engine.getTableRegistry().getUniqueConstraintTableByConstraint(uniqueConstraint);
                insert.into(table.getTableName());
                List columns = table.getColumns();
                UniqueConstraint constraint = table.getUniqueConstraint();
                List atts = constraint.getAttributes();
                for (Attribute attribute : atts) {
                    AttributeMediator<Attribute> mediator = engine.getMediatorRegistry().getMediatorForAttribute(attribute);
                    if (!mediator.isAttributePresent(record, attribute)) continue;
                    AttributeColumn attributeColumn = null;
                    for (AttributeColumn col : columns) {
                        if (col.getAttribute() != attribute) continue;
                        attributeColumn = col;
                    }
                    if (attributeColumn == null) {
                        throw new IllegalStateException("could not find column for attribute: " + attribute.getName());
                    }
                    AccessorImpl.appendValueToInsert(insert, attributeColumn, record, engine.getMediatorRegistry());
                }
                for (AttributeColumn attributeColumn : table.getHolderColumns()) {
                    NamedAttributeHolderAttribute att = (NamedAttributeHolderAttribute)attributeColumn.getAttribute();
                    if (att.getNamedAttributeHolder() != record.getType()) continue;
                    AttributeMediator<NamedAttributeHolderAttribute> mediator = engine.getMediatorRegistry().getMediatorForAttribute(att);
                    int sqlType = mediator.columnSqlType((Attribute)att);
                    insert.value(attributeColumn.getColumnName(), (ValueProvider)new PreparedStatementValueProvider(){

                        public Long get() {
                            return record.getId();
                        }

                        public void set(int index, PreparedStatement ps) throws SQLException {
                            ps.setLong(index, this.get());
                        }
                    }, sqlType);
                    break;
                }
                Query q = qc.build(record.getContext());
                transaction.getQueryRunner().run(q);
            }
        }
    }
}

