/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.persistence;

import java.util.List;
import org.bndly.schema.api.AttributeMediator;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.Transaction;
import org.bndly.schema.api.db.AttributeColumn;
import org.bndly.schema.api.db.UniqueConstraintTable;
import org.bndly.schema.api.exception.SchemaException;
import org.bndly.schema.api.query.Query;
import org.bndly.schema.api.query.QueryContext;
import org.bndly.schema.api.query.Update;
import org.bndly.schema.api.query.ValueProvider;
import org.bndly.schema.impl.AccessorImpl;
import org.bndly.schema.impl.EngineImpl;
import org.bndly.schema.impl.persistence.TransactionAppender;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.NamedAttributeHolderAttribute;
import org.bndly.schema.model.UniqueConstraint;

public class UniqueConstraintTableReferenceUpdate
implements TransactionAppender {
    public static final UniqueConstraintTableReferenceUpdate INSTANCE = new UniqueConstraintTableReferenceUpdate();

    @Override
    public void append(Transaction tx, Record record, EngineImpl engine) {
        List constraints = engine.getConstraintRegistry().getUniqueConstraintsForType(record.getType());
        if (constraints == null) {
            return;
        }
        block0: for (UniqueConstraint constraint : constraints) {
            List affectedAttributes = constraint.getAttributes();
            for (Attribute affectedAttribute : affectedAttributes) {
                if (!NamedAttributeHolderAttribute.class.isInstance(affectedAttribute)) continue;
                this.scheduleUpdateForConstraint(constraint, tx, record, engine);
                continue block0;
            }
        }
    }

    private void scheduleUpdateForConstraint(UniqueConstraint constraint, Transaction tx, Record record, EngineImpl engine) {
        UniqueConstraintTable table = engine.getTableRegistry().getUniqueConstraintTableByConstraint(constraint);
        QueryContext qc = engine.getQueryContextFactory().buildQueryContext();
        Update update = qc.update();
        update.table(table.getTableName());
        List columns = table.getColumns();
        List atts = constraint.getAttributes();
        boolean shouldRunQuery = false;
        for (Attribute attribute : atts) {
            AttributeMediator<Attribute> mediator = engine.getMediatorRegistry().getMediatorForAttribute(attribute);
            if (!mediator.isAttributePresent(record, attribute)) continue;
            Object value = mediator.getAttributeValue(record, attribute);
            AttributeColumn attributeColumn = null;
            for (AttributeColumn col : columns) {
                if (col.getAttribute() != attribute) continue;
                attributeColumn = col;
            }
            if (attributeColumn == null) {
                throw new SchemaException("could not find column for attribute: " + attribute.getName());
            }
            update.set(attributeColumn.getColumnName(), mediator.createValueProviderFor(record, attribute), mediator.columnSqlType(attribute));
            shouldRunQuery = true;
        }
        if (shouldRunQuery) {
            AttributeColumn col = engine.getConstraintRegistry().getJoinColumnForTypeInUniqueConstraintTable(constraint, record.getType());
            String recordIdField = col.getColumnName();
            update.where().expression().criteria().field(recordIdField).equal().value((ValueProvider)AccessorImpl.createRecordIdPreparedStatementValueProvider(col, record, engine.getMediatorRegistry()));
            Query q = qc.build(record.getContext());
            tx.getQueryRunner().run(q);
        }
    }
}

