/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.persistence;

import java.util.List;
import org.bndly.schema.api.AttributeMediator;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.Transaction;
import org.bndly.schema.api.db.AttributeColumn;
import org.bndly.schema.api.db.UniqueConstraintTable;
import org.bndly.schema.api.query.Query;
import org.bndly.schema.api.query.QueryContext;
import org.bndly.schema.api.query.Update;
import org.bndly.schema.api.query.ValueProvider;
import org.bndly.schema.impl.AccessorImpl;
import org.bndly.schema.impl.EngineImpl;
import org.bndly.schema.impl.persistence.TransactionAppender;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.UniqueConstraint;

public class UniqueConstraintTableUpdate
implements TransactionAppender {
    public static final UniqueConstraintTableUpdate INSTANCE = new UniqueConstraintTableUpdate();

    @Override
    public void append(Transaction tx, Record record, EngineImpl engine) {
        this._buildUniqueConstraintUpdateQueries(record, tx, engine);
    }

    private void _buildUniqueConstraintUpdateQueries(Record record, Transaction transaction, EngineImpl engine) {
        List constraints = engine.getConstraintRegistry().getUniqueConstraintsForType(record.getType());
        if (constraints != null) {
            for (UniqueConstraint uniqueConstraint : constraints) {
                UniqueConstraintTable table = engine.getTableRegistry().getUniqueConstraintTableByConstraint(uniqueConstraint);
                QueryContext qc = engine.getQueryContextFactory().buildQueryContext();
                Update update = qc.update();
                update.table(table.getTableName());
                List columns = table.getColumns();
                UniqueConstraint constraint = table.getUniqueConstraint();
                List atts = constraint.getAttributes();
                boolean shouldRunQuery = false;
                for (Attribute attribute : atts) {
                    AttributeMediator<Attribute> mediator = engine.getMediatorRegistry().getMediatorForAttribute(attribute);
                    if (!mediator.isAttributePresent(record, attribute)) continue;
                    Object value = mediator.getAttributeValue(record, attribute);
                    AttributeColumn attributeColumn = null;
                    for (AttributeColumn col : columns) {
                        if (col.getAttribute() != attribute) continue;
                        attributeColumn = col;
                    }
                    if (attributeColumn == null) {
                        throw new IllegalStateException("could not find column for attribute: " + attribute.getName());
                    }
                    update.set(attributeColumn.getColumnName(), mediator.createValueProviderFor(record, attribute), mediator.columnSqlType(attribute));
                    shouldRunQuery = true;
                }
                if (!shouldRunQuery) continue;
                AttributeColumn col = engine.getConstraintRegistry().getJoinColumnForTypeInUniqueConstraintTable(uniqueConstraint, record.getType());
                String recordIdField = col.getColumnName();
                update.where().expression().criteria().field(recordIdField).equal().value((ValueProvider)AccessorImpl.createRecordIdPreparedStatementValueProvider(col, record, engine.getMediatorRegistry()));
                Query q = qc.build(record.getContext());
                transaction.getQueryRunner().run(q);
            }
        }
    }
}

