/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.query;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.bndly.common.data.io.ReplayableInputStream;
import org.bndly.common.json.model.JSObject;
import org.bndly.common.json.model.JSValue;
import org.bndly.common.json.serializing.JSONSerializer;
import org.bndly.schema.api.ContextRelatedQueryComponent;
import org.bndly.schema.api.PreparedStatementArgumentSetter;
import org.bndly.schema.api.ValueUtil;
import org.bndly.schema.api.query.ValueProvider;
import org.bndly.schema.impl.QueryContextImpl;
import org.bndly.schema.vendor.VendorConfiguration;

public abstract class ContextRelatedQueryComponentImpl
implements ContextRelatedQueryComponent {
    private final QueryContextImpl queryContext;
    private final VendorConfiguration vendorConfiguration;

    public ContextRelatedQueryComponentImpl(QueryContextImpl queryContext, VendorConfiguration vendorConfiguration) {
        if (queryContext == null) {
            throw new IllegalArgumentException("queryContext is not allowed to be null");
        }
        this.queryContext = queryContext;
        if (vendorConfiguration == null) {
            throw new IllegalArgumentException("vendorConfiguration is not allowed to be null");
        }
        this.vendorConfiguration = vendorConfiguration;
    }

    public final QueryContextImpl getQueryContext() {
        return this.queryContext;
    }

    public final VendorConfiguration getVendorConfiguration() {
        return this.vendorConfiguration;
    }

    protected PreparedStatementArgumentSetter createFallbackPreparedStatementArgumentSetter(final ValueProvider valueProvider, final Integer sqlType) {
        if (valueProvider == null) {
            throw new IllegalArgumentException("valueProvider is not allowed to be null");
        }
        return new PreparedStatementArgumentSetter(){

            public void set(int index, PreparedStatement ps) throws SQLException {
                if (sqlType == null) {
                    ps.setObject(index, ValueUtil.unwrapValue((Object)valueProvider));
                } else if (sqlType == 2004 || sqlType == -2) {
                    Object v = ValueUtil.unwrapValue((Object)valueProvider);
                    if (v == null) {
                        ps.setNull(index, sqlType);
                    } else {
                        ReplayableInputStream ris;
                        if (InputStream.class.isInstance(v)) {
                            try {
                                ris = ReplayableInputStream.newInstance((InputStream)((InputStream)v));
                            }
                            catch (IOException ex) {
                                throw new IllegalStateException("could not wrap input stream as replayable input stream: " + ex.getMessage(), ex);
                            }
                        }
                        if (v.getClass().isArray()) {
                            byte[] ba = (byte[])v;
                            ris = ReplayableInputStream.newInstance((byte[])ba);
                        } else if (JSObject.class.isInstance(v)) {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            try {
                                new JSONSerializer().serialize((JSValue)v, (OutputStream)bos, "UTF-8", true);
                            }
                            catch (IOException ex) {
                                throw new SQLException("could not set json value in query.", ex);
                            }
                            byte[] ba = bos.toByteArray();
                            ris = ReplayableInputStream.newInstance((byte[])ba);
                        } else {
                            throw new IllegalStateException("unable to set value for blob field");
                        }
                        ps.setBinaryStream(index, (InputStream)ris);
                    }
                } else {
                    ps.setObject(index, ValueUtil.unwrapValue((Object)valueProvider), sqlType);
                }
            }
        };
    }
}

