/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.query;

import java.util.ArrayList;
import java.util.List;
import org.bndly.schema.api.query.Join;
import org.bndly.schema.api.query.QueryRenderContext;
import org.bndly.schema.api.query.TableExpression;
import org.bndly.schema.impl.QueryContextImpl;
import org.bndly.schema.impl.query.ContextRelatedQueryComponentImpl;
import org.bndly.schema.impl.query.JoinImpl;
import org.bndly.schema.vendor.VendorConfiguration;

public class TableExpressionImpl
extends ContextRelatedQueryComponentImpl
implements TableExpression {
    private String tableName;
    private String tableAlias;
    private final List<Join> joins = new ArrayList<Join>();

    public TableExpressionImpl(QueryContextImpl queryContext, VendorConfiguration vendorConfiguration) {
        super(queryContext, vendorConfiguration);
    }

    public String table() {
        return this.tableName;
    }

    public String alias() {
        return this.tableAlias;
    }

    protected List<Join> getJoins() {
        return this.joins;
    }

    public TableExpression table(String tableName) {
        return this.table(tableName, null);
    }

    public TableExpression table(String tableName, String alias) {
        this.getQueryContext().useTable(tableName, alias);
        this.tableName = tableName;
        this.tableAlias = alias;
        return this;
    }

    public Join join(String tableName) {
        return this.join(tableName, null);
    }

    public Join join(String tableName, String alias) {
        this.getQueryContext().useTable(tableName, alias);
        JoinImpl j = new JoinImpl(this.getQueryContext(), this.getVendorConfiguration());
        j.table(tableName, alias);
        this.joins.add(j);
        return j;
    }

    public void renderQueryFragment(QueryRenderContext ctx) {
        if (this.tableName != null) {
            ctx.getSql().append(' ');
            ctx.getSql().append(this.tableName);
            if (this.tableAlias != null) {
                ctx.getSql().append(' ');
                ctx.getSql().append(this.tableAlias);
            }
            for (Join join : this.joins) {
                join.renderQueryFragment(ctx);
            }
        }
    }
}

