/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.repository;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.Transaction;
import org.bndly.schema.api.repository.RepositoryException;
import org.bndly.schema.api.repository.RepositoryListener;
import org.bndly.schema.api.services.Accessor;
import org.bndly.schema.api.services.Engine;
import org.bndly.schema.impl.repository.RepositoryItem;
import org.bndly.schema.impl.repository.RepositorySessionImpl;
import org.bndly.schema.impl.repository.TransactionItem;

public abstract class AbstractRepositoryItem
implements RepositoryItem {
    private final RepositorySessionImpl session;
    private final Engine engine;
    private final Record record;
    private final RecordContext recordContext;
    private TransactionItem persistItem;
    private TransactionItem removeItem;
    private List<TransactionItem> dependents;

    public AbstractRepositoryItem(RepositorySessionImpl session, Record record, Engine engine, RecordContext recordContext) {
        if (session == null) {
            throw new IllegalArgumentException("session is not allowed to be null");
        }
        this.session = session;
        if (record == null) {
            throw new IllegalArgumentException("record is not allowed to be null");
        }
        this.record = record;
        if (engine == null) {
            throw new IllegalArgumentException("engine is not allowed to be null");
        }
        this.engine = engine;
        if (recordContext == null) {
            throw new IllegalArgumentException("recordContext is not allowed to be null");
        }
        this.recordContext = recordContext;
    }

    protected AbstractRepositoryItem(RepositorySessionImpl session, Engine engine, RecordContext recordContext) {
        this.record = null;
        if (session == null) {
            throw new IllegalArgumentException("session is not allowed to be null");
        }
        this.session = session;
        if (engine == null) {
            throw new IllegalArgumentException("engine is not allowed to be null");
        }
        this.engine = engine;
        if (recordContext == null) {
            throw new IllegalArgumentException("recordContext is not allowed to be null");
        }
        this.recordContext = recordContext;
    }

    public final Record getRecord() {
        return this.record;
    }

    public final RecordContext getRecordContext() {
        return this.recordContext;
    }

    protected final List<RepositoryListener> getRepositoryListeners() {
        return this.getRepositorySession().getListeners();
    }

    protected final ReadWriteLock getRepositoryListenersLock() {
        return this.getRepositorySession().getListenersLock();
    }

    protected final boolean isReadOnly() {
        return this.getRepositorySession().isReadOnly();
    }

    public final void addDependent(TransactionItem item) {
        if (this.dependents == null) {
            this.dependents = new ArrayList<TransactionItem>();
        }
        this.dependents.add(item);
        this.getRepositorySession().addTransactionItem(item);
    }

    public final void removeDependent(TransactionItem item) {
        if (this.dependents == null) {
            return;
        }
        Iterator<TransactionItem> iter = this.dependents.iterator();
        boolean found = false;
        while (iter.hasNext()) {
            TransactionItem next = iter.next();
            if (next != item) continue;
            iter.remove();
            found = true;
        }
        if (this.dependents.isEmpty()) {
            this.dependents = null;
        }
        if (found) {
            this.getRepositorySession().removeTransactionItem(item);
        }
    }

    @Override
    public boolean isTransient() {
        return this.getRecord() != null && this.getRecord().getId() == null;
    }

    @Override
    public final RepositorySessionImpl getRepositorySession() {
        return this.session;
    }

    public final Engine getEngine() {
        return this.engine;
    }

    public final Accessor getAccessor() {
        return this.engine.getAccessor();
    }

    protected final TransactionItem createPersist(final AbstractRepositoryItem parentItem) {
        if (this.removeItem != null) {
            this.removeItem.skip();
            this.removeItem = null;
        }
        if (this.persistItem == null) {
            this.persistItem = new TransactionItem(){
                private boolean skipped;

                @Override
                public void doWithTransaction(Transaction transaction) {
                    if (AbstractRepositoryItem.this.record.getId() == null) {
                        AbstractRepositoryItem.this.getAccessor().buildInsertQuery(AbstractRepositoryItem.this.record, transaction);
                    } else {
                        AbstractRepositoryItem.this.getAccessor().buildUpdateQuery(AbstractRepositoryItem.this.record, transaction);
                    }
                }

                @Override
                public void afterFlush() {
                    AbstractRepositoryItem.this.persistItem = null;
                    AbstractRepositoryItem.this.afterCreate();
                }

                @Override
                public void skip() {
                    this.skipped = true;
                    AbstractRepositoryItem.this.persistItem = null;
                    parentItem.removeDependent(this);
                }

                @Override
                public boolean skipped() {
                    return this.skipped;
                }
            };
            parentItem.addDependent(this.persistItem);
        }
        return this.persistItem;
    }

    protected final TransactionItem createRemovable(final AbstractRepositoryItem parentItem) {
        if (this.persistItem != null) {
            this.persistItem.skip();
            this.persistItem = null;
        }
        if (this.removeItem == null) {
            this.removeItem = new TransactionItem(){
                private boolean skipped;

                @Override
                public void doWithTransaction(Transaction transaction) throws RepositoryException {
                    if (AbstractRepositoryItem.this.record.getId() != null) {
                        AbstractRepositoryItem.this.getAccessor().buildDeleteQuery(AbstractRepositoryItem.this.record, transaction);
                    }
                }

                @Override
                public void afterFlush() {
                    AbstractRepositoryItem.this.removeItem = null;
                    AbstractRepositoryItem.this.afterRemove();
                }

                @Override
                public void skip() {
                    this.skipped = true;
                    AbstractRepositoryItem.this.removeItem = null;
                    parentItem.removeDependent(this);
                }

                @Override
                public boolean skipped() {
                    return this.skipped;
                }
            };
            parentItem.addDependent(this.removeItem);
        }
        return this.removeItem;
    }

    public final boolean isRemovalScheduled() {
        TransactionItem tmp = this.removeItem;
        return tmp != null && !tmp.skipped();
    }

    public final boolean isPersistenceScheduled() {
        TransactionItem tmp = this.persistItem;
        return tmp != null && !tmp.skipped();
    }

    protected void afterRemove() {
    }

    protected void afterCreate() {
    }
}

