/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.repository;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bndly.schema.api.repository.RepositoryException;

public final class ChildManager<E> {
    private final ChildManagingItem childManagingItem;
    private List<E> loadedItems;

    public ChildManager(ChildManagingItem<E> childManagingItem) {
        if (childManagingItem == null) {
            throw new IllegalArgumentException("childManagingItem is not allowed to be null");
        }
        this.childManagingItem = childManagingItem;
    }

    public Iterator<E> getChildren() throws RepositoryException {
        if (this.childManagingItem.isTransient()) {
            return this.childManagingItem.getChildren();
        }
        if (this.loadedItems != null) {
            return this.loadedItems.iterator();
        }
        final ArrayList tmp = new ArrayList();
        final Iterator iter = this.childManagingItem.loadChildren();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                boolean r = iter.hasNext();
                if (!r) {
                    ChildManager.this.loadedItems = tmp;
                }
                return r;
            }

            @Override
            public E next() {
                Object r = iter.next();
                tmp.add(r);
                return r;
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    public static interface ChildManagingItem<E> {
        public boolean isTransient();

        public Iterator<E> loadChildren() throws RepositoryException;

        public Iterator<E> getChildren() throws RepositoryException;
    }
}

