/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.repository;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bndly.schema.api.repository.Repository;
import org.bndly.schema.api.repository.RepositoryException;
import org.bndly.schema.api.repository.RepositoryListener;
import org.bndly.schema.api.repository.RepositorySession;
import org.bndly.schema.api.services.Engine;
import org.bndly.schema.impl.repository.RepositorySessionImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={Repository.class}, immediate=true)
public class RepositoryImpl
implements Repository {
    @Reference(target="(service.pid=org.bndly.schema.api.services.Engine.repository)")
    public Engine engine;
    public final List<RepositoryListener> listeners = new ArrayList<RepositoryListener>();
    private final ReadWriteLock listenersLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositorySession createReadOnlySession() throws RepositoryException {
        RepositorySessionImpl session = new RepositorySessionImpl(true, this.engine, this.engine.getAccessor().buildRecordContext(), this.listeners, this.listenersLock);
        this.listenersLock.readLock().lock();
        try {
            for (RepositoryListener listener : this.listeners) {
                listener.onSessionStart((RepositorySession)session);
            }
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositorySession createAdminSession() throws RepositoryException {
        RepositorySessionImpl session = new RepositorySessionImpl(false, this.engine, this.engine.getAccessor().buildRecordContext(), this.listeners, this.listenersLock);
        this.listenersLock.readLock().lock();
        try {
            for (RepositoryListener listener : this.listeners) {
                listener.onSessionStart((RepositorySession)session);
            }
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
        return session;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    @Reference(bind="addListener", unbind="removeListener", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, service=RepositoryListener.class)
    public void addListener(RepositoryListener listener) {
        if (listener != null) {
            this.listenersLock.writeLock().lock();
            try {
                this.listeners.add(listener);
            }
            finally {
                this.listenersLock.writeLock().unlock();
            }
        }
    }

    public void removeListener(RepositoryListener listener) {
        if (listener != null) {
            this.listenersLock.writeLock().lock();
            try {
                Iterator<RepositoryListener> iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != listener) continue;
                    iterator.remove();
                }
            }
            finally {
                this.listenersLock.writeLock().unlock();
            }
        }
    }
}

