/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.repository;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bndly.common.crypto.api.Base64Service;
import org.bndly.common.data.io.ReplayableInputStream;
import org.bndly.common.json.model.JSArray;
import org.bndly.common.json.model.JSBoolean;
import org.bndly.common.json.model.JSMember;
import org.bndly.common.json.model.JSNull;
import org.bndly.common.json.model.JSNumber;
import org.bndly.common.json.model.JSObject;
import org.bndly.common.json.model.JSString;
import org.bndly.common.json.model.JSValue;
import org.bndly.common.json.parsing.JSONParser;
import org.bndly.common.json.parsing.ParsingException;
import org.bndly.common.json.serializing.JSONSerializer;
import org.bndly.common.json.serializing.JSONWriter;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.repository.Node;
import org.bndly.schema.api.repository.NodeNotFoundException;
import org.bndly.schema.api.repository.Property;
import org.bndly.schema.api.repository.PropertyNotFoundException;
import org.bndly.schema.api.repository.RepositoryException;
import org.bndly.schema.api.repository.RepositoryExporter;
import org.bndly.schema.api.repository.RepositoryImporter;
import org.bndly.schema.api.repository.RepositorySession;
import org.bndly.schema.impl.repository.RepositorySessionImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RepositoryImporter.class, RepositoryExporter.class})
@Designate(ocd=Configuration.class)
public class RepositoryImporterImpl
implements RepositoryImporter,
RepositoryExporter {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryImporterImpl.class);
    @Reference
    private Base64Service base64Service;
    private static final FilePathStrategy ROOT_NODE_PATH_STRATEGY = new FilePathStrategy(){

        @Override
        public Path getFilePath(Node node, Path rootPath) {
            return rootPath.resolve("root.json");
        }
    };
    private static final FilePathStrategy NODE_PATH_STRATEGY = new FilePathStrategy(){

        @Override
        public Path getFilePath(Node node, Path rootPath) {
            Path p = rootPath;
            List elements = node.getPath().getElementNames();
            for (int i = 0; i < elements.size(); ++i) {
                String nodePathElement = (String)elements.get(i);
                p = i == elements.size() - 1 ? p.resolve(nodePathElement + ".json") : p.resolve(nodePathElement);
            }
            return p;
        }
    };
    private final Transformer stringTransformer = new Transformer(){

        @Override
        public Object transform(JSValue value, Property.Type desiredType, RecordContext recordContext) {
            if (desiredType != Property.Type.STRING) {
                return null;
            }
            if (JSNull.class.isInstance(value)) {
                return null;
            }
            if (JSString.class.isInstance(value)) {
                return ((JSString)value).getValue();
            }
            return null;
        }

        @Override
        public void writeToJson(Property property, Object value, JSONWriter writer, Writer originalWriter) throws IOException {
            if (value == null) {
                writer.writeNull();
            } else {
                writer.writeString((String)value);
            }
        }
    };
    private final Transformer longTransformer = new Transformer(){

        @Override
        public Object transform(JSValue value, Property.Type desiredType, RecordContext recordContext) {
            if (desiredType != Property.Type.LONG) {
                return null;
            }
            if (JSNull.class.isInstance(value)) {
                return null;
            }
            if (JSNumber.class.isInstance(value)) {
                return ((JSNumber)value).getValue().longValue();
            }
            return null;
        }

        @Override
        public void writeToJson(Property property, Object value, JSONWriter writer, Writer originalWriter) throws IOException {
            if (value == null) {
                writer.writeNull();
            } else {
                writer.writeLong(((Long)value).longValue());
            }
        }
    };
    private final Transformer doubleTransformer = new Transformer(){

        @Override
        public Object transform(JSValue value, Property.Type desiredType, RecordContext recordContext) {
            if (desiredType != Property.Type.DOUBLE) {
                return null;
            }
            if (JSNull.class.isInstance(value)) {
                return null;
            }
            if (JSNumber.class.isInstance(value)) {
                return ((JSNumber)value).getValue().doubleValue();
            }
            return null;
        }

        @Override
        public void writeToJson(Property property, Object value, JSONWriter writer, Writer originalWriter) throws IOException {
            if (value == null) {
                writer.writeNull();
            } else {
                writer.writeDouble(((Double)value).doubleValue());
            }
        }
    };
    private final Transformer decimalTransformer = new Transformer(){

        @Override
        public Object transform(JSValue value, Property.Type desiredType, RecordContext recordContext) {
            if (desiredType != Property.Type.DECIMAL) {
                return null;
            }
            if (JSNull.class.isInstance(value)) {
                return null;
            }
            if (JSNumber.class.isInstance(value)) {
                return ((JSNumber)value).getValue();
            }
            return null;
        }

        @Override
        public void writeToJson(Property property, Object value, JSONWriter writer, Writer originalWriter) throws IOException {
            if (value == null) {
                writer.writeNull();
            } else {
                writer.writeDecimal((BigDecimal)value);
            }
        }
    };
    private final Transformer dateTransformer = new Transformer(){

        @Override
        public Object transform(JSValue value, Property.Type desiredType, RecordContext recordContext) {
            if (desiredType != Property.Type.DATE) {
                return null;
            }
            if (JSNull.class.isInstance(value)) {
                return null;
            }
            if (JSNumber.class.isInstance(value)) {
                return new Date(((JSNumber)value).getValue().longValue());
            }
            return null;
        }

        @Override
        public void writeToJson(Property property, Object value, JSONWriter writer, Writer originalWriter) throws IOException {
            if (value == null) {
                writer.writeNull();
            } else {
                writer.writeLong(((Date)value).getTime());
            }
        }
    };
    private final Transformer booleanTransformer = new Transformer(){

        @Override
        public Object transform(JSValue value, Property.Type desiredType, RecordContext recordContext) {
            if (desiredType != Property.Type.BOOLEAN) {
                return null;
            }
            if (JSNull.class.isInstance(value)) {
                return null;
            }
            if (JSBoolean.class.isInstance(value)) {
                return ((JSBoolean)value).isValue();
            }
            return null;
        }

        @Override
        public void writeToJson(Property property, Object value, JSONWriter writer, Writer originalWriter) throws IOException {
            if (value == null) {
                writer.writeNull();
            } else if (((Boolean)value).booleanValue()) {
                writer.writeTrue();
            } else {
                writer.writeFalse();
            }
        }
    };
    private final Transformer binaryTransformer = new Transformer(){

        @Override
        public Object transform(JSValue value, Property.Type desiredType, RecordContext recordContext) {
            if (desiredType != Property.Type.BINARY) {
                return null;
            }
            if (JSNull.class.isInstance(value)) {
                return null;
            }
            if (JSString.class.isInstance(value)) {
                String base64String = ((JSString)value).getValue();
                if (RepositoryImporterImpl.this.base64Service == null) {
                    return null;
                }
                byte[] bytes = RepositoryImporterImpl.this.base64Service.base64Decode(base64String);
                return ReplayableInputStream.newInstance((byte[])bytes);
            }
            return null;
        }

        @Override
        public void writeToJson(Property property, Object value, JSONWriter writer, Writer originalWriter) throws IOException {
            if (value == null || RepositoryImporterImpl.this.base64Service == null) {
                writer.writeNull();
            } else {
                originalWriter.write("\"");
                RepositoryImporterImpl.this.base64Service.base64EncodeStream((InputStream)value, originalWriter);
                originalWriter.write("\"");
            }
        }
    };
    private final Transformer entityTransformer = new Transformer(){

        @Override
        public Object transform(JSValue value, Property.Type desiredType, RecordContext recordContext) {
            if (recordContext == null) {
                return null;
            }
            if (desiredType != Property.Type.ENTITY) {
                return null;
            }
            if (JSNull.class.isInstance(value)) {
                return null;
            }
            if (JSString.class.isInstance(value)) {
                String string = ((JSString)value).getValue();
                int i = string.indexOf(";");
                if (i < 1) {
                    return null;
                }
                String typeName = string.substring(0, i);
                String id = string.substring(i + 1);
                try {
                    Long idLong = Long.valueOf(id);
                    return recordContext.create(typeName, idLong.longValue());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public void writeToJson(Property property, Object value, JSONWriter writer, Writer originalWriter) throws IOException {
            if (value == null || RepositoryImporterImpl.this.base64Service == null) {
                writer.writeNull();
            } else {
                Record record = (Record)value;
                if (record.getId() == null) {
                    writer.writeNull();
                } else {
                    writer.writeString(record.getType().getName() + ";" + record.getId());
                }
            }
        }
    };
    private static final JSArray EMPTY_JSON_ARRAY = new JSArray();
    private static final JSObject EMPTY_JSON_OBJECT = new JSObject();
    private static final JSONSerializer JSON_SERIALIZER = new JSONSerializer();

    public void importRepositoryData(Path rootFile, RepositorySession repositorySession) throws RepositoryException {
        this.importFile(rootFile, null, null, repositorySession);
    }

    public void exportRepositoryData(Path outputFolder, RepositorySession repositorySession) throws RepositoryException {
        try {
            if (Files.notExists(outputFolder, new LinkOption[0])) {
                Files.createDirectory(outputFolder, new FileAttribute[0]);
            }
            Node root = repositorySession.getRoot();
            this.exportToFile(root, ROOT_NODE_PATH_STRATEGY.getFilePath(root, outputFolder), outputFolder);
        }
        catch (IOException e) {
            throw new RepositoryException("failed to export repository: " + e.getMessage(), (Throwable)e);
        }
    }

    private void exportToFile(Node node, Path pathToFile, Path outputFolder) throws IOException, RepositoryException {
        Files.deleteIfExists(pathToFile);
        Path parent = pathToFile.getParent();
        if (parent != null && Files.notExists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Files.createFile(pathToFile, new FileAttribute[0]);
        Iterator childNodes = node.getChildren();
        JSObject jsonChildNodes = new JSObject();
        boolean hasChildren = false;
        while (childNodes.hasNext()) {
            Node next = (Node)childNodes.next();
            hasChildren = true;
            jsonChildNodes.createMember(next.getName()).setValue((JSValue)(next.getType().equals("cy:array") ? EMPTY_JSON_ARRAY : EMPTY_JSON_OBJECT));
            Path childNodePath = NODE_PATH_STRATEGY.getFilePath(next, outputFolder);
            this.exportToFile(next, childNodePath, outputFolder);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(pathToFile, Charset.forName("UTF-8"), StandardOpenOption.WRITE);){
            JSONWriter jsonWriter = new JSONWriter((Writer)writer);
            jsonWriter.writeObjectStart().writeString("type").writeColon().writeString(node.getType());
            Iterator properties = node.getProperties();
            if (properties.hasNext()) {
                jsonWriter.writeComma().writeString("properties").writeColon().writeObjectStart();
                boolean first = true;
                while (properties.hasNext()) {
                    Property property = (Property)properties.next();
                    if (!first) {
                        jsonWriter.writeComma();
                    }
                    jsonWriter.writeString(property.getName() + "@" + property.getType().toString()).writeColon();
                    this.exportPropertyValueToJson(property, jsonWriter, writer);
                    first = false;
                }
                jsonWriter.writeObjectEnd();
            }
            if (hasChildren) {
                jsonWriter.writeComma().writeString("children").writeColon();
                JSON_SERIALIZER.serialize((JSValue)jsonChildNodes, (Writer)writer);
            }
            jsonWriter.writeObjectEnd();
            ((Writer)writer).flush();
        }
    }

    private void exportPropertyValueToJson(Property property, JSONWriter jsonWriter, Writer writer) throws RepositoryException, IOException {
        Transformer transformer;
        Property.Type type = property.getType();
        boolean isMulti = property.isMultiValued();
        switch (type) {
            case BINARY: {
                transformer = this.binaryTransformer;
                break;
            }
            case BOOLEAN: {
                transformer = this.booleanTransformer;
                break;
            }
            case DATE: {
                transformer = this.dateTransformer;
                break;
            }
            case DECIMAL: {
                transformer = this.decimalTransformer;
                break;
            }
            case DOUBLE: {
                transformer = this.doubleTransformer;
                break;
            }
            case ENTITY: {
                transformer = this.entityTransformer;
                break;
            }
            case LONG: {
                transformer = this.longTransformer;
                break;
            }
            case STRING: {
                transformer = this.stringTransformer;
                break;
            }
            default: {
                throw new RepositoryException("unsupported property type: " + type);
            }
        }
        if (isMulti) {
            jsonWriter.writeArrayStart();
            boolean first = true;
            Object[] values = property.getValues();
            if (values != null) {
                for (Object value : values) {
                    if (!first) {
                        jsonWriter.writeComma();
                    }
                    transformer.writeToJson(property, value, jsonWriter, writer);
                    first = false;
                }
            }
            jsonWriter.writeArrayEnd();
        } else {
            transformer.writeToJson(property, property.getValue(), jsonWriter, writer);
        }
    }

    private void importFile(Path file, String nodeName, Node parentNode, RepositorySession repositorySession) throws RepositoryException {
        try {
            Node targetNode;
            JSObject jsonRoot = null;
            try (InputStream is = Files.newInputStream(file, StandardOpenOption.READ);){
                try {
                    JSValue parsed = new JSONParser().parse(is, "UTF-8");
                    if (JSObject.class.isInstance(parsed)) {
                        jsonRoot = (JSObject)parsed;
                    }
                }
                catch (ParsingException e) {
                    LOG.error("failed to parse file with data for node " + nodeName + ": " + e.getMessage(), (Throwable)e);
                }
            }
            catch (NoSuchFileException e) {
                LOG.warn("skipping import of node {} at path {} because the source file was missing.", (Object)nodeName, (Object)(parentNode != null ? parentNode.getPath() : null));
                return;
            }
            if (jsonRoot == null) {
                return;
            }
            if (nodeName == null) {
                targetNode = repositorySession.getRoot();
            } else {
                if (parentNode == null) {
                    throw new RepositoryException("missing parent node");
                }
                try {
                    targetNode = parentNode.getChild(nodeName);
                }
                catch (NodeNotFoundException e) {
                    String childNodeType = jsonRoot.getMemberStringValue("type");
                    if (childNodeType == null) {
                        throw new RepositoryException("could not find node " + nodeName + " in " + parentNode.getPath().toString() + " and there was no node type in the import data");
                    }
                    targetNode = parentNode.createChild(nodeName, childNodeType);
                }
            }
            this.importToNode(jsonRoot, targetNode, repositorySession, file);
        }
        catch (IOException e) {
            throw new RepositoryException("failed to iterate import data from path " + file.toString(), (Throwable)e);
        }
    }

    private void importToNode(JSObject jsonRoot, Node target, RepositorySession repositorySession, Path currentFile) throws RepositoryException {
        String type;
        if (jsonRoot != null && (type = jsonRoot.getMemberStringValue("type")) != null) {
            JSObject properties = (JSObject)jsonRoot.getMemberValue("properties", JSObject.class);
            this.importPropertiesToNode(properties, target);
            JSObject children = (JSObject)jsonRoot.getMemberValue("children", JSObject.class);
            this.importChildren(children, target, currentFile, repositorySession);
        }
    }

    private void importPropertiesToNode(JSObject properties, Node target) throws RepositoryException {
        if (properties == null) {
            return;
        }
        Set members = properties.getMembers();
        if (members == null || members.isEmpty()) {
            return;
        }
        for (JSMember member : members) {
            String propertyName = member.getName().getValue();
            JSValue propertyValue = member.getValue();
            this.importProperty(propertyName, propertyValue, target);
        }
    }

    private void importProperty(String propertyName, JSValue propertyValue, Node target) throws RepositoryException {
        Object[] value;
        Property.Type type;
        Property propertyTmp;
        RepositorySession repositorySession = target.getRepositorySession();
        RecordContext recordContext = null;
        if (RepositorySessionImpl.class.isInstance(repositorySession)) {
            recordContext = ((RepositorySessionImpl)repositorySession).getRecordContext();
        }
        boolean isMulti = JSArray.class.isInstance(propertyValue);
        String propertyNameTidy = this.tidyUpPropertyName(propertyName);
        try {
            propertyTmp = target.getProperty(propertyNameTidy);
            type = propertyTmp.getType();
        }
        catch (PropertyNotFoundException ex) {
            type = this.mapPropertyNameToType(propertyName, this.mapPropertyValueToType(propertyValue));
            propertyTmp = isMulti ? target.createMultiProperty(propertyNameTidy, type) : target.createProperty(propertyNameTidy, type);
        }
        switch (type) {
            case BINARY: {
                if (isMulti) {
                    Object[] values = new Object[((JSArray)propertyValue).size()];
                    for (int i = 0; i < ((JSArray)propertyValue).size(); ++i) {
                        JSValue item = (JSValue)((JSArray)propertyValue).getItems().get(i);
                        values[i] = this.binaryTransformer.transform(item, type, recordContext);
                    }
                    value = values;
                    break;
                }
                value = this.binaryTransformer.transform(propertyValue, type, recordContext);
                break;
            }
            case BOOLEAN: {
                if (isMulti) {
                    Object[] values = new Object[((JSArray)propertyValue).size()];
                    for (int i = 0; i < ((JSArray)propertyValue).size(); ++i) {
                        JSValue item = (JSValue)((JSArray)propertyValue).getItems().get(i);
                        values[i] = this.booleanTransformer.transform(item, type, recordContext);
                    }
                    value = values;
                    break;
                }
                value = this.booleanTransformer.transform(propertyValue, type, recordContext);
                break;
            }
            case DATE: {
                if (isMulti) {
                    Object[] values = new Object[((JSArray)propertyValue).size()];
                    for (int i = 0; i < ((JSArray)propertyValue).size(); ++i) {
                        JSValue item = (JSValue)((JSArray)propertyValue).getItems().get(i);
                        values[i] = this.dateTransformer.transform(item, type, recordContext);
                    }
                    value = values;
                    break;
                }
                value = this.dateTransformer.transform(propertyValue, type, recordContext);
                break;
            }
            case DECIMAL: {
                if (isMulti) {
                    Object[] values = new Object[((JSArray)propertyValue).size()];
                    for (int i = 0; i < ((JSArray)propertyValue).size(); ++i) {
                        JSValue item = (JSValue)((JSArray)propertyValue).getItems().get(i);
                        values[i] = this.decimalTransformer.transform(item, type, recordContext);
                    }
                    value = values;
                    break;
                }
                value = this.decimalTransformer.transform(propertyValue, type, recordContext);
                break;
            }
            case DOUBLE: {
                if (isMulti) {
                    Object[] values = new Object[((JSArray)propertyValue).size()];
                    for (int i = 0; i < ((JSArray)propertyValue).size(); ++i) {
                        JSValue item = (JSValue)((JSArray)propertyValue).getItems().get(i);
                        values[i] = this.doubleTransformer.transform(item, type, recordContext);
                    }
                    value = values;
                    break;
                }
                value = this.doubleTransformer.transform(propertyValue, type, recordContext);
                break;
            }
            case ENTITY: {
                if (isMulti) {
                    Object[] values = new Object[((JSArray)propertyValue).size()];
                    for (int i = 0; i < ((JSArray)propertyValue).size(); ++i) {
                        JSValue item = (JSValue)((JSArray)propertyValue).getItems().get(i);
                        values[i] = this.entityTransformer.transform(item, type, recordContext);
                    }
                    value = values;
                    break;
                }
                value = this.entityTransformer.transform(propertyValue, type, recordContext);
                break;
            }
            case LONG: {
                if (isMulti) {
                    Object[] values = new Object[((JSArray)propertyValue).size()];
                    for (int i = 0; i < ((JSArray)propertyValue).size(); ++i) {
                        JSValue item = (JSValue)((JSArray)propertyValue).getItems().get(i);
                        values[i] = this.longTransformer.transform(item, type, recordContext);
                    }
                    value = values;
                    break;
                }
                value = this.longTransformer.transform(propertyValue, type, recordContext);
                break;
            }
            case STRING: {
                if (isMulti) {
                    Object[] values = new Object[((JSArray)propertyValue).size()];
                    for (int i = 0; i < ((JSArray)propertyValue).size(); ++i) {
                        JSValue item = (JSValue)((JSArray)propertyValue).getItems().get(i);
                        values[i] = this.stringTransformer.transform(item, type, recordContext);
                    }
                    value = values;
                    break;
                }
                value = this.stringTransformer.transform(propertyValue, type, recordContext);
                break;
            }
            default: {
                throw new RepositoryException("unsupported property type: " + type);
            }
        }
        if (isMulti) {
            propertyTmp.setValues(value);
        } else {
            propertyTmp.setValue((Object)value);
        }
    }

    private Property.Type mapPropertyNameToType(String propertyName, Property.Type defaultType) {
        int i = propertyName.indexOf("@");
        if (i > -1) {
            String typeHint = propertyName.substring(i + 1);
            Property.Type type = Property.Type.valueOf((String)typeHint);
            if (type == null) {
                return defaultType;
            }
            return type;
        }
        return defaultType;
    }

    private String tidyUpPropertyName(String propertyName) {
        int i = propertyName.indexOf("@");
        if (i > -1) {
            return propertyName.substring(0, i);
        }
        return propertyName;
    }

    private Property.Type mapPropertyValueToType(JSValue propertyValue) {
        if (JSNull.class.isInstance(propertyValue)) {
            return null;
        }
        if (JSArray.class.isInstance(propertyValue)) {
            JSArray array = (JSArray)propertyValue;
            Iterator iterator = array.iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            return this.mapPropertyValueToType((JSValue)iterator.next());
        }
        if (JSString.class.isInstance(propertyValue)) {
            return Property.Type.STRING;
        }
        if (JSNumber.class.isInstance(propertyValue)) {
            JSNumber number = (JSNumber)propertyValue;
            BigDecimal val = number.getValue();
            if (val.scale() > 0) {
                return Property.Type.DECIMAL;
            }
            return Property.Type.LONG;
        }
        if (JSBoolean.class.isInstance(propertyValue)) {
            return Property.Type.BOOLEAN;
        }
        return null;
    }

    private void importChildren(JSObject children, Node parentNode, Path parentImportFile, final RepositorySession repositorySession) throws RepositoryException {
        if (children == null) {
            return;
        }
        Set members = children.getMembers();
        if (members == null) {
            return;
        }
        for (JSMember member : members) {
            String childName = member.getName().getValue();
            JSValue childValue = member.getValue();
            boolean isArray = JSArray.class.isInstance(childValue);
            Path childPath = this.getChildPath(parentNode, parentImportFile, childName);
            if (isArray) {
                if (Files.notExists(childPath, new LinkOption[0])) {
                    Node itemParentTmp;
                    final Path itemFolder = parentImportFile.resolveSibling(childName);
                    if (!Files.isDirectory(itemFolder, new LinkOption[0])) continue;
                    try {
                        itemParentTmp = parentNode.getChild(childName);
                    }
                    catch (NodeNotFoundException e) {
                        itemParentTmp = parentNode.createChild(childName, "cy:array");
                    }
                    final Node itemParent = itemParentTmp;
                    try {
                        Files.walkFileTree(itemFolder, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                if (dir.equals(itemFolder)) {
                                    return FileVisitResult.CONTINUE;
                                }
                                return FileVisitResult.SKIP_SUBTREE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                String nodeName = RepositoryImporterImpl.this.getNodeNameFromFileName(file);
                                if (nodeName == null) {
                                    return FileVisitResult.CONTINUE;
                                }
                                try {
                                    RepositoryImporterImpl.this.importFile(file, nodeName, itemParent, repositorySession);
                                }
                                catch (RepositoryException ex) {
                                    throw new IOException("could not import data from " + file.toString(), ex);
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                                return FileVisitResult.TERMINATE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }
                        });
                        continue;
                    }
                    catch (IOException e) {
                        throw new RepositoryException("failed to import items of array node", (Throwable)e);
                    }
                }
                this.importFile(childPath, childName, parentNode, repositorySession);
                continue;
            }
            this.importFile(childPath, childName, parentNode, repositorySession);
        }
    }

    private Path getChildPath(Node parentNode, Path parentImportFile, String childNodeName) {
        Path childPath = "cy:root".equals(parentNode.getType()) ? parentImportFile.resolveSibling(childNodeName + ".json") : parentImportFile.resolveSibling(parentNode.getName()).resolve(childNodeName + ".json");
        return childPath;
    }

    private String getNodeNameFromFileName(Path path) {
        Path file = path.getFileName();
        if (file == null) {
            return null;
        }
        String fileNameString = file.toString();
        if (fileNameString == null || !fileNameString.endsWith(".json")) {
            return null;
        }
        fileNameString = fileNameString.substring(0, fileNameString.length() - ".json".length());
        return fileNameString;
    }

    public void setBase64Service(Base64Service base64Service) {
        this.base64Service = base64Service;
    }

    private static interface FilePathStrategy {
        public Path getFilePath(Node var1, Path var2);
    }

    private static interface Transformer {
        public Object transform(JSValue var1, Property.Type var2, RecordContext var3);

        public void writeToJson(Property var1, Object var2, JSONWriter var3, Writer var4) throws IOException;
    }

    @ObjectClassDefinition(name="Repository Importer", description="This importer imports JSON file structures into a repository")
    public static @interface Configuration {
    }
}

