/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.Transaction;
import org.bndly.schema.api.exception.SchemaException;
import org.bndly.schema.api.repository.EntityReference;
import org.bndly.schema.api.repository.Node;
import org.bndly.schema.api.repository.NodeNotFoundException;
import org.bndly.schema.api.repository.Path;
import org.bndly.schema.api.repository.RepositoryException;
import org.bndly.schema.api.repository.RepositoryListener;
import org.bndly.schema.api.repository.RepositorySession;
import org.bndly.schema.api.services.Engine;
import org.bndly.schema.impl.repository.EntityReferenceImpl;
import org.bndly.schema.impl.repository.NodeImpl;
import org.bndly.schema.impl.repository.TransactionItem;

public final class RepositorySessionImpl
implements RepositorySession {
    private final boolean readOnly;
    private final Engine engine;
    private final RecordContext recordContext;
    private final List<TransactionItem> transactionItems = new ArrayList<TransactionItem>();
    private final List<RepositoryListener> listeners;
    private final ReadWriteLock listenersLock;
    private Node root;

    public RepositorySessionImpl(boolean readOnly, Engine engine, RecordContext recordContext, List<RepositoryListener> listeners, ReadWriteLock lock) {
        if (engine == null) {
            throw new IllegalArgumentException("engine is not allowed to be null");
        }
        this.engine = engine;
        if (recordContext == null) {
            throw new IllegalArgumentException("recordContext is not allowed to be null");
        }
        this.recordContext = recordContext;
        if (listeners == null) {
            listeners = Collections.EMPTY_LIST;
        }
        this.listeners = listeners;
        this.listenersLock = lock;
        this.readOnly = readOnly;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public void close() throws RepositoryException {
        this.listenersLock.readLock().lock();
        try {
            for (RepositoryListener listener : this.listeners) {
                listener.onSessionEnd((RepositorySession)this);
            }
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
    }

    public List<RepositoryListener> getListeners() {
        return this.listeners;
    }

    public ReadWriteLock getListenersLock() {
        return this.listenersLock;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public RecordContext getRecordContext() {
        return this.recordContext;
    }

    public EntityReference createEntityReference(String typeName, long id) throws RepositoryException {
        Record record = this.recordContext.create(typeName, id);
        return new EntityReferenceImpl(record);
    }

    public Node getRoot() throws RepositoryException {
        if (this.root == null) {
            this.root = NodeImpl.createRootNode(this.recordContext, this, this.engine);
        }
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositorySession flush() throws RepositoryException {
        this.listenersLock.readLock().lock();
        try {
            for (RepositoryListener repositoryListener : this.listeners) {
                repositoryListener.onBeforeFlush((RepositorySession)this);
            }
            Transaction tx = this.engine.getQueryRunner().createTransaction();
            for (TransactionItem transactionItem : this.transactionItems) {
                transactionItem.doWithTransaction(tx);
            }
            try {
                tx.commit();
                for (TransactionItem transactionItem : this.transactionItems) {
                    transactionItem.afterFlush();
                }
                this.transactionItems.clear();
                for (RepositoryListener listener : this.listeners) {
                    listener.onFlushSuccess((RepositorySession)this);
                }
            }
            catch (SchemaException schemaException) {
                for (RepositoryListener listener : this.listeners) {
                    listener.onFlushFailure((RepositorySession)this);
                }
                throw new RepositoryException("could not flush repository session: " + schemaException.getMessage(), (Throwable)schemaException);
            }
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
        return this;
    }

    public void addTransactionItem(TransactionItem item) {
        this.transactionItems.add(item);
    }

    public void removeTransactionItem(TransactionItem item) {
        Iterator<TransactionItem> iterator = this.transactionItems.iterator();
        while (iterator.hasNext()) {
            TransactionItem next = iterator.next();
            if (next != item) continue;
            iterator.remove();
        }
    }

    public Node getNode(Path path) throws NodeNotFoundException, RepositoryException {
        Node rootNode;
        Node current = rootNode = this.getRoot();
        for (String elementName : path.getElementNames()) {
            current = current.getChild(elementName);
        }
        return current;
    }
}

