/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.repository;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Date;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.repository.EntityReference;
import org.bndly.schema.api.repository.IndexedItem;
import org.bndly.schema.api.repository.ModificationNotAllowedException;
import org.bndly.schema.api.repository.Property;
import org.bndly.schema.api.repository.RepositoryException;
import org.bndly.schema.api.services.Engine;
import org.bndly.schema.impl.repository.AbstractRepositoryItem;
import org.bndly.schema.impl.repository.PropertyImpl;
import org.bndly.schema.impl.repository.RepositorySessionImpl;
import org.bndly.schema.model.StringAttribute;

public final class Value
extends AbstractRepositoryItem
implements IndexedItem {
    private final PropertyImpl property;
    private Object value;
    private long index;

    public Value(PropertyImpl property, RepositorySessionImpl repository, Record record, Engine engine, RecordContext recordContext) {
        super(repository, record, engine, recordContext);
        if (property == null) {
            throw new IllegalArgumentException("property is not allowed to be null");
        }
        this.property = property;
        if (property.getType() == Property.Type.STRING) {
            Boolean isText = (Boolean)this.getRecord().getAttributeValue("isText", Boolean.class);
            this.value = isText != null && isText.booleanValue() ? this.getRecord().getAttributeValue("textValue", String.class) : this.getRecord().getAttributeValue("stringValue", String.class);
        } else if (property.getType() == Property.Type.DECIMAL) {
            this.value = this.getRecord().getAttributeValue("decimalValue", BigDecimal.class);
        } else if (property.getType() == Property.Type.LONG) {
            this.value = this.getRecord().getAttributeValue("longValue", Long.class);
        } else if (property.getType() == Property.Type.DOUBLE) {
            this.value = this.getRecord().getAttributeValue("doubleValue", Double.class);
        } else if (property.getType() == Property.Type.DATE) {
            this.value = this.getRecord().getAttributeValue("dateValue", Date.class);
        } else if (property.getType() == Property.Type.BOOLEAN) {
            this.value = this.getRecord().getAttributeValue("booleanValue", Boolean.class);
        } else if (property.getType() == Property.Type.BINARY) {
            this.value = this.getRecord().getAttributeValue("binaryValue", InputStream.class);
        } else if (property.getType() == Property.Type.ENTITY) {
            this.value = this.getRecord().getAttributeValue("entityValue", Record.class);
        } else {
            throw new IllegalStateException("unsupported property type");
        }
        this.index = (Long)record.getAttributeValue("parentIndex", Long.class);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (this.property.getType() == Property.Type.STRING) {
            String stringValue = (String)value;
            Integer maxLength = ((StringAttribute)this.getRecord().getAttributeDefinition("stringValue", StringAttribute.class)).getLength();
            if (stringValue != null && maxLength != null && stringValue.length() > maxLength) {
                this.getRecord().setAttributeValue("stringValue", null);
                this.getRecord().setAttributeValue("textValue", (Object)stringValue);
                this.getRecord().setAttributeValue("isText", (Object)true);
            } else {
                this.getRecord().setAttributeValue("stringValue", (Object)stringValue);
                this.getRecord().setAttributeValue("textValue", null);
                this.getRecord().setAttributeValue("isText", (Object)false);
            }
        } else if (this.property.getType() == Property.Type.DECIMAL) {
            this.getRecord().setAttributeValue("decimalValue", value);
        } else if (this.property.getType() == Property.Type.LONG) {
            this.getRecord().setAttributeValue("longValue", value);
        } else if (this.property.getType() == Property.Type.DOUBLE) {
            this.getRecord().setAttributeValue("doubleValue", value);
        } else if (this.property.getType() == Property.Type.DATE) {
            this.getRecord().setAttributeValue("dateValue", value);
        } else if (this.property.getType() == Property.Type.BOOLEAN) {
            this.getRecord().setAttributeValue("booleanValue", value);
        } else if (this.property.getType() == Property.Type.BINARY) {
            this.getRecord().setAttributeValue("binaryValue", value);
        } else if (this.property.getType() == Property.Type.ENTITY) {
            Record recordValue;
            if (EntityReference.class.isInstance(value)) {
                EntityReference er = (EntityReference)value;
                value = this.getRecordContext().create(er.getType(), er.getId());
            }
            if (Record.class.isInstance(value) && (recordValue = (Record)value).getContext() != this.getRecordContext()) {
                Long id = recordValue.getId();
                if (id == null) {
                    throw new IllegalArgumentException("provided entity value is from a different recordContext and the ID is null.");
                }
                Record copy = this.getRecordContext().create(recordValue.getType().getName(), id.longValue());
                copy.setIsReference(true);
                value = copy;
            }
            this.getRecord().setAttributeValue("entityValue", value);
        } else {
            throw new IllegalStateException("unsupported property type");
        }
        this.value = value;
    }

    @Override
    public void remove() throws RepositoryException {
        this.createRemovable(this.property);
    }

    @Override
    protected void afterRemove() {
        this.property.dropValue(this);
    }

    public long getIndex() {
        return this.index;
    }

    public void moveToIndex(long index) throws RepositoryException {
        if (this.isReadOnly()) {
            throw new ModificationNotAllowedException("values can not be moved in read only sessions");
        }
        this.property.moveValueToIndex(this, index);
    }

    public PropertyImpl getProperty() {
        return this.property;
    }

    public void setIndex(long index) throws RepositoryException {
        if (this.isReadOnly()) {
            throw new ModificationNotAllowedException("values can not be moved in read only sessions");
        }
        if (index != this.index) {
            this.index = index;
            this.getRecord().setAttributeValue("parentIndex", (Object)index);
            if (!this.isTransient()) {
                this.createPersist(this.property);
            }
        }
    }
}

