/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.repository.beans;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bndly.schema.api.repository.Node;
import org.bndly.schema.api.repository.NodeNotFoundException;
import org.bndly.schema.api.repository.PathBuilder;
import org.bndly.schema.api.repository.Property;
import org.bndly.schema.api.repository.PropertyNotFoundException;
import org.bndly.schema.api.repository.RepositoryException;
import org.bndly.schema.api.repository.RepositorySession;
import org.bndly.schema.api.repository.beans.Bean;
import org.bndly.schema.api.repository.beans.BeanFactory;
import org.bndly.schema.api.repository.beans.BeanResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={BeanFactory.class})
@Designate(ocd=Configuration.class)
public class BeanFactoryImpl
implements BeanFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BeanFactoryImpl.class);

    public Bean createBeanFromNode(Node node) {
        BeanResolver beanResolver = this.createBeanResolver(node.getRepositorySession());
        return this.createBeanFromNode(node, beanResolver);
    }

    public Bean createBeanFromNode(final Node node, final BeanResolver beanResolver) {
        String beanType;
        if (!"cy:bean".equals(node.getType())) {
            return null;
        }
        try {
            beanType = node.getProperty("beanType").getString();
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            LOG.error("could not get beanType from bean node: " + e.getMessage(), (Throwable)e);
            return null;
        }
        if (beanType == null) {
            return null;
        }
        return new Bean(){
            private Map<String, Object> properties;
            private boolean didLoadAllProperties;
            private boolean didInitParent;
            private Bean parent;

            public String getName() {
                return node.getName();
            }

            public String getPath() {
                return node.getPath().toString();
            }

            public Bean getParent() {
                if (this.didInitParent) {
                    return this.parent;
                }
                this.didInitParent = true;
                try {
                    Node parentNode = node.getParent();
                    this.parent = BeanFactoryImpl.this.createBeanFromNode(parentNode, beanResolver);
                }
                catch (RepositoryException ex) {
                    LOG.error("could not get parent bean: " + ex.getMessage(), (Throwable)ex);
                }
                return this.parent;
            }

            public String getBeanType() {
                return beanType;
            }

            public Bean getChild(String name) {
                try {
                    return BeanFactoryImpl.this.createBeanFromNode(node.getChild(name), beanResolver);
                }
                catch (NodeNotFoundException e) {
                    return null;
                }
                catch (RepositoryException e) {
                    LOG.error("could not get child bean: " + e.getMessage(), (Throwable)e);
                    return null;
                }
            }

            public Iterator<Bean> getChildren() {
                return BeanFactoryImpl.this.createChildBeanIterator(node, beanResolver);
            }

            public Map<String, Object> getProperties() {
                block7: {
                    if (!this.didLoadAllProperties) {
                        this.didLoadAllProperties = true;
                        try {
                            Iterator propertiesIter = node.getProperties();
                            if (!propertiesIter.hasNext()) {
                                this.properties = Collections.EMPTY_MAP;
                            } else {
                                this.properties = new LinkedHashMap<String, Object>();
                                while (propertiesIter.hasNext()) {
                                    Property next = (Property)propertiesIter.next();
                                    if (next.isMultiValued()) {
                                        this.properties.put(next.getName(), next.getValues());
                                        continue;
                                    }
                                    this.properties.put(next.getName(), next.getValue());
                                }
                            }
                        }
                        catch (RepositoryException e) {
                            LOG.error("could not load properties of node: " + e.getMessage(), (Throwable)e);
                            if (this.properties != null) break block7;
                            this.properties = Collections.EMPTY_MAP;
                        }
                    }
                }
                return this.properties;
            }

            public Object getProperty(String name) {
                if (name == null || name.isEmpty()) {
                    return null;
                }
                if (this.properties != null && this.properties.containsKey(name)) {
                    return this.properties.get(name);
                }
                try {
                    Property prop = node.getProperty(name);
                    if (this.properties == null) {
                        this.properties = new HashMap<String, Object>();
                    }
                    Object returnValue = prop.isMultiValued() ? prop.getValues() : prop.getValue();
                    this.properties.put(name, returnValue);
                    return returnValue;
                }
                catch (PropertyNotFoundException e) {
                    return null;
                }
                catch (RepositoryException e) {
                    LOG.error("could not get property: " + e.getMessage(), (Throwable)e);
                    return null;
                }
            }

            public Object get(String name) {
                return this.getProperty(name);
            }

            public <T> T morphTo(Class<T> type) {
                if (Node.class.equals(type)) {
                    return type.cast(node);
                }
                return null;
            }

            public BeanResolver getBeanResolver() {
                return beanResolver;
            }
        };
    }

    private Iterator<Bean> createChildBeanIterator(Node node, final BeanResolver beanResolver) {
        try {
            final Iterator childIter = node.getChildren();
            return new Iterator<Bean>(){
                Bean current = null;

                @Override
                public boolean hasNext() {
                    while (this.current == null && childIter.hasNext()) {
                        this.current = BeanFactoryImpl.this.createBeanFromNode((Node)childIter.next(), beanResolver);
                    }
                    return this.current != null;
                }

                @Override
                public Bean next() {
                    if (this.current == null && !this.hasNext()) {
                        return null;
                    }
                    Bean tmp = this.current;
                    this.current = null;
                    return tmp;
                }

                @Override
                public void remove() {
                    childIter.remove();
                }
            };
        }
        catch (RepositoryException e) {
            LOG.error("could not get children: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public BeanResolver createBeanResolver(final RepositorySession repositorySession) {
        return new BeanResolver(){

            public Bean resolve(String path) {
                if (path == null || path.isEmpty()) {
                    return null;
                }
                try {
                    return BeanFactoryImpl.this.createBeanFromNode(repositorySession.getNode(PathBuilder.newInstance((String)path).build()), this);
                }
                catch (NodeNotFoundException e) {
                    return null;
                }
                catch (RepositoryException e) {
                    LOG.error("could not resolve bean of path " + path + ": " + e.getMessage(), (Throwable)e);
                    return null;
                }
            }
        };
    }

    @ObjectClassDefinition(name="Bean Factory", description="The bean factory converts node instances to beans, which have a less strict API than nodes.")
    public static @interface Configuration {
    }
}

