/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.vendor.h2;

import java.util.List;
import org.bndly.schema.api.db.Table;
import org.bndly.schema.api.mapper.RowMapper;
import org.bndly.schema.api.tx.Template;
import org.bndly.schema.api.tx.TransactionCallback;
import org.bndly.schema.api.tx.TransactionStatus;
import org.bndly.schema.api.tx.TransactionTemplate;
import org.bndly.schema.vendor.ConstraintExistenceAdapter;
import org.bndly.schema.vendor.def.CountGreaterZeroToBooleanMapper;

public class H2ConstraintExistenceAdapter
implements ConstraintExistenceAdapter {
    public boolean isConstraintDefinedOnTable(String dbSchemaName, String constraintName, Table table, TransactionTemplate transactionTemplate) {
        Object[] args;
        StringBuffer sb = new StringBuffer("SELECT COUNT(*) FROM INFORMATION_SCHEMA.CONSTRAINTS c WHERE c.CONSTRAINT_NAME=? AND c.TABLE_NAME=?");
        if (dbSchemaName != null) {
            sb.append(" AND TABLE_SCHEMA=?");
            args = new Object[]{constraintName, table.getTableName(), dbSchemaName};
        } else {
            args = new Object[]{constraintName, table.getTableName()};
        }
        final String constraintSql = sb.toString();
        List rows = (List)transactionTemplate.doInTransaction((TransactionCallback)new TransactionCallback<List<Boolean>>(){

            public List<Boolean> doInTransaction(TransactionStatus transactionStatus, Template template) {
                return template.query(constraintSql, args, (RowMapper)new CountGreaterZeroToBooleanMapper());
            }
        });
        for (Boolean b : rows) {
            if (b.booleanValue()) continue;
            return false;
        }
        return !rows.isEmpty();
    }
}

