/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.vendor.mariadb;

import org.bndly.schema.api.db.Table;
import org.bndly.schema.api.mapper.RowMapper;
import org.bndly.schema.api.tx.Template;
import org.bndly.schema.api.tx.TransactionCallback;
import org.bndly.schema.api.tx.TransactionStatus;
import org.bndly.schema.api.tx.TransactionTemplate;
import org.bndly.schema.vendor.def.CountGreaterZeroToBooleanMapper;
import org.bndly.schema.vendor.def.DefaultIndexExistenceAdapter;

public class MariaDBIndexExistenceAdapter
extends DefaultIndexExistenceAdapter {
    public boolean isIndexDefinedOnTableColumn(final String dbSchemaName, final String indexName, final Table table, TransactionTemplate template) {
        if (dbSchemaName == null) {
            throw new IllegalStateException("the dbSchemaName is required to determine if the index " + indexName + " is defined");
        }
        return (Boolean)template.doInTransaction((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus transactionStatus, Template template) {
                return (Boolean)template.queryForObject("SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS t WHERE t.TABLE_SCHEMA=? AND t.TABLE_NAME=? AND t.INDEX_NAME=?", new Object[]{dbSchemaName, table.getTableName(), indexName}, (RowMapper)new CountGreaterZeroToBooleanMapper());
            }
        });
    }
}

