/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.vendor.mysql;

import java.sql.SQLException;
import java.util.List;
import org.bndly.schema.api.exception.ConstraintViolationException;
import org.bndly.schema.api.exception.IntegrityException;
import org.bndly.schema.api.exception.SchemaException;
import org.bndly.schema.api.services.Deployer;
import org.bndly.schema.api.services.Engine;
import org.bndly.schema.impl.BadGrammarException;
import org.bndly.schema.impl.DefaultErrorCodeMapper;
import org.bndly.schema.model.UniqueConstraint;

public class MySQLErrorCodeMapper
extends DefaultErrorCodeMapper {
    @Override
    protected SchemaException map(String defaultMessage, SQLException ex, int errorCode, Engine engine) {
        String message;
        if (defaultMessage == null) {
            defaultMessage = "";
        }
        Class<SchemaException> cls = SchemaException.class;
        switch (errorCode) {
            case 1451: {
                message = "Foreign key failed during delete or update";
                cls = IntegrityException.class;
                break;
            }
            case 1452: {
                message = "Foreign key failed during add or update";
                cls = IntegrityException.class;
                break;
            }
            case 1064: {
                message = "Parse Error";
                cls = BadGrammarException.class;
                break;
            }
            case 1062: {
                message = "Duplicate entry";
                if (ex != null) {
                    String msg = ex.getMessage();
                    if (engine != null) {
                        Deployer deployer = engine.getDeployer();
                        List constraintNames = deployer.getUniqueConstraintNames();
                        UniqueConstraint uq = null;
                        for (String constraintName : constraintNames) {
                            if (!msg.contains("'" + constraintName + "'")) continue;
                            uq = deployer.getUniqueConstraintByName(constraintName);
                            break;
                        }
                        if (uq != null) {
                            return new ConstraintViolationException(uq, message, (Throwable)ex);
                        }
                    }
                }
                cls = ConstraintViolationException.class;
                break;
            }
            default: {
                message = "unknown error code: " + errorCode;
            }
        }
        return this.createSchemaException(cls, ex, defaultMessage, message);
    }
}

